#!/bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1990, 1991, 1992, 1993, 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: test the "%0" pattern replacement - it may be empty
#
tmp=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	echo 'FAILED test of the "%0" pattern replacement' 1>&2
	cd $here
	rm -rf $tmp
	exit 1
}
pass()
{
	cd $here
	rm -rf $tmp
	exit 0
}
trap "fail" 1 2 3 15

mkdir $tmp
cd $tmp

mkdir a a/b a/b/c
if test $? -ne 0 ; then fail; fi

cat > a.c << 'foo'
void
main()
{
	exit(0);
}
foo
if test $? -ne 0 ; then fail; fi

ln a.c a/b.c
if test $? -ne 0 ; then fail; fi

ln a.c a/b/c.c
if test $? -ne 0 ; then fail; fi

ln a.c a/b/c/d.c
if test $? -ne 0 ; then fail; fi

cat > Howto.cook << 'foobar'
test: a.o a/b.o a/b/c.o a/b/c/d.o;

%0%1.o: %0%1.c
{
	cc -c %0%1.c;
	if %0 then
		mv %1.o %0%1.o;
}
foobar
if test $? -ne 0 ; then fail; fi

$bin/cook -nl > /dev/null 2>&1
if test $? -ne 0 ; then fail; fi

# probably OK
pass
