/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement the strip builtin function
 */

#include <ctype.h>

#include <builtin/strip.h>
#include <mem.h>


static string_ty *strip _((string_ty *));

static string_ty *
strip(s)
	string_ty	*s;
{
	static char	*buf;
	static size_t	bufmax;
	char		*bp;
	char		*sp;
	int		space;

	if (bufmax < s->str_length)
	{
		bufmax = s->str_length;
		buf = mem_change_size(buf, bufmax);
	}
	bp = buf;
	sp = s->str_text;
	while (*sp && isspace(*sp))
		++sp;
	space = 0;
	while (*sp)
	{
		if (isspace(*sp))
			space = 1;
		else
		{
			if (space)
				*bp++ = ' ';
			*bp++ = *sp;
			space = 0;
		}
		++sp;
	}
	return str_n_from_c(buf, bp - buf);
}


int
builtin_strip(result, arg)
	wlist		*result;
	wlist		*arg;
{
	size_t		j;
	string_ty	*s;

	for (j = 1; j < arg->wl_nwords; ++j)
	{
		s = strip(arg->wl_word[j]);
		wl_append(result, s);
		str_free(s);
	}
	return 0;
}
