/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement the builtin join function
 */

#include <builtin/join.h>
#include <expr.h>


int
builtin_join(result, arg)
	wlist		*result;
	wlist		*arg;
{
	size_t		n;
	size_t		j;
	string_ty	*s;

	if ((arg->wl_nwords & 1) == 0)
	{
		expr_error
		(
			"%s: requires an even number of arguments",
			arg->wl_word[0]->str_text
		);
		return -1;
	}
	n = arg->wl_nwords / 2;
	for (j = 1; j <= n; ++j)
	{
		s = str_catenate(arg->wl_word[j], arg->wl_word[j + n]);
		wl_append(result, s);
		str_free(s);
	}
	return 0;
}
