/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement the findstring builtin function
 */

#include <builtin/findstring.h>
#include <expr.h>


static int contains _((string_ty *, string_ty *));

static int
contains(s1, s2)
	string_ty	*s1;
	string_ty	*s2;
{
	size_t		len;
	size_t		j;

	if (s1->str_length == 0)
		return 1;
	if (s1->str_length > s2->str_length)
		return 0;
	len = s2->str_length - s1->str_length;
	for (j = 0; j <= len; ++j)
	{
		if (!memcmp(s2->str_text + j, s1->str_text, s1->str_length))
			return 1;
	}
	return 0;
}


int
builtin_findstring(result, arg)
	wlist		*result;
	wlist		*arg;
{
	size_t		j;

	if (arg->wl_nwords < 2)
	{
		expr_error
		(
			"%s: requires one or more arguments",
			arg->wl_word[0]->str_text
		);
		return -1;
	}
	for (j = 2; j < arg->wl_nwords; ++j)
	{
		if (contains(arg->wl_word[1], arg->wl_word[j]))
			wl_append(result, arg->wl_word[1]);
		else
			wl_append(result, str_false);
	}
	return 0;
}
