/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement the builtin basename function
 */

#include <ac/string.h>

#include <builtin/basename.h>


int
builtin_basename(result, arg)
	wlist		*result;
	wlist		*arg;
{
	size_t		j;
	string_ty	*s;
	char		*cp;
	char		*ep;

	for (j = 1; j < arg->wl_nwords; ++j)
	{
		s = arg->wl_word[j];
		cp = strrchr(s->str_text, '/');
		if (!cp)
			cp = s->str_text;
		ep = strrchr(cp, '.');
		if (!ep || ep == cp)
			wl_append(result, s);
		else
		{
			s = str_n_from_c(s->str_text, ep - s->str_text);
			wl_append(result, s);
			str_free(s);
		}
	}
	return 0;
}
