#!/bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1990, 1991, 1992, 1993, 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: shell script to generate Makefile file
#
ALL="bin/c_incl bin/cook bin/cookfp bin/cooktime bin/find_libs \
bin/make2cook bin/roffpp"
cook_files=
c_incl_files=
find_libs_files=
roffpp_files=
cooktime_files=
txt2c_files="common/ansi.o common/arglex.o common/error.o common/mem.o \
common/mprintf.o common/str.o common/trace.o"
find_sizes_files="common/ansi.o common/arglex.o common/error.o common/mem.o \
common/mprintf.o common/str.o common/trace.o"
cookfp_files=
common=
test_files=
clean_files="core y.tab.c y.tab.h bin/txt2c bin/find_sizes"
lib_files=
man_files=
make2cook_files=
for file in $*
do
	case $file in

	cook/*.y)
		stem=`echo $file | sed 's/\.y$//'`
		clean_files="$clean_files ${stem}.gen.c ${stem}.gen.h \
${stem}.gen.o"
		cook_files="$cook_files ${stem}.gen.o"
		;;

	cook/*.c)
		stem=`echo $file | sed 's/\.c$//'`
		cook_files="$cook_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	make2cook/*.y)
		stem=`echo $file | sed 's/.y$//'`
		clean_files="$clean_files ${stem}.gen.c ${stem}.gen.h \
${stem}.gen.o"
		make2cook_files="$make2cook_files ${stem}.gen.o"
		;;

	make2cook/*.c)
		stem=`echo $file | sed 's/.c$//'`
		make2cook_files="$make2cook_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	c_incl/*.c)
		stem=`echo $file | sed 's/.c$//'`
		c_incl_files="$c_incl_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	find_libs/*.c)
		stem=`echo $file | sed 's/.c$//'`
		find_libs_files="$find_libs_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	roffpp/*.c)
		stem=`echo $file | sed 's/.c$//'`
		roffpp_files="$roffpp_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	cooktime/*.y)
		stem=`echo $file | sed 's/.y$//'`
		clean_files="$clean_files ${stem}.gen.c ${stem}.gen.h \
${stem}.gen.o"
		cooktime_files="$cooktime_files ${stem}.gen.o"
		;;

	cooktime/*.c)
		stem=`echo $file | sed 's/.c$//'`
		cooktime_files="$cooktime_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	txt2c/*.c)
		stem=`echo $file | sed 's/.c$//'`
		txt2c_files="$txt2c_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	find_sizes/*.c)
		stem=`echo $file | sed 's/.c$//'`
		find_sizes_files="$find_sizes_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	cookfp/*.c)
		stem=`echo $file | sed 's/.c$//'`
		cookfp_files="$cookfp_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	common/*.c)
		stem=`echo $file | sed 's/.c$//'`
		common_files="$common_files ${stem}.o"
		clean_files="$clean_files ${stem}.o"
		;;

	test/*/*)
		root=`basename $file .sh`
		test_files="$test_files ${root}"
		;;

	man1/*.1)
		root=`basename $file .1`
		man_files="$man_files $(mandir)/man1/$root.1"
		clean_files="$clean_files man1/${root}.h"
		;;

	man1/*.so)
		root=`basename $file .so`
		clean_files="$clean_files man1/${root}.h"
		;;

	lib/*)
		root=`basename $file`
		lib_files="$lib_files $(libdir)/$root"
		;;

	*)
		;;
	esac
done

echo ""
echo "CommonObj =" $common_files

echo ""
echo "common/lib.a: $(CommonObj)"
echo "	rm -f common/lib.a"
echo "	$(AR) qc common/lib.a $(CommonObj)"
echo "	$(RANLIB) common/lib.a"

echo ""
echo ".bin:"
echo "	-mkdir bin"
echo "	@touch .bin"

echo ""
echo "CookObj =" $cook_files

echo ""
echo "bin/cook: $(CookObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/cook $(CookObj) common/lib.a $(LIBS)"

echo ""
echo "Make2cookObj =" $make2cook_files

echo ""
echo "bin/make2cook: $(Make2cookObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/make2cook $(Make2cookObj) common/lib.a $(LIBS)"

echo ""
echo "CInclObj =" $c_incl_files

echo ""
echo "bin/c_incl: $(CInclObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/c_incl $(CInclObj) common/lib.a $(LIBS)"

echo ""
echo "FindLibsObj =" $find_libs_files

echo ""
echo "bin/find_libs: $(FindLibsObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/find_libs $(FindLibsObj) common/lib.a $(LIBS)"

echo ""
echo "RoffppObj =" $roffpp_files

echo ""
echo "bin/roffpp: $(RoffppObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/roffpp $(RoffppObj) common/lib.a $(LIBS)"

echo ""
echo "CooktimeObj =" $cooktime_files

echo ""
echo "bin/cooktime: $(CooktimeObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/cooktime $(CooktimeObj) common/lib.a $(LIBS)"

echo ""
echo "Txt2cObj =" $txt2c_files

echo ""
echo "bin/txt2c: $(Txt2cObj) .bin"
echo "	@sleep 1"
echo "	$(CC) $(LDFLAGS) -o bin/txt2c $(Txt2cObj) $(LIBS)"
echo "	@sleep 1"

echo ""
echo "FindSizesObj =" $find_sizes_files

echo ""
echo "bin/find_sizes: $(FindSizesObj) .bin"
echo "	@sleep 1"
echo "	$(CC) $(LDFLAGS) -o bin/find_sizes $(FindSizesObj) $(LIBS)"
echo "	@sleep 1"

echo ""
echo "common/find_sizes.h: bin/find_sizes"
echo "	bin/find_sizes > common/find_sizes.h"
echo "	@sleep 1"

echo ""
echo "CookfpObj =" $cookfp_files

echo ""
echo "bin/cookfp: $(CookfpObj) common/lib.a .bin"
echo "	$(CC) $(LDFLAGS) -o bin/cookfp $(CookfpObj) common/lib.a $(LIBS)"

echo ""
echo "sure:" $test_files
echo "	@echo Passed All Tests"

echo ""
echo "clean-obj:"
echo "	rm -f" $clean_files

echo ""
echo "clean: clean-obj"
echo "	rm -f" $ALL

echo ""
echo "distclean: clean"
echo "	rm -f Makefile common/config.h config.status"

echo ""
echo ".libdir:"
echo "	-mkdir $(libdir)"
echo "	-chmod 755 $(libdir)"
echo "	@touch .libdir"

ALLinst=
for f in $ALL
do
	root=`basename $f`
	ALLinst="$ALLinst $(bindir)/$root"

	echo ""
	echo "$(bindir)/$root: $f"
	echo "	$(INSTALL_PROGRAM) $f $(bindir)/$root"
done

echo ""
echo "install-bin:" $ALLinst

echo ""
echo "install-man:" $man_files

echo ""
echo "install-lib:" $lib_files

echo ""
echo "install: install-bin install-man install-lib"

exit 0
