#! /bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1990, 1991, 1992, 1993, 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: shell script to generate Makefile fragment for each source file
#
case $# in
2)
	;;
*)
	echo "usage: $0 filename resolved-filename" 1>&2
	exit 1
	;;
esac
file="$1"
rfn="$2"

case $file in

*/*.y)
	root=`basename $file .y`
	stem=`echo $file | sed 's/\.y$//'`
	dir=`echo $file | sed 's|/.*||'`

	case $file in
	cook/parse.y)
		numconf="1 shift/reduce"
		;;
	cooktime/date.y)
		numconf="8 shift/reduce"
		;;
	make2cook/gram.y)
		numconf="1 shift/reduce"
		;;
	*)
		numconf="no"
		;;
	esac

	echo ""
	echo "${stem}.gen.c ${stem}.gen.h: $file"
	echo "	@echo Expect $numconf conflicts:"
	echo "	$(YACC) -d $file"
	echo "	sed -e 's/[yY][yY]/${root}_/g' y.tab.c > ${stem}.gen.c"
	echo "	sed -e 's/[yY][yY]/${root}_/g' y.tab.h > ${stem}.gen.h"
	echo "	rm y.tab.c y.tab.h"

	depfile=`echo $file | sed 's/\.y$/.gen.d/'`
	if [ -r $depfile ]; then
		dep=`sed -e '1d' -e '$d' -e 's_.arch]/__' $depfile`
	else
		depfile=`echo $rfn | sed 's/\.y$/.gen.d/'`
		if [ -r $depfile ]; then
			dep=`sed -e '1d' -e '$d' -e 's_.arch]/__' $depfile`
		fi
	fi

	echo ""
	echo "${stem}.gen.o: ${stem}.gen.c" $dep
	echo "	$(CC) $(CFLAGS) -I$dir -Icommon -c ${stem}.gen.c"
	echo "	mv ${root}.gen.o ${stem}.gen.o"
	;;

*/*.c)
	root=`basename $file .c`
	stem=`echo $file | sed 's/\.c$//'`
	dir=`echo $file | sed 's|/.*||'`

	depfile=`echo $file | sed 's/\.c$/.d/'`
	if [ -r $depfile ]; then
		dep=`sed -e '1d' -e '$d' -e 's_.arch]/__' $depfile`
	else
		depfile=`echo $rfn | sed 's/\.c$/.d/'`
		if [ -r $depfile ]; then
			dep=`sed -e '1d' -e '$d' -e 's_.arch]/__' $depfile`
		fi
	fi

	if [ ${root} = option ]
	then
		libdir="-D'LIBDIR=\"$(libdir)\"'"
	fi

	echo ""
	echo "${stem}.o: $file" $dep
	echo "	$(CC) $(CFLAGS)" $libdir "-I$dir -Icommon -c $file"
	echo "	mv ${root}.o ${stem}.o"
	;;

man1/*.1)
	root=`basename $file .1`
	echo ""
	echo "man1/$root.h: $file bin/txt2c"
	echo "	bin/txt2c $file man1/$root.h"

	echo ""
	echo "$(mandir)/man1/$root.1: $file bin/roffpp"
	echo "	bin/roffpp -Iman1 $file tmp"
	echo "	$(INSTALL_DATA) tmp $(mandir)/man1/$root.1"
	echo "	@rm tmp"
	;;

man1/*.so)
	root=`basename $file .so`
	echo ""
	echo "man1/$root.h: $file bin/txt2c"
	echo "	bin/txt2c $file man1/$root.h"
	;;

lib/*)
	root=`basename $file`
	echo ""
	echo "$(libdir)/$root: $file .libdir"
	echo "	$(INSTALL_DATA) $file $(libdir)/$root"
	;;

test/*/*)
	root=`basename $file .sh`
	echo ""
	echo "$root: $file all"
	echo "	$(SH) $file"
	;;

*)
	;;
esac
exit 0
