'\" t
.\"	cook - file construction tool
.\"	Copyright (C) 1992, 1993, 1994, 1995 Peter Miller;
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 2 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" MANIFEST: source of the BUILDING file
.\"
.TH building cook
.so ../doc/version.so
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.SH NAME
cook \- a file construction tool
.SH SPACE REQUIREMENTS
You will need about 5MB to unpack and build the
.I cook
program.
Your milage may vary.
.br
.ne 1i
.SH SITE CONFIGURATION
The
.B cook
package is configured using the
.I configure
program included in this distribution.
.PP
The
.I configure
shell script attempts to guess correct values for
various system-dependent variables used during compilation,
and creates the
.I Makefile
and
.I common/config.h
files.
It also creates a shell script
.I config.status
that you can run in the future to recreate the current configuration.
.PP
Normally,
you just
.I cd
to the directory containing 
.IR cook "'s"
source code and type
.RS
.ft CW
.nf
\fB% \fP./configure
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
If you're using
.I csh
on an old version of System V,
you might need to type
.RS
.ft CW
.nf
\fB% \fPsh configure
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
instead to prevent
.I csh
from trying to execute
.I configure
itself.
.PP
Running
.I configure
takes a minute or two.
While it is running,
it prints some messages that tell what it is doing.
If you don't want to see the messages,
run
.I configure
with its standard output redirected to
.IR /dev/null ;
for example,
.RS
.FT CW
.nf
\fB% \fP./configure > /dev/null
\bB%\fP
.fi
.ft R
.RE
.PP
To compile the
.B cook
package in a different directory from the one
containing the source code,
you must use a version of
.I make
that supports the
.I VPATH variable,
such as
.IR "GNU make" .
.I cd
to the directory where you want the object files and executables to go and run
the
.I configure
script.
.I configure
automatically checks for the source code in the directory that
.I configure
is in and in
.IR \&..
(the parent directory).
If for some reason
.I configure
is not in the source code directory that you are configuring,
then it will report that it can't find the source code.
In that case,
run
.I configure
with the option \f(CW--srcdir=\fP\fIDIR\fP,
where
.I DIR
is the directory that contains the source code.
.PP
By default,
.I configure
will arrange for the
.I "make install"
command to install the
.B cook
package's files in
.IR /usr/local/bin ,
.IR /usr/local/man ,
etc.
You can specify an installation prefix other than
.I /usr/local
by giving
.I configure
the option \f(CW--prefix=\fP\fIPATH\fP.
.PP
You can specify separate installation prefixes for
architecture-specific files and architecture-independent files.
If you give
.I configure
the option \f(CW--exec-prefix=\fP\fIPATH\fP
the
.B cook
package will use
.I PATH
as the prefix for installing programs and libraries.
Data files and documentation will still use the regular prefix.
Normally,
all files are installed using the same prefix.
.PP
.I configure
ignores any other arguments that you give it.
.br
.ne 2i
.PP
On systems that require unusual options for compilation or linking
that the
.I cook
package's
.I configure
script does not know about,
you can give
.I configure
initial values for variables by setting them in the environment.
In Bourne-compatible shells,
you can do that on the command line like this:
.RS
.ft CW
.nf
\fB$ \fPCC='gcc -traditional' LIBS=-lposix ./configure
\fI\&...lots of output...\fP
\fB$\fP
.fi
.ft R
.RE
Here are the
.I make
variables that you might want to override with
environment variables when running
.IR configure .
.TP 8n
Variable: CC
C compiler program.
The default is
.IR cc .
.TP 8n
Variable: INSTALL
Program to use to install files.
The default is
.I install
if you have it,
.I cp
otherwise.
.TP 8n
Variable: LIBS
Libraries to link with,
in the form \f(CW-l\fP\fIfoo\fP \f(CW-l\fP\fIbar\fP.
The
.I configure
script will append to this,
rather than replace it.
.PP
If you need to do unusual things to compile the package,
the author encourages you to figure out how
.I configure
could check whether to do them,
and mail diffs or instructions to the author
so that they can be included in the next release.
.br
.ne 1i
.SH BUILDING COOK
All you should need to do is use the
.RS
.ft CW
.nf
\fB% \fPmake
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command and wait.
When this finishes you should see a directory called
.I bin
containing nine files:
.IR c_incl ,
.IR cook ,
.IR cookfp ,
.IR cooktime ,
.IR find_libs ,
.IR find_sizes ,
.IR make2cook ,
.IR roffpp
and
.IR txt2c .
.TP 8n
.B cook
.The
.I cook
program is a file construction tool,
and may invoke the following tools
in some of its recipes.
.TP 8n
.B cookfp
The
.I cookfp
program is a utility distributed with
.I cook
which calculates the fingerprints of files.
It uses the same algorithm as the fingerprints used by
.I cook
itself.
For more information, see
.IR cook (1)
and
.IR cookfp (1).
.TP 8n
.B cooktime
The
.I cooktime
program is a utility distributed with
.I cook
which allows the time-last-modified and time-last-accessed
stamps of files to be set to specific times.
For more information, see
.IR cooktime (1).
.TP 8n
.B c_incl
The
.I c_incl
program is a utility distributed with
.I cook
which examines C files and determines all the files it includes
directly and indirectly.
For more information, see
.IR c_incl (1).
.TP 8n
.B find_libs
The
.I find_libs
program is a utility distributed with
.I cook
which tracks down the names of library files,
given cc-style library options (-L and -l).
For more information, see
.IR find_libs (1).
.TP 8n
.B find_sizes
The
.I find_sizes
program is a utility used to build the
.I cook
package;
it is not intended for general use and should not be installed.
.TP 8n
.B roffpp
The
.I roffpp
program is a utility distributed with
.I cook
which acts as a proprocessor for *roff
files,
removing source (\&.so) directives.
It accepts include search path command line options
just as \fI/lib/cpp\fP does.
For more information, see
.IR roffpp (1).
.TP 8n
.B make2cook
The
.I make2cook
program is a utility to help convert Makefiles into cookbooks.
An exact 1:1 semantic mapping is not possible,
so some addition editing is often required.
.TP 8n
.B txt2c
The
.I txt2c
program is a utility used to build the
.I cook
package;
it is not intended for general use and should not be installed.
.br
.ne 1.5i
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
\fB% \fPmake clean
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
To remove all of the above files, and also remove the
.I Makefile
and
.I common/config.h
and
.I config.status
files, use the
.RS
.ft CW
.nf
\fB% \fPmake distclean
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
.PP
The file
.I aux/configure.in
is used to create
.I configure
by a GNU program called
.IR autoconf .
You only need to know this if you want to regenerate
.I configure
using a newer version of
.IR autoconf .
.br
.ne 1i
.SH TESTING COOK
The
.I cook
program comes with a test suite.
To run this test suite, use the command
.RS
.ft CW
.nf
\fB% \fPmake sure
\fI\&...lots of output...\fP
.if n \fBPassed All Tests\fP
.if t \f(CBPassed All Tests\fP
\fB%\fP
.fi
.ft R
.RE
.PP
The tests take a few seconds each,
with a few very fast,
and a couple very slow,
but it varies greatly depending on your CPU.
.PP
If all went well, the message
.RS
.ft CW
Passed All Tests
.ft R
.RE
should appear at the end of the make.
.br
.ne 1i
.SH INSTALLING COOK
As explained in the
.I "SITE CONFIGURATION"
section, above,
the
.I cook
package is installed under the
.I /usr/local
tree by default.
Use the \f(CW--prefix=\fP\fIPATH\fP option to
.I configure
if you want some other path.
.PP
All that is required to install the
.I cook
package is to use the
.RS
.ft CW
.nf
\fB% \fPmake install
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
Control of the directories used may be found in the first
few lines of the
.I Makefile
file if you want to bypass the
.I configure
script.
.br
.ne 1i
.SH PRINTED MANUALS
This distribution contains the sources to
all of the documentation for
.IR cook .
The author used the GNU groff package
and a postscript printer to prepare the documentation.
If you do not have this software,
you will need to substitute commands appropriate to your site.
.PP
To print copies of the
.I README
and
.I BUILDING
files,
the following commands may be used
.RS
.ft CW
.nf
\fB% \fPcd aux
\fB% \fPgroff -s -t -man *.man | lpr
\fB% \fPcd ..
\fB%\fP
.fi
.ft R
.RE
This will produce about 4 pages.
The "-s" flag means preprocess with
.IR soelim (1),
and the "-t" flag means preprocess with
.IR tbl (1).
.PP
To print copies of the manual entries,
the following commands may be used
.RS
.ft CW
.nf
\fB% \fPcd man1
\fB% \fPgroff -s -t -man *.1 | lpr
\fB% \fPcd ..
\fB%\fP
.fi
.ft R
.RE
This will produce about 8 pages.
The "-s" flag means preprocess with
.IR soelim (1),
and the "-t" flag means preprocess with
.IR tbl (1).
.PP
To print a copy of the Reference Manual,
the following commands may be used
.RS
.ft CW
.nf
\fB% \fPcd doc
\fB% \fPgroff -s -t -mm refman.t | lpr
\fB% \fPcd ..
\fB%\fP
.fi
.ft R
.RE
This will produce about 35 pages.
The "-s" flag means preprocess with
.IR soelim (1),
the "-t" flag means preprocess with
.IR tbl (1).
Alternatively,
you could get a PostScript copy of the Reference Manual from the archive site
given in the
.I README
file.
.br
.ne 1i
.SH GETTING HELP
If you need assistance with the
.I cook
program,
please do not hesitate to contact the author at
.RS
.ft CW
Peter Miller <pmiller@bmr.gov.au>
.ft R
.RE
Any and all feedback is welcome.
.PP
When reporting problems,
please include the version number
given by the
.RS
.ft CW
.nf
\fB% \fPcook -version
.if n \fBcook version\fP \fI\*(V)\fP
.if t \f(CBcook version\fP \fI\*(V)\fP
\fI\&...warranty disclaimer...\fP
\fB%\fP
.fi
.ft R
.RE
command.
Please do not send this example;
run the program for the exact version number.
.PP
In the
.I common/main.h
file, there is a define of
.I DEBUG
in comments.
If the comments are removed,
extensive debugging is turned on.
This causes some performance loss,
but performs much run-time checking
and adds the
.B -TRACIng
command line option.
.PP
When the
.B -TRACing
option is followed by one or more file names,
it turns on execution traces in those source files.
It is best to put this option on the end of the command,
so that the names of the files to be traced are not confused
with any other filenames or strings on the command line.
.br
.ne 2i
.SH COPYRIGHT
.I cook
version \*(v)
.br
Copyright
.if n (C)
.if t \(co
\*(Y) Peter Miller;
All rights reserved.
.PP
The
.I cook
package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.PP
It should be in the
.I LICENSE
file included with this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l l l.
Peter Miller;UUCP;uunet!munnari!bmr.gov.au!pmiller
\f(CW/\e/\e*\fP;Internet;pmiller@bmr.gov.au
.TE
