#----------------------------------------------------------------------
# Tix application context class
#
#
tixClass tixAppContext {
    -superclass {}
    -classname  TixAppContext
    -method {
	cget configure addbitmapdir filedialog getbitmap getimage
	option setbitmap
    }
    -flag {
	-binding -debug -filedialog -fontset -grabmode -haspixmap
	-libdir -scheme
    }
    -readonly {
	-haspixmap
    }
    -configspec {
	{-binding    	TK}
	{-debug      	false}
	{-filedialog    {}}
	{-fontset    	TK}
	{-grabmode 	global}
	{-haspixmap 	0}
	{-libdir     	{}}
	{-scheme     	TK}
    }
    -alias {
    }
}

proc tixAppContext::Constructor {w} {
    upvar #0 $w data
    global tix_priv
    global tix_library

    set data(isStartUp) 1
    # Thses options were set when tixwish started up
    #
    set data(-binding)	$tix_priv(-binding)
    set data(-debug)	$tix_priv(-debug)
    set data(-fontset)	$tix_priv(-fontset)
    set data(-libdir)	$tix_priv(-libdir)
    set data(-scheme)	$tix_priv(-scheme)
    set data(-libdir)	$tix_library
	
    # Enable/Disable Intrinsics debugging
    #
    if {$data(-debug)} {
	set tix_priv(debug) 1
    } else {
	set tix_priv(debug) 0
    }

    tixAppContext::config-fontset $w $data(-fontset)
    tixAppContext::config-scheme  $w $data(-scheme)

    tixAppContext::BitmapInit $w
    tixAppContext::FileDialogInit $w

    if {[tixGetBoolean -nocomplain $data(-debug)]} {
	# For widget programming, it is more convient to have the error
	# message printed on the terminal. For some extensive usage of
	# bindings, suce as in the case of tixBalloon, the default
	# therror just doesn't work.
	#
	proc _tkerror {err} {
	    global errorInfo
	    puts $err
	    puts $errorInfo
	}
    }

    # Force the "." window to accept the new Tix options
    #
    foreach spec [. configure] {
	if {[llength $spec] > 2} {
	    set flag  [lindex $spec 0]
	    set name  [lindex $spec 1]
	    set class [lindex $spec 2]
	    set value [option get . $name $class]
	    catch {. config $flag $value}
	}
    }
    set data(isStartUp) 0
}

#----------------------------------------------------------------------
#  Configurations
#
#----------------------------------------------------------------------
proc tixAppContext::config-fontset {w value} {
    upvar #0 $w data
    global tix_priv

    set data(-fontset) $value

    #-----------------------------------
    # Initialization of options database
    #-----------------------------------
    # Load the fontset
    #
    if [file exists $data(-libdir)/pref/$data(-fontset).fsc] {
	source $data(-libdir)/pref/$data(-fontset).fsc
	tixAppContext::CheckFontSets $w
	tixPref:SetFontSet
    } else {
	puts stderr "\aError: cannot use fontset \"$data(-fontset)\""
	puts stderr "       Using default fontset "
	tixSetDefaultFontset
	tixAppContext::CheckFontSets $w
    }
}

proc tixAppContext::config-scheme {w value} {
    upvar #0 $w data
    global tix_priv

    if {! $data(isStartUp)} {
	option clear
	tixAppContext::config-fontset $w $data(-fontset)
    }
    set data(-scheme) $value

    # Load the color scheme
    #
    if [file exists $data(-libdir)/pref/$data(-scheme).csc] {
	source $data(-libdir)/pref/$data(-scheme).csc
	if {[winfo depth .] >= 8} {
	    tixPref:SetScheme-Color
	} else {
	    tixPref:SetScheme-Mono
	}
    } else {
	puts stderr "\aError: cannot use color scheme \"$data(-scheme)\""
	puts stderr "       Using default color scheme"
	if {[winfo depth .] >= 8} {
	    tixSetDefaultScheme-Color
	} else {
	    tixSetDefaultScheme-Mono
	}
    }
}

#----------------------------------------------------------------------
#  Private methods
#
#----------------------------------------------------------------------
proc tixAppContext::BitmapInit {w} {
    upvar #0 $w data

    # See whether we have pixmap extension
    #
    set data(-haspixmap) true

    # Dynamically set the bitmap directory
    #
    set data(bitmapdirs) $data(-libdir)/bitmaps
}

proc tixAppContext::FileDialogInit {w} {
    upvar #0 $w data

    if {$data(-filedialog) == {}} {
	set data(-filedialog) [option get . fileDialog FileDialog]
    }
    if {$data(-filedialog) == {}} {
	set data(-filedialog) tixFileSelectDialog
    }
}

#----------------------------------------------------------------------
# If a font in the fontset is not available, use a default fontset.
#
proc tixAppContext::CheckFontSets  {w} {
    upvar #0 $w data
    global tixOption

    set default_font "fixed"
    set options {font bold_font menu_font italic_font courier_font}

    set lab [label .tix-xxx-test]
    foreach opt $options {
	if [catch {$lab config -font $tixOption($opt)}] {
	    puts stderr \
		"\aError: cannot use font \"$tixOption($opt)\" as \"$opt\""
	    puts  stderr \
		"       using \"$default_font\" instead"

	    set tixOption($opt) $default_font
	}
    }
    destroy $lab
}

#----------------------------------------------------------------------
# 	Public methods
#----------------------------------------------------------------------
proc tixAppContext::addbitmapdir {w bmpdir} {
    upvar #0 $w data

    if {[lsearch $data(bitmapdirs) $bmpdir] == "-1"} {
	set data(bitmapdirs) [concat $bmpdir $data(bitmapdirs)]
    }
}

proc tixAppContext::getimage {w name} {
    upvar #0 $w data

    if {[info exists data(img:$name)]} {
	return $data(img:$name)
    }

    foreach dir $data(bitmapdirs) {
	if [file exists $dir/$name.xpm] {
	    if {![catch {
		set data(img:$name) \
		    [image create pixmap -file $dir/$name.xpm]
	    }]} {
		break
	    }
	}
	if [file exists $dir/$name.xbm] {
	    if {![catch {
		set data(img:$name) \
		    [image create bitmap -file $dir/$name.xbm]
	    }]} {
		break
	    }
	}
	if [file exists $dir/$name] {
	    if {![catch {
		set data(img:$name) \
		    [image create bitmap -file $dir/$name]
	    }]} {
		break
	    }
	}
    }


    if {[info exists data(img:$name)]} {
	return $data(img:$name)
    } else {
	error "image file \"$name\" cannot be found"
    }
}


proc tixAppContext::getbitmap {w bitmapname} {
    upvar #0 $w data

    if {[info exists data(bmp:$bitmapname)]} {
	return $data(bmp:$bitmapname)
    } else {
	set ext [file extension $bitmapname]
	if {$ext == ""} {
	    set ext .xbm
	}

	# This is the fallback value. If we can't find the bitmap in
	# the bitmap directories, then use the name of the bitmap
	# as the default value.
	#
	set data(bmp:$bitmapname) $bitmapname

	foreach dir $data(bitmapdirs) {
	    case $ext {
		.ppm {
		    if [file exists $dir/$bitmapname] {
			set data(bmp:$bitmapname) \
			    [image create photo -file $dir/$bitmapname]
			break
		    }
		}
		.xbm {
		    if [file exists $dir/$bitmapname.xbm] {
			set data(bmp:$bitmapname) @$dir/$bitmapname.xbm
			break
		    }
		    if [file exists $dir/$bitmapname] {
			set data(bmp:$bitmapname) @$dir/$bitmapname
			break
		    }
		}
		default {
		    if [file exists $dir/$bitmapname] {
			set data(bmp:$bitmapname) @$dir/$bitmapname
			break
		    }
		}
	    }
	}

	return $data(bmp:$bitmapname)
    }
}

proc tixAppContext::filedialog {w {type tixFileSelectDialog}} {
    upvar #0 $w data

    if {$type == {}} {
	set type $data(-filedialog)
    }
    if {![info exists data(filedialog,$type)]} {
	set data(filedialog,$type) {}
    }

    if {$data(filedialog,$type) == {} || ![winfo exists $data(filedialog,$type)]} {
	set data(filedialog,$type) [$type .tixapp_filedialog_$type]
    }

    return $data(filedialog,$type)
}

proc tixAppContext::option {w action option {value {}}} {
    upvar #0 $w data
    global tixOption

    if {$action == "get"} {
	return $tixOption($option)
    }
}
