%{

#ifndef lint
static char *RCSid = "$Id: yaccsrc.y,v 1.10 1992/04/05 20:37:15 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: yaccsrc.y,v $
 * Revision 1.10  1992/04/05  20:37:15  anders
 * Added copyright notice
 * Made changes to DROP, ADDRESS and TRACE
 *
 * Revision 1.9  1992/03/22  18:58:46  anders
 * Made strings allocated through stralloc() allign to 8 byte
 *    boundaries.
 *
 * Revision 1.8  1992/03/22  00:42:40  anders
 * Added #include <stdio.h> as this is not done in rexx.h any more.
 * Added #include <alloca.h> for use on SGI
 * Removed %expect 7 directive, which is not compatible with yacc
 *
 * Revision 1.7  1992/03/01  19:29:33  anders
 * Changed the support for templates, to fix a bug.
 *
 * Revision 1.6  1990/12/11  00:35:33  anders
 * Removed (another) bug related to line numbers (probably the last
 *     one!). Just an expression (used for external commands) does not
 *     have a 'reserved' word, and a special dummy rule had to be
 *     inserted.
 *
 * Revision 1.4  90/12/11  00:00:15  anders
 * Removed bug that assigned wrong line/character number to the 
 *     leave statement. There might still be some trouble with getting 
 *     the linenumbers of the statements correct.
 * 
 * Revision 1.3  90/12/10  18:41:09  anders
 * Removed bug: the linenumbers of the nop-statement were shifted one
 *     line up. The tline/tchar variables used instead of next{line,char}
 * 
 * Revision 1.2  90/12/10  04:10:45  anders
 * Removed bug which set linenumbers to incorrect values. They got 
 *     the (integer) value of a pointer.
 * 
 * Revision 1.1  90/08/08  02:28:52  anders
 * Initial revision
 * 
 * Revision 1.1  90/08/08  02:23:11  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#if defined(SGI)
#include <alloca.h>
#endif
#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>


#define YYSTYPE nodeptr

extern nodeptr rootnode ;
extern char retvalue[] ;
extern int nextstart, nextline, tline, tstart ;

nodeptr makenode( int type, int numb, ... ) ;
char *stralloc( char *ptr ) ;
void checkdosyntax( nodeptr this ) ;
void newlabel( nodeptr this ) ;

%}

%token ADDRESS ARG COMMAND CALL DO TO BY FOR WHILE UNTIL EXIT IF THEN 
%token ELSE ITERATE INTERPRET LEAVE NOP NUMERIC PARSE EXTERNAL SOURCE
%token VAR VALUE WITH PROCEDURE EXPOSE PULL PUSH QUEUE RETURN SAY 
%token SELECT WHEN DROP OTHERWISE SIGNAL ON OFF ERROR SYNTAX HALT 
%token NOVALUE TRACE END NULLSTRING UPPER INTERMEDIATES LABELS 
%token ASSIGNMENTVARIABLE STATSEP FOREVER ALL COMMANDS ERRORS 
%token NORMAL NEGATIVE RESULTS SCAN DIGITS FORM FUZZ SCIENTIFIC
%token ENGINEERING BANGBANG BANGWHAT BANG WHATBANG WHATWHAT WHAT 
%token NOT CONCATENATE MODULUS GTE GT LTE LT DIFFERENT EQUALEQUAL
%token NOTEQUALEQUAL OFFSET SPACE EXP XOR PLACEHOLDER
%token CONSYMBOL SIMSYMBOL EXFUNCNAME INFUNCNAME LABEL DOVARIABLE
%token SYMBOL HEXSTRING STRING VERSION LINEIN WHATEVER

%start prog

%left '|' XOR
%left '&'
%nonassoc '=' '>' '<' DIFFERENT GTE GT LT LTE EQUALEQUAL NOTEQUALEQUAL
%left CONCATENATE SPACE CCAT
%left '+' '-'
%left '*' '/' '%' MODULUS
%left EXP
%left UMINUS UPLUSS NOT

%{ 
#define YYDEBUG 0
%}

%%

prog         : nseps stats             { rootnode = makenode(X_PROGRAM,1,$2);}
             | nseps                   { rootnode = NULL ; }
             ;


stats        : statement stats         { $$ = makenode(X_STATS,2,$1,$2) ; }
             | statement               { $$ = makenode(X_STATS,2,NULL,$1) ; }
             ;

nstats       : stats                   { $$ = $1 ; }
             |                         { $$ = NULL ; }
             ;

nseps        : seps
             | 
             ;

seps         : STATSEP seps
             | STATSEP 
             ;

statement    : address_stat
             | expr_stat
             | arg_stat
             | call_stat
             | do_stat
             | drop_stat
             | exit_stat
             | if_stat 
             | ipret_stat
             | iterate_stat
             | label_stat
             | leave_stat
             | nop_stat
             | numeric_stat
             | parse_stat
             | proc_stat
             | pull_stat
             | push_stat
             | queue_stat
             | return_stat
             | say_stat
             | select_stat
             | signal_stat
             | trace_stat
             | upper_stat
             | assignment
             ;

call         : CALL		       { $$ = makenode(X_CALL,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
do           : DO 		       { $$ = makenode(X_DO,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
exit         : EXIT		       { $$ = makenode(X_EXIT,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
if           : IF		       { $$ = makenode(X_IF,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
iterate      : ITERATE  	       { $$ = makenode(X_ITERATE,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
leave        : LEAVE		       { $$ = makenode(X_LEAVE,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
return       : RETURN		       { $$ = makenode(X_RETURN,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
say          : SAY		       { $$ = makenode(X_SAY,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
signal_lab   : SIGNAL		       { $$ = makenode(X_SIG_LAB,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
address      : ADDRESS                 { $$ = makenode(X_ADDR_N,0) ;
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
arg          : ARG                     { $$ = makenode(X_PARSE_ARG_U,0) ;
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
drop         : DROP                    { $$ = makenode(X_DROP,0) ;
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
interpret    : INTERPRET               { $$ = makenode(X_IPRET,0) ;
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
label        : LABEL                   { $$ = makenode(X_LABEL,0) ;
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
nop          : NOP                     { $$ = makenode(X_NULL,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; }
numeric      : NUMERIC                 { $$ = makenode(0,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
parse        : PARSE                   { $$ = makenode(0,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
proc         : PROCEDURE               { $$ = makenode(X_PROC,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
pull         : PULL                    { $$ = makenode(X_PULL,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
push         : PUSH                    { $$ = makenode(X_PUSH,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
queue        : QUEUE                   { $$ = makenode(X_QUEUE,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
select       : SELECT                  { $$ = makenode(X_SELECT,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
signal       : SIGNAL                  { $$ = makenode(X_SIG_LAB,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
when         : WHEN                    { $$ = makenode(X_WHEN,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
otherwise    : OTHERWISE               { $$ = makenode(X_OTHERWISE,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
trace        : TRACE                   { $$ = makenode(X_TRACE,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
upper        : UPPER                   { $$ = makenode(X_UPPER_VAR,0) ; 
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;
  
address_stat : address VALUE expr seps { $$ = $1 ;
                                         $$->type = X_ADDR_V ;
                                         $$->p[0] = $3 ; }
             | address                 { $$ = $1 ;
                                         $$->type = X_ADDR_S ; }
             | address asym nexpr seps { $$ = $1 ;
                                         $$->type = X_ADDR_N ;
                                         $$->p[0] = $3 ;
                                         $$->name = (char *)$2 ; }
             ;

asym         : simsymb
             | string 
             ;               

arg_stat     : arg templs seps         { $$ = $1 ;
                                         $$->p[0] = $2 ; }
             ;

call_stat    : call asymbol whitespace exprs seps { $$ = $1 ;
                                         $$->p[0] = $4 ;
                                         $$->name = (char *) $2 ; }
             ;

whitespace   : SPACE
             | CCAT
	     |
             ; 

nothing      :                         { $$ = makenode(X_COMMAND,0) ; 
                                         $$->charnr = tstart ; 
				         $$->lineno = tline ; }
             ;

expr_stat    : nothing expr seps       { $1->p[0] = $2 ; 
                                         $$ = $1 ; } 
             ;

end          : END nsimsymb            { $$ = makenode(X_END,0) ;
                                         $$->name = (char*)($2) ;
                                         $$->lineno = tline ;
                                         $$->charnr = tstart ; } ;

do_stat      : do repetitor conditional seps nstats end seps 
                                       { $$ = $1 ;
                                         $$->p[0] = $2 ;
                                         $$->p[1] = $3 ;
                                         $$->p[2] = $5 ; 
                                         $$->p[3] = $6 ; 
                                         if (($$->p[0])&&($$->p[0]->name)&&
					     ($$->p[3]->name)&&
                                      (strcmp($$->p[3]->name,$$->p[0]->name)))
                                           exiterror( ERR_UNMATCHED_END ) ;
                                       }
					    
             ;

repetitor    : dovar '=' expr tobyfor tobyfor tobyfor
                                       { $$ =makenode(X_REP,4,$3,$4,$5,$6) ;
                                         $$->name = (char *)$1 ; 
                                         checkdosyntax($$) ; }
             | FOREVER                 { $$ = makenode(X_REP_FOREVER,0) ; }
             | expr                    { $1 = makenode(X_DO_FOR,1,$1) ;
                                         $$ = makenode(X_REP,2,NULL,$1) ; } 
             |                         { $$ = NULL ; }  
             ; 

dovar        : DOVARIABLE              { $$ = (nodeptr)stralloc(retvalue) ; }
             ;

tobyfor      : TO expr                 { $$ = makenode(X_DO_TO,1,$2) ; }
             | FOR expr                { $$ = makenode(X_DO_FOR,1,$2) ; }
             | BY expr                 { $$ = makenode(X_DO_BY,1,$2) ; }
             |			       { $$ = NULL ; }
             ;

conditional  : WHILE expr              { $$ = makenode(X_WHILE,1,$2) ; }
             | UNTIL expr              { $$ = makenode(X_UNTIL,1,$2) ; }
             |                         { $$ = NULL ; }
             ;

drop_stat    : drop vars seps          { $$ = $1 ;
                                         $$->p[0] = $2 ; }
             ;

exit_stat    : exit nexpr seps         { $$ = $1 ;
                                         $$->p[0] = $2 ; }
             ;

if_stat      : if expr nseps THEN nseps statement  
                                       { $$ = $1 ;
                                         $$->p[0] = $2 ;
                                         $$->p[1] = $6 ; } 
             | if expr nseps THEN nseps statement ELSE nseps statement 
                                       { $$ = $1 ;
                                         $$->p[0] = $2 ;
                                         $$->p[1] = $6 ;
                                         $$->p[2] = $9 ; } 
             ;

ipret_stat   : interpret expr seps     { $$ = $1 ;
                                         $$->p[0] = $2 ; }
             ;


iterate_stat : iterate simsymb seps    { $$ = $1 ; 
                                         $$->name = (char *) $2 ; }
             | iterate seps            { $$ = $1 ; }
             ;

label_stat   : labelname nseps         { $$ = $1 ; 
                                         newlabel( $1 ) ; }
             ;

labelname    : label                   { $$ = $1 ;
                                         $$->name = stralloc(retvalue) ; }
             ;

leave_stat   : leave simsymb seps      { $$ = $1 ;
                                         $$->name = (char *) $2 ; } 
             | leave seps              { $$ = $1 ; }
             ;

nop_stat     : nop seps                { $$ = $1 ; }
             ;


numeric_stat : numeric DIGITS nexpr seps   
                                       { $$ = $1 ;
                                         $$->type = X_NUM_D ; 
                                         $$->p[0] = $3 ; }
             | numeric FORM form_expr seps 
                                       { $$ = $1 ;
                                         $$->type = X_NUM_F ; 
                                         $$->p[0] = $3 ; }
             | numeric FUZZ nexpr seps { $$ = $1 ;
                                         $$->type = X_NUM_FUZZ ; 
                                         $$->p[0] = $3 ; }
             ;

form_expr    : SCIENTIFIC              { $$ = makenode(X_NUM_SCI,0) ; } 
             | ENGINEERING             { $$ = makenode(X_NUM_ENG,0) ; }
             |                         { $$ = NULL ; }
             ;

parse_stat   : parse parse_param template seps
                                       { $$ = $1 ;
                                         $$->type = X_PARSE ; 
                                         $$->p[0] = $2 ;
                                         $$->p[1] = $3 ; }
             | parse UPPER parse_param template seps
                                       { $$ = $1 ;
                                         $$->type = X_PARSE_U ; 
                                         $$->p[0] = $3 ;
                                         $$->p[1] = $4 ; }
             | parse ARG templs seps   { $$ = $1 ;
                                         $$->type = X_PARSE_ARG ; 
                                         $$->p[0] = $3 ; }
             | parse UPPER ARG templs seps 
                                       { $$ = $1 ;
                                         $$->type = X_PARSE_ARG_U ; 
                                         $$->p[0] = $4 ; }
             ;

templs       : template ',' templs     { $$ = makenode(X_TMPLS,2,$1,$3) ; }
             | template                { $$ = $1 ; }
             ;

parse_param  : LINEIN                  { $$ = makenode(X_PARSE_EXT,0) ; }
             | EXTERNAL                { $$ = makenode(X_PARSE_EXT,0) ; }
             | NUMERIC                 { $$ = makenode(X_PARSE_NUM,0) ; }  
             | VERSION                 { $$ = makenode(X_PARSE_VER,0) ; }
             | PULL                    { $$ = makenode(X_PARSE_PULL,0) ; }
             | SOURCE                  { $$ = makenode(X_PARSE_SRC,0) ; }
             | VAR simsymb             { $$ = makenode(X_PARSE_VAR,0) ; 
                                         $$->name = (char *) $2 ; }
             | VALUE nexpr WITH        { $$ = makenode(X_PARSE_VAL,1,$2) ; }
             ;

proc_stat    : proc seps               { $$ = $1 ; }
             | proc EXPOSE vars seps   { $$ = $1 ; 
                                         $$->p[0] = $3 ; }
             ;

pull_stat    : pull template seps      { $$ = $1 ; 
                                         $$->p[0] = $2 ; }
             ;

push_stat    : push nexpr seps         { $$ = $1 ; 
                                         $$->p[0] = $2 ; }
             ;

queue_stat   : queue nexpr seps        { $$ = $1 ;
                                         $$->p[0] = $2 ; } 
             ;

return_stat  : return nexpr seps       { $$ = $1 ; 
                                         $$->p[0] = $2 ; }
             ;

say_stat     : say nexpr seps          { $$ = $1 ;
                                         $$->p[0] = $2 ; }
             ;

select_stat  : select seps when_stats otherwise_stat END seps
                                       { $$ = $1 ;
                                         $$->p[0] = $3 ;
                                         $$->p[1] = $4 ; }
             ;

when_stats   : when_stat when_stats    { $$ = makenode(X_WHENS,2,$1,$2) ; }
             | when_stat               { $$ = makenode(X_WHENS,1,$1) ; }
             ;

when_stat    : when expr nseps THEN nseps statement {
                                         $$ = $1 ;
                                         $$->p[0] = $2 ;
                                         $$->p[1] = $6 ; }
             ;

otherwise_stat : otherwise nseps nstats {
                                         $$ = $1 ; 
                                         $$->p[0] = $3 ; }
             |                         { $$ = NULL ; } 
             ;


signal_stat : signal VALUE expr seps   { $$ = $1 ;
                                         $$->type = X_SIG_VAL ; 
                                         $$->p[0] = $3 ; }
            | signal_lab asymbol seps  { $$ = $1 ;
                                         $$->name = (char *)$2 ; }
            | signal on_off s_action seps  
                                       { $$ = $1 ;
                                         $$->type = X_SIG_SET ;
                                         $$->p[0] = $2 ;
                                         $$->p[1] = $3 ; }
            ;

asymbol     : CONSYMBOL                { $$ = (nodeptr)stralloc(retvalue) ; }
            | SIMSYMBOL                { $$ = (nodeptr)stralloc(retvalue) ; }
            ;
 
on_off      : ON                       { $$ = makenode(X_ON,0) ; }
            | OFF                      { $$ = makenode(X_OFF,0) ; }
            ;

s_action    : ERROR                    { $$ = makenode(X_S_ERROR,0) ; }
            | HALT                     { $$ = makenode(X_S_HALT,0) ; }
            | NOVALUE                  { $$ = makenode(X_S_NOVALUE,0) ; }
            | SYNTAX                   { $$ = makenode(X_S_SYNTAX,0) ; }
            ;


trace_stat  : trace VALUE expr seps    { $$ = $1 ;
                                         $$->p[0] = $3 ; }
            | trace whatever seps      { $$ = $1 ; 
                                         $$->name = (char *) $2 ; }
            ;

whatever    : WHATEVER                 { $$ = (nodeptr)stralloc(retvalue) ; }
            ;


upper_stat  : upper vars seps          { $$ = $1 ; 
                                         $$->p[0] = $2 ; }
            ;

assignment  : ass_part expr seps       { $$ = $1 ;
                                         $$->p[0] = $2 ; }
            ;          

ass_part    : ASSIGNMENTVARIABLE       { $$ = makenode(X_ASSIGN,0) ; 
                                         $$->charnr = tstart ;
                                         $$->lineno = tline ;
                                         $$->name = stralloc(retvalue) ; } 
            ;


expr        : '(' expr ')'             { $$ = $2 ; } 
            | NOT expr                 { $$ = makenode(X_LOG_NOT,1,$2) ; }
            | expr '+' expr            { $$ = makenode(X_PLUSS,2,$1,$3) ; }
            | expr '=' expr            { $$ = makenode(X_EQUAL,2,$1,$3) ; }
            | expr '-' expr            { $$ = makenode(X_MINUS,2,$1,$3) ; }
            | expr '*' expr            { $$ = makenode(X_MULT,2,$1,$3) ; }
            | expr '/' expr            { $$ = makenode(X_DEVIDE,2,$1,$3) ; }
            | expr '%' expr            { $$ = makenode(X_INTDIV,2,$1,$3) ; }
            | expr '|' expr            { $$ = makenode(X_LOG_OR,2,$1,$3) ; }
            | expr '&' expr            { $$ = makenode(X_LOG_AND,2,$1,$3) ; }
            | expr XOR expr            { $$ = makenode(X_LOG_XOR,2,$1,$3) ; }
            | expr EXP expr            { $$ = makenode(X_EXP,2,$1,$3) ; }
            | expr SPACE expr          { $$ = makenode(X_SPACE,2,$1,$3) ; }
            | expr GTE expr            { $$ = makenode(X_GTE,2,$1,$3) ; }
            | expr LTE expr            { $$ = makenode(X_LTE,2,$1,$3) ; }
            | expr GT expr             { $$ = makenode(X_GT,2,$1,$3) ; }
            | expr MODULUS expr        { $$ = makenode(X_MODULUS,2,$1,$3) ; }
            | expr LT expr             { $$ = makenode(X_LT,2,$1,$3) ; }
            | expr DIFFERENT expr      { $$ = makenode(X_DIFF,2,$1,$3) ; }
            | expr EQUALEQUAL expr     { $$ = makenode(X_S_EQUAL,2,$1,$3) ; }
            | expr NOTEQUALEQUAL expr  { $$ = makenode(X_S_DIFF,2,$1,$3) ; }
            | simsymb                  { $$ = makenode(X_SIM_SYMBOL,0) ;
                                         $$->name = (char *) $1 ; }
            | CONSYMBOL                { $$ = makenode(X_CON_SYMBOL,0) ;
                                         $$->name = stralloc(retvalue) ; }
            | HEXSTRING                { $$ = makenode(X_STRING,0) ;
                                         $$->name = stralloc(retvalue) ; }
            | STRING                   { $$ = makenode(X_STRING,0) ; 
                                         $$->name = stralloc(retvalue) ; }
            | function                 { $$ = $1 ; } 
            | '+' expr %prec UPLUSS    { $$ = $2 ; }
            | '-' expr %prec UMINUS    { $$ = makenode(X_U_MINUS,1,$2) ; }
            | expr CONCATENATE expr    { $$ = makenode(X_CONCAT,2,$1,$3) ; }
            | expr CCAT expr           { $$ = makenode(X_CONCAT,2,$1,$2) ; }
            ;

function    : extfunc exprs ')'        { $$ = makenode(X_EX_FUNC,1,$2) ; 
                                         $$->name = (char *)$1 ; }
            | intfunc exprs ')'        { $$ = makenode(X_IN_FUNC,1,$2) ; 
                                         $$->name = (char *)$1 ; }
            ;

intfunc     : INFUNCNAME               { $$ = (nodeptr)stralloc(retvalue) ; }
            ; 

extfunc     : EXFUNCNAME               { $$ = (nodeptr)stralloc(retvalue) ; }
            ;

template    : pv solid template        { $$ =makenode(X_TPL_SOLID,3,$1,$2,$3);}
            | pv                       { $$ =makenode(X_TPL_SOLID,1,$1) ; } 
            ;

solid	    : '-' offset               { $$ = makenode(X_NEG_OFFS,0) ; 
                                         $$->name = (char *) $2 ; }
            | '+' offset               { $$ = makenode(X_POS_OFFS,0) ;
                                         $$->name = (char *) $2 ; }
            | offset                   { $$ = makenode(X_ABS_OFFS,0) ;
                                         $$->name = (char *) $1 ; }
            | '(' simsymb ')'	       { $$ = makenode(X_TPL_VAR,0) ;
                                         $$->name = (char *) $2 ; }
            | string                   { $$ = makenode(X_TPL_MVE,0) ;
                                         $$->name = (char *) $1 ; }
            ; 

offset      : OFFSET                   { $$ = (nodeptr)stralloc(retvalue) ; }
            ;

string      : STRING                   { $$ = (nodeptr) stralloc(retvalue) ; }
            ;

pv          : PLACEHOLDER pv           { $$ = makenode(X_TPL_POINT,1,$2) ; }
            | simsymb pv               { $$ = makenode(X_TPL_SYMBOL,1,$2) ; 
                                         $$->name = (char *)$1 ; }
            |                          { $$ = NULL ; }
            ;

exprs       : nexpr ',' exprs          { $$ = makenode(X_EXPRLIST,2,$1,$3) ; 
					 if ($1==NULL)
					    $$->p[0] = makenode(X_NULL,0) ; }
            | nexpr                    { $$ = makenode(X_EXPRLIST,1,$1) ; 
					 if ($1==NULL)
					    $$->p[0] = makenode(X_NULL,0) ; }
            ;

nexpr       : expr                     { $$ = $1 ; } 
            |                          { $$ = NULL ; }
            ;

vars        : simsymb vars             { $$ = makenode(X_SIM_SYMBOL,1,$2) ; 
                                         $$->name = (char *) $1 ; }
            | simsymb                  { $$ = makenode(X_SIM_SYMBOL,0) ; 
                                         $$->name = (char *) $1 ; }
            ;

simsymb     : SIMSYMBOL                { $$ = (treenode *) stralloc(retvalue);}
            ;               

nsimsymb    : simsymb                  { $$ = $1 ; }
            |                          { $$ = NULL ; }
            ;

%%

char *stralloc( char *ptr )
{
   static char strspc[STRINGSPACE] ;
   static int strptr = 0 ;
   int i ;

   i = strptr ;
   if ((strptr+=((8+strlen(ptr))&(~7)))>=STRINGSPACE)
      exiterror(5) ;   /* too easy, allocate more space .... */
   strcpy(&strspc[i],ptr) ;

#ifdef REXXDEBUG
   printf("Stralloc: request to allocate %d bytes for //%s//\n",strptr-i,ptr);
#endif /* REXXDEBUG */

   return( &strspc[i] ) ;   
}


nodeptr makenode( int type, int numb, ... ) 
{
   nodeptr thisleave ;
   va_list argptr ;
   int i ;

#ifdef REXXDEBUG
   printf("makenode: making new node, type: %d\n",type) ;
#endif /* REXXDEBUG */ 

   thisleave=(nodeptr)Malloc(sizeof(*thisleave)) ;

   for (i=0;i!=5;i++) 
      thisleave->p[i] = NULL ;

   va_start( argptr, numb ) ;
   thisleave->type = type ;
   thisleave->lineno = -1 ;
   thisleave->now = 0 ;
   thisleave->unow = 0 ;
   thisleave->sec = 0 ;
   thisleave->usec = 0 ;
   thisleave->value = NULL ;
   thisleave->charnr = -1 ;
   thisleave->name = NULL ;
   for (i=0;i!=numb;i++) 
      thisleave->p[i]=va_arg(argptr, nodeptr) ; 

   va_end( argptr ) ;
   return( thisleave ) ;
}


void checkdosyntax( nodeptr this ) 
{
   if ((this->p[1]!=NULL)&&(this->p[2]!=NULL))
      if ((this->p[1]->type)==(this->p[2]->type))
         exiterror(27) ;
   if ((this->p[2]!=NULL)&&(this->p[3]!=NULL))
      if ((this->p[2]->type)==(this->p[3]->type))
         exiterror(27) ;
   if ((this->p[1]!=NULL)&&(this->p[3]!=NULL))
      if ((this->p[1]->type)==(this->p[3]->type))
         exiterror(27) ;
   return ;
}


void newlabel( nodeptr this ) 
{
   extern proclevel mainlevel ;
   labelboxptr new ;

   new = (labelboxptr)Malloc(sizeof(labelbox)) ;

   new->next = NULL ;
   new->entry = this ;
   if (mainlevel->last!=NULL)
      mainlevel->last->next = new ;
   mainlevel->last = new ;
   if (mainlevel->first==NULL)
      mainlevel->first = new ;
}
 
