#ifndef lint
static char *RCSid = "$Id: unixfuncs.c,v 1.6 1992/04/05 19:49:47 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: unixfuncs.c,v $
 * Revision 1.6  1992/04/05  19:49:47  anders
 * Added copyright notice
 * Made code compatible with ANSI C and POSIX.
 *
 * Revision 1.5  1992/03/22  18:54:56  anders
 * Defined popen() explicitly for CRAY
 *
 * Revision 1.4  1992/03/22  01:40:25  anders
 * Did lots of changes to interface correctly againts the REXX
 *    type of file io.
 *
 * Revision 1.3  1992/03/01  19:11:25  anders
 * Fixed problems with sprintf()
 *
 * Revision 1.2  1990/08/26  01:53:19  anders
 * Added new function, eof()
 *
 * Revision 1.1  90/08/08  02:14:04  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <string.h>

#if defined(CRAY)
FILE *popen( char *command, char *access ) ;
#endif

char *unx_getpath( paramboxptr parms )
{
   return NULL ;
}


char *unx_popen( paramboxptr parms )
{
   extern proclevel currlevel ;
   char *string, *cptr, *result ;
   int length, rcode ;

   checkparam( parms, 1, 1 ) ;
   if (parms->value)
      string = (parms->value) ;

   cptr = Malloc( length=strlen(string) + 6 ) ;
   strcpy( cptr, string ) ;
   strcat( cptr, ">FIFO" ) ;
   Free( string ) ;	

   rcode = perform( cptr, currlevel->environment ) ; 
   Free( cptr ) ;
   sprintf( result = Malloc(SMALLSTR), "%d", rcode ) ;
   return result ;
}



char *unx_eof( paramboxptr parms )
{
   char *ptr ;
   checkparam( parms, 0, 0 ) ;
/*    sprintf(ptr=Malloc(SMALLSTR),"%d",eof_on_input()) ; */
   return( ptr ) ;
}


char *unx_unixerror( paramboxptr parms )
{
   char *result, *errtxt ;
   extern char *sys_errlist[] ;
   int errno ;
   
   checkparam( parms, 1, 1 ) ;
   errno = atozpos( parms->value ) ;
   errtxt = sys_errlist[ errno ] ;
   strcpy( result=Malloc(strlen(errtxt)+1), errtxt ) ;
   return result ;
}
   


char *unx_chdir( paramboxptr parms )
{
   int chdir() ;
   char *result ;

   checkparam( parms, 1, 1 ) ;
   result = Malloc(BOOL_STR_LENGTH) ;
   result[0] = '1' ;
   result[1] = '\000' ;
   if (chdir(parms->value)) 
      result[0] = '0' ;
   return result ;
}


char *unx_getenv( paramboxptr parms ) 
{
   char *retval, *output ;
   int length ;

   checkparam( parms, 1, 1 ) ;
   output = getenv( parms->value ) ;
   if (output) {
      retval = Malloc(length=strlen(output)+1) ;
      memcpy(retval,output,length) ; }
   else 
      retval = nullstringptr() ;

   return retval ;
}
   

