/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Id: types.h,v 1.5 1992/04/05 19:51:18 anders Exp anders $
 *
 * $Log: types.h,v $
 * Revision 1.5  1992/04/05  19:51:18  anders
 * Added copyright notice, and pointer to revious envionment name
 *
 * Revision 1.4  1992/03/23  05:10:10  anders
 * Added new field numform to currlevel, to contain the type of
 *    numeric form that is set using NUMERIC FORM
 *
 * Revision 1.3  1992/03/22  01:00:01  anders
 * Moved all references to the filetable to files.c
 * Commented out definition of string, as it confused som compilers
 *    when it discovered variables called string.
 *
 * Revision 1.2  1990/08/11  00:40:40  anders
 * Removed definition of stack (to be hidden in stack.c)
 * Removed pointer to stack from sysbox, same reason
 *
 * Revision 1.1  90/08/08  02:05:32  anders
 * Initial revision
 * 
 */


typedef int bool ;

typedef struct tnode *nodeptr ;
typedef struct tnode {
   int type, charnr, lineno ;
   char *value, *name ;
   long now, unow, usec, sec ;
   nodeptr p[5], mother ; 
} treenode ;

typedef struct stackboxtype *stackboxptr ;
typedef struct stackboxtype {
   int whereto, number ;
   char *increment, *stopval ;
   nodeptr this ;
} stackbox ;

typedef struct pparambox *paramboxptr ;
typedef struct pparambox {
   paramboxptr next ;
   char *value ; 
} parambox ;

typedef struct lineboxx *lineboxptr ;
typedef struct lineboxx {
   lineboxptr next, prev ;
   char *line ;
   int lineno ;
} linebox ;

typedef struct varbox *variableptr ;
typedef struct varbox {
   variableptr next, realbox, *index ;   
   char *value, *name ;
} variable ;

typedef variableptr hashtabl[HASHTABLENGTH] ;

typedef struct labelboxx *labelboxptr ;
typedef struct labelboxx {
   labelboxptr next ;
   nodeptr entry ; 
} labelbox ;

typedef struct proclevelbox *proclevel ;
typedef struct proclevelbox {
   int numfuzz, numsize, currnumsize ;
   int mathtype ;
   long sec, usec ;
   labelboxptr first, last ;
   proclevel prev, next ;
   variableptr *vars ;
   paramboxptr args ;
   char tracestat, varflag, *environment, *prev_env, *numform ;
} proclevbox ;

typedef struct systeminfobox *sysinfo ;
typedef struct systeminfobox {
   char *called_as, *input_file, *environment, tracing ;
   int interactive ;
} sysinfobox ;

/*
 * typedef struct stringtype {
 *    short len, max ;
 *    char *start ;
 * } string ;
 */


