/*--------------------------------------------------------------------*/
/* The purpose of this program is to try some strange constructions   */ 
/*   in REXX, and to fool the interpreter to make a mistake           */
/*                                                                    */
/* Created ... ... : April 1989                                       */
/* Last modified . : 6th September 1980                               */
/*                                                                    */
/* Current version : 2.00                                             */
/*                                                                    */
/* Written by Anders Christensen, Norwegian Institute of Technology   */
/*   E-mail addr:   Bitnet    : achriste@norunit.earn                 */
/*                  Internet  : anders@solan.unit.no                  */
/*                  Uninett   : christensen@vax.runit.unit.uninett    */
/*--------------------------------------------------------------------*/

length = charout(,'Checking: (')

/*--------------------------------------------------------------------*/
/* First check comments                                               */
/*--------------------------------------------------------------------*/
call tell 'comments'

/*----- Let's see if we can nest comments ----------------------------*/
test = /* /* */ ' */ ' ' /* ' /* */ */   
if test ^== ' ' then
   call complain "Comments can't be nested."

/*----- Check if comments act as token separators --------------------*/
abc = 'First '
def = 'Second'
test = abc/*   */def
if test ^== 'First Second' then
   call complain 'Comments are not a token separator.'

/*----- Check if comments get confused with whitespace ---------------*/
test1 /* */ = /* */ 'foo' /* */ 'bar'
test2/*   */=/*   */'foo'/*   */'bar'

if (test ^== 'foo bar') * (test2 ^== 'foobar') then
   call complain 'Comments get mixed with whitespace'


/*--------------------------------------------------------------------*/
/* Then check if line continuations are OK                            */
/*--------------------------------------------------------------------*/
call tell 'continuations'

/*----- A line break should be interpreted as a space 'operator' -----*/
test = 'abc',
'def'
if test ^== 'abc def' then
   call complain 'Line continuations is not translated to space'

/*----- Does a comment after the comma confuse it? -------------------*/
test = 'abc', /* */
nop
if test ^== 'abc NOP' then
   call complain 'Comments confuse line continuations'

/*----- Let's see if it takes some heavy line continuation -----------*/
if,
   6, 
     ==,
        7,
          then,
   call complain "Don't take heavy line continuation"


/*--------------------------------------------------------------------*/
/* Let's check some of the inplementation minimums                    */
/*--------------------------------------------------------------------*/
call tell 'minimums'

/*----- The Standard requires 50 significant chars in variablenames --*/
FiftyCharactersInVariableNamesAreAnAbsoluteMinimum = 'foo'
FiftyCharactersInVariableNamesAreAnAbsoluteMinimun = 'bar'
if FiftyCharactersInVariableNamesAreAnAbsoluteMinimum = ,
   FiftyCharactersInVariableNamesAreAnAbsoluteMinimun then
   call complain 'Less than 50 significant chars in symbolnames'



/*--------------------------------------------------------------------*/
/* Let's test all operators                                           */
/*--------------------------------------------------------------------*/
call tell 'operators'

/*----- First, test all compariastion operators ----------------------*/
str = '' ^('abc'='abc') ^('abc'=='abc') ('abc'^='abc') ('abc'^=='abc')
str = str ('abc'='xyz') ('abc'=='xyz') ^('abc'^='xyz') ^('abc'^=='xyz')
str = str ^('abc'=' abc ') ('abc'==' abc ') ('abc'^=' abc ') ^('abc'^==' abc ')

if (str^=' 0 0 0 0 0 0 0 0 0 0 0 0') then 
   call complain 'Comparisation operators do not work properly'


/*--------------------------------------------------------------------*/
/* Then we test the random generator                                  */
/*--------------------------------------------------------------------*/
call tell 'random'

/*----- Test if we can really set the seed ---------------------------*/
temp1 = ''
temp2 = ''
junk = random(0,999,666)
do 10
   temp1 = temp1 random() ; end

junk = random(0,999,666)
do 10
   temp2 = temp2 random() ; end
say '' 

if (random(10,10)^==random(10,10)) then
    call complain "Random does not respect upper and lower limits"

if ^(temp1==temp2) then 
   call complain 'Can not set seed in random generator'

/*--------------------------------------------------------------------*/
/* Test asossiative arrays                                            */
/*--------------------------------------------------------------------*/
call tell 'arrays'

/*----- Test if they work correctly ----------------------------------*/

One = 1
Two = 2
Three = 3
Alfa = 'A'
Beta = 'B'

Fish.1 = 'Hi'
Fish.Beta = 'Hello'
Fish. = 'Bye'
Fish.1.2 = '...'

if (Fish.Alfa ^= Fish.Three) then
   call complain "default mechanism do not work"

TwoThree = '1.2'
if (Fish.TwoThree ^= Fish.One.Two) then
   call complain "assosiative arrays work incorrectly"


/*--------------------------------------------------------------------*/
/* Test labels                                                        */
/*--------------------------------------------------------------------*/
call tell 'labels'


/*--------------------------------------------------------------------*/
test = 'before'
signal thelabel
test = 'after'

thelabel:
if test^=='before' then 
   call complain 'tripped in a label ... '

signal jumpover
thelabel:
call complain 'didnt find first label, but second'
jumpover:



/*--------------------------------------------------------------------*/
/* Functions                                                          */
/*--------------------------------------------------------------------*/
call tell 'functions'


/*--------------------------------------------------------------------*/
call testing
if result ^== '17' then 
   call complain 'RESULT not correctly set after call'
signal aftertesting

testing:
   variable = 2 + 3 * 5
return variable

aftertesting:


/*--------------------------------------------------------------------*/
call nextlabel
signal afternextlabel

nextlabel:
if sourceline(sigl) ^== 'call nextlabel' then
   call complain 'SIGL not correctly set on signal statement'
return

afternextlabel:


/*--------------------------------------------------------------------*/
/* Test the codes ability to recurse                                  */
/*--------------------------------------------------------------------*/
call tell 'recursing'

/*----- First a simple test ------------------------------------------*/
signal afterrecurse

recurse: procedure 
   parse arg parameter
   if parameter>0 then do
/*      say parameter */
      return recurse(parameter-1) parameter
      end
   else
      return 0

afterrecurse:
if recurse(3)^=='0 1 2 3' then
   call complain "didn't recurse properly"


parse value recurse(100) with . '99' result .
if result ^== '100' then
   call complain "can't do 100 recursions"


say ')'
say 'Finished processing trip-test .... '

exit 0



complain:
   say ' ...'
   say 'Tripped in line' sigl':' arg(1)'.'
   length = charout(,'   (')
return


tell:
   str = arg(1) 
   if length+length(str)>70 then do
      say ''
      length = charout(,'   ' || str || ', ') ; end
   else
      length = length + charout(,str || ', ') 
return



/* Can't use this, part of the REXX book
call notify('insert')

call ch(  insert(' ','abcdef',3),       'abc def')
call ch(  insert('123','abc',5,6),      'abc  123   ')
call ch(  insert('123','abc',5,6,'+'),  'abc++123+++')
call ch(  insert('123','abc'),          '123abc')
call ch(  insert('123','abc',5,,'-'),   '123--abc') */


