
/*
 * Following statements are tested otherwhere:
 * 
 *   PULL PUSH QUEUE
 *     --> tested in stack.rexx
 *
 */

written = 0 

/* ====================== ADDRESS ============================= */
/* ======================== ARG =============================== */
/* ======================= CALL =============================== */

/* ================================================================== */
/* ============================== DO ================================ */
/* ================================================================== */

call notify 'do-loops'

/*----- First, try a rather simple do-loop ---------------------------*/
signal = ""
do = 4
end = 5
then = 1
forever = 6
iterate = 1
do for = forever to do + end by then while iterate
   signal = signal for
   end 

/*----- Check value of control variable ------------------------------*/
if for ^= 10 then
   call complain 'Control variable have incorrect value on exit'

/*----- Did it loop correct? -----------------------------------------*/
if signal^==' 6 7 8 9' then
   call complain 'Did not perform the loop correct'


/*----- Is phrases calculated in correct order? ----------------------*/
str = ''
do i=1 by func(1) for func(0) to func(2)
   call complain 'Does not handle for-phrase correct'
   end

if str ^==' 1 0 2' then
   call complain 'Incorrect evaluation order for phrases in do-loops'
 

str = ''
do i=func(1) to func(4) by func(2) for func(5)
   nop
   end

if str^==' 1 4 2 5' then
   call complain 'Expressions in DO-loops are re-evaluated'


signal afterfunc
func: 
   str = str arg(1)
   return arg(1)
afterfunc:


/*----- Can we use while (and until) as control variable? ------------*/
do while = 1 for 0
   end

if while ^== '1' then
   call complain 'Could not use while as control variable'


/*----- Can we manipulate the control variable? ---------------------*/
j = 0
do i=1 to 10
   if i=4 then i=7
   j = j + 1
   end

if j^==7 then 
   call complain 'Can not change value of control variable'


/*----- Can we change to a new control variable during looping? -----*/
i = 0
j = 0
i. = 0
do i.i=i.i to 10
   i = (i+1)//10 
   j = j + 1
   end

if j^==101 then
   call complain 'Can not swap control variable during looping'

count = 4
do i=1 to 10 while count>0
   count = count - 1
   end

if i^=='5' then
   call complain 'Incorrect sequence in processing DO-loops (while)'


count = 4
do i=1 to 10 until count==0
   count = count - 1
   end

if i^=='4' then
   call complain 'Incorrect sequence in processing DO-loops (until)'


do i=1 to 10 for 4
   nop
   end

if i^=='5' then
   call complain 'Incorrect sequence in processing DO-loops (for)'


/* ======================= DROP =============================== */
/* ======================= EXIT =============================== */


/* ================================================================== */
/* ============================== IF ================================ */
/* ================================================================== */
call notify 'if'

/*----- the ';' can not replace a statement after 'then' ------------ */
str = '' 
if 0 then ;
   str = hepp
   
if str^=='' then
   call complain 'Null-clause in THEN-part of IF-statement'


if 0 then nop
   str = 'hepp'

if str^=='hepp' then
   call complain 'NOP is ignored in IF statement'


/*----- does 'else' bind correctly? --------------------------------- */
if 0 then 
   if 1 then
      nop
   else 
      call complain "ELSE does not bind correctly in IF-statements"
nop


/*----- can then be used as variable in extr -------------------------*/
then = '2'
if '1 2' = 1 then 
   call complain "then may be used in IF-expr as a variable"


/* ===================== INTERPRET ============================ */


/* ================================================================== */
/* ============================ ITERATE ============================= */
/* ================================================================== */
call notify 'iterate'

/*----- does iterate work at all ? -------------------------------------*/
k = 0
do i=1 to 20
   if i>7 then
      iterate 
   k = k + 1
   end

if k^=='7' then
   call complain 'ITERATE does not work correctly'
 

/*----- does it iterate the right level --------------------------------*/
k=0
do l=1 to 2
   do i=1 to 10
      do j=1 to 10
         if (i>4) & (j>5) then
            iterate i
         k = k + 1
      end
   end
end

if k^=='140' then
   call complain 'ITERATE "var" does not leave right level'


/*----- can we fool the interpreter to iterate another loop -----------*/

k = 0
i = 1
j = 2
do i.i=1 to 10
   temp = i.i
   do i.j=1 to 10
      if (i.i>3) & (i.j>6) then do
         i.i = temp
         i = 2
         iterate i.i
         end
      k = k + 1 
      end
   i.i = temp
   end

if k^==54 then
   call complain 'Substitution suspected in ITERATE variable'


/*----- can we terminate inactive loop ------------------------------*/
/* 
 * k = 0 
 * do i=1 to 10
 *    if i=3 then
 *       interpret 'iterate'
 *    k = k + 1
 *    end
 * 
 * if i^==11 then
 *    call complain 'INTERPRET ITERATE can terminate inactive loop'
 */


/*----- if two loops use same control variable -----------------------*/

l = 0
do i=1 to 10
   k = i
   do i=1 to 10
      l = l + 1
      if k>6 then
         iterate i
      end
   i = k
   end

if l^==100 then
   call complain "ITERATE doesn't leave innermost loop when identical ctrlvars"


/*----- can we fool iterate with a non-repetitive loop ----------------*/
k = ''
do i=1 to 3
   if i=2 then do
      nop
      iterate
      end
   k = k i
   end

if k^==' 1 3' then
   call complain 'ITERATE is fooled by a non-repetitive loop'





/* ================================================================== */
/* ============================= LEAVE ============================== */
/* ================================================================== */
call notify 'leave'

/*----- does leave work at all ? -------------------------------------*/
do i=0 to 20
   if i==7 then
      leave 
   end

if i^=='7' then
   call complain 'LEAVE does not work correctly'


/*----- does it leave the right level --------------------------------*/
k=0
do l=1 to 2
   do i=1 to 10
      do j=1 to 10
         if (i>4) & (j>5) then
            leave i
         k = k + 1
      end
   end
end

if k^=='90' then
   call complain 'LEAVE "var" does not leave right level'


/*----- can we fool the interpreter to leave another loop -----------*/
k = 0
i = 1
j = 2
do i.i=1 to 10
   do i.j=1 to 10
      k = k + 1 
      if (i.i=3) & (i.j=6) then do
         i = 2
         leave i.i
         end
   end
end

if k^==26 then
   call complain 'Substitution suspected in LEAVE variable'


/*----- can we terminate inactive loop ------------------------------*/
/*
 * do i=1 to 10
 *    if i=3 then
 *       interpret leave
 *    end
 * 
 * if i^==11 then
 *    call complain 'INTERPRET LEAVE can terminate inactive loop'
 */


/*----- if two loops use same control variable -----------------------*/
l = 0
do i=1 to 10
   k = i
   do i=1 to 10
      if i=6 then
         leave i
      l = l + 1
      end
   i = k
   end

if l^==50 then
   call complain 'LEAVE does not leave innermost loop when identical ctrlvars'


/*----- can we fool leave with a non-repetitive loop ----------------*/
do i=1 to 10
   if i=4 then do
      nop
      leave
      nop
      end
   end

if i^=='4' then
   call complain 'LEAVE is fooled by a non-repetitive loop'



/* ======================== NOP =============================== */
/* ====================== NUMERIC ============================= */
/* ====================== OPTIONS ============================= */


/* ================================================================== */
/* ============================= PARSE ============================== */
/* ================================================================== */
call notify 'parsing'

string1 = 'Det er sikkert mange utlendinger som ikke kan lese dette'

/*----- Test if they work correctly ----------------------------------*/
parse var string1 before 'sikkert' between 9 .
if (before^=='Det er ') then
   call complain "litteral patterns can not overlap positional patterns"

parse var string1 -10 all 100
if (all^==string1) then
   call complain "confused when offsets are outside string boundaries"

parse var string1 . 'sikkert' word 'utlendinger' .
if (word^==' mange ') then
   call complain "does not handle spaces between words correctly"

parse var string1 . 'sikkert' word . 'utlendinger' .
if (word^=='mange') then
   call complain "does not handle spaces between words correctly"


/*----- can assignment to onw var be assigned later in same templ. ---*/
parse var string1 . 'si' tmp 'ert' . (tmp) testing +7 .
if testing^=='e kan' then
   call complain 'Variable assigned in a PARSE can not be references later'

parse var string1 . 'si' tmp 'ert' . (tmp) +0 testing +5 .
if testing^=='kke k' then
   call complain 'The pattern +0 does not work in PARSE'

parse value "hepp" with 1 var1 1 var2 1 var3 1
if (var1^=="hepp" | var2^=="hepp" | var3^=="hepp") then
   call complain "can't handle multiple assignement"

parse value "hest" with var1 "s" -1 var2 +2 -1 var3
if (var1^=="he" | var2^=="es" | var3^=="st") then
   call complain "Something is wrong with relative offsets"



/* ================================================================== */
/* ============================ PROCDURE ============================ */
/* ================================================================== */
call notify 'procecure'

/*--------------------------------------------------------------------*/
/* Test ability to properly expose variables                          */
/*--------------------------------------------------------------------*/

/*---- check a few things --------------------------------------------*/

a = 'hello'
bar.1 = 'oops'
foo.1 = 'yupp'
test.X.1 = 'foobar'
foo.b = 'nope'
b = 1 

call checkit

signal aftercheckit

checkit: procedure expose bar.b b foo.b test. test.1 test.b test. test.X.B
   if (foo.1 ^= 'yupp') then
      call complain "don't substitute indexes in expose"

   if (test.X.1 ^== "foobar") then
      call complain "don't handle last in a list of exposees"

   if (bar.1 ^== 'BAR.1') then
      call complain "substitutes too much in indexes in expose"
return

aftercheckit:





/* ====================== RETURN ============================== */
/* ======================== SAY =============================== */


/* ================================================================== */
/* ============================ SELECT ============================== */
/* ================================================================== */
call notify 'select'

/*----- does it calculate in correct order? --------------------------*/
/*----- last when and the otherwise should be skipped, and -----------*/
/*----- string should have a particular order ------------------------*/
str = ''
select
   when func(0)=2 then str=asdf
   when func(1)=2 then str=asdf
   when func(2)=2 then str=str 'hepp'
   when func(3)=2 then str=asdf
   otherwise
      str=asdf
   end

if str^==' 0 1 2 hepp' then
   call complain 'SELECT does not operate correctly'

/*----- Can we do without an otherwise? ----------------------------*/
select
   when 0 then nop
   when 1 then nop
   when 0 then nop
   end  /* this should not result in a syntax error */



/* ====================== SIGNAL ============================== */
/* ======================= TRACE ============================== */


   say ' '
exit 0


ch: procedure expose sigl 
   parse arg first, second
   if first ^== second then do
      say
      say "first= /"first"/"
      say "second=/"second"/"
      say "FuncTrip: error in " sigl":" sourceline(sigl) ; end
   return


notify:
   parse arg word .
   written = written + length(word) + 2
   if written>75 then do
      written = length(word)
      say ' '
   end
   call charout , word || ', '
   return


error:
   say 'Error discovered in function insert()'
   return

complain:
   say ' ...'
   say 'Tripped in line' sigl':' arg(1)'.'
   length = charout(,'   (')
return


 
