#! rexx
/* testing the implementation of the stack */

written = 0


/* first check PUSH */
call notify 'push'
   push 'first'
   push 'second'
   pull one
   pull two

   if (one^=="SECOND") | (two^=="FIRST") then
      call complain 'The PUSH statement does not work'

call notify 'queue'
   queue 'first'
   queue 'second'
   pull one
   pull two

   if (one^=="FIRST") | (two^=="SECOND") then
      call complain 'The QUEUE statement does not work'

   queue
   push
   pull one
   pull two
   
   if (one^=='') | (two^=="") then
      call complain 'Either QUEUE or PUSH do not stack empty lines'



/* the queued() function */
call notify 'queued'
   call ch queued(), 0
   push 'one'
   call ch queued(), 1
   push 'two'
   queue 'three'
   call ch queued(), 3

   parse pull first
   call ch first, 'two'
   parse pull second
   call ch second, 'one'
   parse pull third
   call ch third, 'three'
   call ch queued(), 0

   push 'one'
   push 'two'
   call makebuf
   push 'three'
   call ch queued(), 3
   push 'four'
   call makebuf
   call ch queued(), 4
   push 'five'

   call dropbuf
   call ch queued(), 4
   call dropbuf
   call ch queued(), 2
   call dropbuf
   call ch queued(), 0
   call dropbuf
   call ch queued(), 0



call notify 'commands'

   address system

/*----- Let's see if it can pipe the stack ----------------------------*/

   queue 'To be or not to be'
   'LIFO> tr abcdefghijkl ABCDEFGHIJKL >LIFO'

   parse pull line
   if line^=='To BE or not to BE' then
      call complain 'Can not pipe the stack-contents through a command'

/*----- does it clear the stack when command just read a few lines ----*/
   queue 'asdf asdf'
   queue 'zxcv zxcv'
   queue 'tyui tyui'
   queue 'ghjk ghjk'

   'LIFO> head -2 | wc >LIFO'
   if queued()^=='1' then
      call complain 'Commands does not clear stack'

   parse pull lines words chars .
   if lines words chars^=='2 4 20' then
      call complain 'Something is incorrect in the stack'

/*----- let's see if it really send it through system(3) ---------------*/
   address system

   'whoami >LIFO'
   'echo $USER >LIFO'
   parse pull myself .
   parse pull alsome .
   if myself^==alsome then
      call complain 'Command did not resolve environment variable'



say ''
exit


ch: procedure expose sigl 
   parse arg first, second
   if first ^== second then do
      say
      say "first= /"first"/"
      say "second=/"second"/"
      say "FuncTrip: error in " sigl":" sourceline(sigl) ; end
   return


notify:
   parse arg word .
   written = written + length(word) + 2
   if written>75 then do
      written = length(word)
      say ' '
   end
   call charout , word || ', '
   return


error:
   say 'Error discovered in function insert()'
   return


complain:
   say ' ...'
   say 'Tripped in line' sigl':' arg(1)'.'
   length = charout(,'   (')
return


