/*
 * Tests all builtin functions of rexx, except from:
 * 
 *   linein, linout, lines, charin, charout, chars
 *     --> tested in fileio.rexx
 *
 *   queued
 *     --> tested in stack.rexx
 *
 *   random
 *     --> tested in trip.rexx
 */


/* trace ?int */
written = 0

/* ======================= ABBREV ============================== */
call notify 'abbrev'
   call ch abbrev('information','info',4) 		,1
   call ch abbrev('information','',0)			,1
   call ch abbrev('information','Info',4)		,0
   call ch abbrev('information','info',5)		,0
   call ch abbrev('information','info ')		,0
   call ch abbrev('information','info',3)		,1
   call ch abbrev('info','information',3)		,0
   call ch abbrev('info','info',5)			,0


/* ========================== ABS ============================== */
call notify 'abs'
   call ch abs(-12.345)	,12.345
   call ch abs(12.345) 	,12.345
   call ch abs(-0.0) 	,0
   call ch abs(0.0) 	,0

/* ======================== ADDRESS ============================== */
call notify 'address'
   call ch address(), 'SYSTEM'


/* ========================== ARG ============================== */
call notify 'arg'
   call testarg1
   call testarg2 1,,2
   signal afterarg

testarg1:
   call ch arg()       ,"0"
   call ch arg(1)      ,""
   call ch arg(2)      ,""
   call ch arg(1,"e")  ,"0"
   call ch arg(1,"O")  ,"1"
   return

testarg2:
   call ch arg()      ,"3"
   call ch arg(1)     ,"1"
   call ch arg(2)     ,""
   call ch arg(3)     ,"2"
   call ch arg(4)     ,""
   call ch arg(1,"e") ,"1"
   call ch arg(2,"E") ,"0"
   call ch arg(2,"O") ,"1"
   call ch arg(3,"o") ,"0"
   call ch arg(4,"o") ,"1"
   return

afterarg:


/* ======================= BITAND ============================== */
call notify "bitand"
   call ch bitand( '123456'x, '3456'x ),         '101456'x
   call ch bitand( '3456'x, '123456'x, '99'x ),  '101410'x
   call ch bitand( '123456'x,, '55'x),           '101454'x
   call ch bitand( 'foobar' ),                   'foobar'
   call ch bitand( 'FooBar' ,, 'df'x),           'FOOBAR'  /* for ASCII */


/* ======================== BITOR ============================== */
call notify "bitor"
   call ch bitor( '123456'x, '3456'x ),         '367656'x
   call ch bitor( '3456'x, '123456'x, '99'x ),  '3676df'x
   call ch bitor( '123456'x,, '55'x),           '577557'x
   call ch bitor( 'foobar' ),                   'foobar'
   call ch bitor( 'FooBar' ,, '20'x),           'foobar'  /* for ASCII */


/* ======================= BITXOR ============================== */
call notify "bitxor"
   call ch bitxor( '123456'x, '3456'x ),         '266256'x
   call ch bitxor( '3456'x, '123456'x, '99'x ),  '2662cf'x
   call ch bitxor( '123456'x,, '55'x),           '476103'x
   call ch bitxor( 'foobar' ),                   'foobar'
   call ch bitxor( 'FooBar' ,, '20'x),           'fOObAR'  /* for ASCII */


/* ======================== C2D ============================== */
call notify 'c2d'
   call ch c2d( 'ff80'x, 1), "-128"
   call ch c2d( 'foo' ) ,  "6713199"
   call ch c2d( 'bar' ),   "6447474"
   call ch c2d( '' ),      "0"
   call ch c2d( '101'x ),  "257"
   call ch c2d( 'ff'x ),   "255"
   call ch c2d( 'ffff'x),  "65535"
   call ch c2d( 'ffff'x, 2), "-1"
   call ch c2d( 'ffff'x, 1), "-1"
   call ch c2d( 'fffe'x, 2), "-2"
   call ch c2d( 'fffe'x, 1), "-2"
   call ch c2d( 'ffff'x, 3), "65535"
   call ch c2d( 'ff7f'x, 1), "127"
   call ch c2d( 'ff7f'x, 2), "-129"
   call ch c2d( 'ff7f'x, 3), "65407"
   call ch c2d( 'ff80'x, 1), "-128"
   call ch c2d( 'ff80'x, 2), "-128"
   call ch c2d( 'ff80'x, 3), "65408"
   call ch c2d( 'ff81'x, 1), "-127"
   call ch c2d( 'ff81'x, 2), "-127"
   call ch c2d( 'ff81'x, 3), "65409"
   call ch c2d( 'ffffffffff'x), "-1"


/* ======================== C2X ============================== */
call notify 'c2x'
   call ch c2x( 'foobar'),             '666F6F626172'
   call ch c2x( '' ),                  ''
   call ch c2x( '101'x ),              '0101'
   call ch c2x( '0123456789abcdef'x ), '0123456789ABCDEF'
   call ch c2x( 'ffff'x ),             'FFFF'
   call ch c2x( 'ffffffff'x ),         'FFFFFFFF'


/* ======================= CENTER ============================== */
call notify 'center'
   call ch center('****',8,'-')      ,'--****--'
   call ch center('****',7,'-')      ,'-****--'
   call ch center('*****',8,'-')     ,'-*****--'
   call ch center('*****',7,'-')     ,'-*****-'
   call ch center('12345678',4,'-')  ,'3456'
   call ch center('12345678',5,'-')  ,'23456'
   call ch center('1234567',4,'-')   ,'2345'
   call ch center('1234567',5,'-')   ,'23456'



/* ====================== COMPARE ============================== */
call notify "compare"
   call ch compare("foo", "bar")      , 1
   call ch compare("foo", "foo")      , 0
   call ch compare("   ", "" )        , 0
   call ch compare("foo", "f", "o")   , 0
   call ch compare("foobar", "foobag"), 6



/* ======================= COPIES ============================== */
call notify "copies"
   call ch copies("foo",3)     , "foofoofoo" 
   call ch copies("x", 10)     , "xxxxxxxxxx"
   call ch copies("", 50)      , ""
   call ch copies("", 0)       , ""
   call ch copies("foobar",0 ) , ""


/* ===================== DATATYPE ============================== */
call notify 'datatype'
   call ch datatype("foobar"), "CHAR"
   call ch datatype("foo bar"), "CHAR"
   call ch datatype("123.456.789"), "CHAR"
   call ch datatype("123.456"), "NUM"
   call ch datatype(""), "CHAR"
   call ch datatype("DeadBeef",'A'), "1"
   call ch datatype("Dead Beef",'A'), "0"
   call ch datatype("1234ABCD",'A'), '1'
   call ch datatype("",'A'), "0"
   call ch datatype("foobar",'B'), "0"
   call ch datatype("01001101",'B'), "1"
   call ch datatype("0110 1101",'B'), "0"
   call ch datatype("",'B'), "0"
   call ch datatype("foobar",'L'), "1"
   call ch datatype("FooBar",'L'), "0"
   call ch datatype("foo bar",'L'), "0"
   call ch datatype("",'L'), "0"
   call ch datatype("foobar",'M'), "1"
   call ch datatype("FooBar",'M'), "1"
   call ch datatype("foo bar",'M'), "0"
   call ch datatype("FOOBAR",'M'), "1"
   call ch datatype("",'M'), "0"
   call ch datatype("foo bar",'N'), "0"
   call ch datatype("1324.1234",'N'), "1"
   call ch datatype("123.456.789",'N'), "0"
   call ch datatype("",'N'), "0"
   call ch datatype("foo bar",'S'), "0"
   call ch datatype("??@##_Foo$Bar!!!",'S'), "1"
   call ch datatype("",'S'), "0"
   call ch datatype("foo bar",'U'), "0"
   call ch datatype("Foo Bar",'U'), "0"
   call ch datatype("FOOBAR",'U'), "1"
   call ch datatype("",'U'), "0"
   call ch datatype("Foobar",'W'), "0"
   call ch datatype("123",'W'), "1"
   call ch datatype("12.3",'W'), "0"
   call ch datatype("",'W'), "0"
   call ch datatype("Foobar",'X'), "0"
   call ch datatype("DeadBeef",'X'), "1"
   call ch datatype("A B C",'X'), "1"
   call ch datatype("123ABC",'X'), "1"
   call ch datatype("123AHC",'X'), "0"
   call ch datatype("",'X'), "1"



/* ====================== DELSTR ============================== */
call notify 'delstr'
   call ch delstr("Med lov skal land bygges", 6), "Med l"
   call ch delstr("Med lov skal land bygges", 6,10), "Med lnd bygges"
   call ch delstr("Med lov skal land bygges", 1), ""
   call ch delstr("Med lov skal", 30), "Med lov skal"
   call ch delstr("Med lov skal", 8,8), "Med lov"
   call ch delstr("Med lov skal", 12), "Med lov ska"
   call ch delstr("Med lov skal", 13), "Med lov skal"
   call ch delstr("Med lov skal", 14), "Med lov skal"
   call ch delstr("", 30), ""

/* ====================== DELWORD ============================== */
call notify 'delword' 
   call ch delword("Med lov skal land bygges", 3), "Med lov "
   call ch delword("Med lov skal land bygges", 1), ""
   call ch delword("Med lov skal land bygges", 1,1), "lov skal land bygges"
   call ch delword("Med lov skal land bygges", 2,3), "Med bygges"
   call ch delword("Med lov skal land bygges", 2,10), "Med "
   call ch delword("Med lov   skal land bygges", 3,2), "Med lov   bygges"
   call ch delword("Med lov   skal land   bygges", 3,2), "Med lov   bygges"
   call ch delword("Med lov skal land   bygges", 3,2), "Med lov bygges"
   call ch delword("Med lov skal land bygges", 3,0), "Med lov skal land bygges"
   call ch delword("Med lov skal land bygges", 10), "Med lov skal land bygges"
   call ch delword("Med lov skal land bygges", 9,9), "Med lov skal land bygges"
   call ch delword("Med lov skal land bygges", 1,0), "Med lov skal land bygges"
   call ch delword("  Med lov skal", 1,0), "  Med lov skal"
   call ch delword("  Med lov skal   ", 4), "  Med lov skal   "
   call ch delword("", 1), ""



/* ====================== DIGITS ============================== */
call notify 'digits'
   call ch digits(), '9'


/* ======================= D2C ============================== */
call notify 'd2c'
   call ch d2c(0), "00"x
   call ch d2c(127), "7f"x
   call ch d2c(128), "80"x
   call ch d2c(129), "81"x
   call ch d2c(1), "01"x
   call ch d2c(-1,1), "FF"x
   call ch d2c(-127,1), "81"x
   call ch d2c(-128,1), "80"x
   call ch d2c(-129,1), "7F"x
   call ch d2c(-1,2), "FFFF"x
   call ch d2c(-127,2), "FF81"x
   call ch d2c(-128,2), "FF80"x
   call ch d2c(-129,2), "FF7F"x
   call ch d2c(129,0), ""
   call ch d2c(129,1), "81"x
   call ch d2c(256+129,2), "0181"x
   call ch d2c(256*256+256+129,3), "010181"x


/* ======================= D2H ============================== */
call notify 'd2x'
/*   call ch d2x(0), "0" */
   call ch d2x(127), "7F"
   call ch d2x(128), "80"
   call ch d2x(129), "81"
   call ch d2x(1), "1"
   call ch d2x(-1,2), "FF"
   call ch d2x(-127,2), "81"
   call ch d2x(-128,2), "80"
   call ch d2x(-129,2), "7F"
   call ch d2x(-1,3), "FFF"
   call ch d2x(-127,3), "F81"
   call ch d2x(-128,4), "FF80"
   call ch d2x(-129,5), "FFF7F"
   call ch d2x(129,0), ""
   call ch d2x(129,2), "81"
   call ch d2x(256+129,4), "0181"
   call ch d2x(256*256+256+129,6), "010181"



/* ===================== ERRORTEXT ============================== */
call notify 'errortext'
   call ch errortext(10), "Unexpected or unmatched END"
   call ch errortext(40), "Incorrect call to routine"
   call ch errortext(50), ""
   call ch errortext( 1), ""



/* ======================== FORM ============================== */
call notify 'form'
   call ch form(), "SCIENTIFIC"


/* ======================= FORMAT ============================== */
/* ======================== FUZZ ============================== */
call notify 'fuzz'
   call ch fuzz(), "0"


/* ======================= INSERT ============================== */
call notify 'insert'
   call ch insert("abc","def"), "abcdef"
   call ch insert("abc","def",2), "deabcf"
   call ch insert("abc","def",3), "defabc"
   call ch insert("abc","def",5), "def  abc"
   call ch insert("abc","def",5,,'*'), "def**abc"
   call ch insert("abc","def",5,4,'*'), "def**abc*"
   call ch insert("abc","def",,0), "def"
   call ch insert("abc","def",2,1), "deaf"



/* ====================== LASTPOS ============================== */
call notify 'lastpos'
   call ch lastpos('b', 'abc abc'), 6
   call ch lastpos('b', 'abc abc',5), 2
   call ch lastpos('b', 'abc abc',6), 6
   call ch lastpos('b', 'abc abc',7), 6
   call ch lastpos('x', 'abc abc'), 0
   call ch lastpos('b', 'abc abc',20), 6
   call ch lastpos('b', ''), 0
   call ch lastpos('', 'c'), 1
   call ch lastpos('', ''), 0
   call ch lastpos('b', 'abc abc',20), 6
   call ch lastpos('bc', 'abc abc'), 6
   call ch lastpos('bc ', 'abc abc',20), 2
   call ch lastpos('abc', 'abc abc',6), 1
   call ch lastpos('abc', 'abc abc'), 5
   call ch lastpos('abc', 'abc abc',7), 5


/* ======================== LEFT ============================== */
call notify 'left'
   call ch left("foobar",1),     "f"
   call ch left("foobar",0),     ""
   call ch left("foobar",6),     "foobar"
   call ch left("foobar",8),     "foobar  "
   call ch left("foobar",8,'*'), "foobar**"
   call ch left("foobar",1,'*'), "f"



/* ======================= LENGTH ============================== */
call notify 'length'
   call ch length(""),            0
   call ch length("a"),           1
   call ch length("abc"),         3
   call ch length("abcdefghij"), 10



/* ======================== MAX ============================== */
call notify 'max'
   call ch max( 10.1 ),               "10.1"
   call ch max( -10.1, 3.8 ),         "3.8"
   call ch max( 10.1, 10.2, 10.3 ),   "10.3"
   call ch max( 10.3, 10.2, 10.3 ),   "10.3"
   call ch max( 10.1, 10.2, 10.3 ),   "10.3"
   call ch max( 10.1, 10.4, 10.3 ),   "10.4"
   call ch max( 10.3, 10.2, 10.1 ),   "10.3"
   call ch max( 1, 2,,, 4, 5 ),       "5"
   call ch max( -0, 0 ),              "0"
   call ch max( 1,2,3,4,5,6,7,8,7,6,5,4,3,2 ),   "8"


/* ======================== MIN ============================== */
call notify 'min'
   call ch min( 10.1 ),               "10.1"
   call ch min( -10.1, 3.8 ),         "-10.1"
   call ch min( 10.1, 10.2, 10.3 ),   "10.1"
   call ch min( 10.1, 10.2, 10.1 ),   "10.1"
   call ch min( 10.1, 10.2, 10.3 ),   "10.1"
   call ch min( 10.4, 10.1, 10.3 ),   "10.1"
   call ch min( 10.3, 10.2, 10.1 ),   "10.1"
   call ch min( 5, 2,,, 4, 1 ),       "1"
   call ch min( -0, 0 ),              "0"
   call ch min( 8,2,3,4,5,6,7,1,7,6,5,4,3,2 ),   "1"

/* ====================== OVERLAY ============================== */
call notify 'overlay'
   call ch overlay('foo', 'abcdefghi',3,4,'*'), 'abfoo*ghi'
   call ch overlay('foo', 'abcdefghi',3,2,'*'), 'abfoefghi'
   call ch overlay('foo', 'abcdefghi',3,4,), 'abfoo ghi'
   call ch overlay('foo', 'abcdefghi',3), 'abfoofghi'
   call ch overlay('foo', 'abcdefghi',,4,'*'), 'foo*efghi'
   call ch overlay('foo', 'abcdefghi',9,4,'*'), 'abcdefghfoo*'
   call ch overlay('foo', 'abcdefghi',10,4,'*'), 'abcdefghifoo*'
   call ch overlay('foo', 'abcdefghi',11,4,'*'), 'abcdefghi*foo*'
   call ch overlay('', 'abcdefghi',3), 'abcdefghi'
   call ch overlay('foo', '',3), '  foo'
   call ch overlay('', '',3,4,'*'), '******'
   call ch overlay('', ''), ''

/* ======================== POS ============================== */
call notify 'pos'
   call ch pos('foo','a foo foo b'), 3
   call ch pos('foo','a foo foo',3), 3
   call ch pos('foo','a foo foo',4), 7
   call ch pos('foo','a foo foo b',30), 0
   call ch pos('foo','a foo foo b',1), 3
   call ch pos('','a foo foo b'), 1
   call ch pos('foo',''), 0
   call ch pos('',''), 0
   call ch pos('foo','foo foo b'), 1


/* ====================== REVERSE ============================== */
call notify 'reverse'
   call ch reverse("foobar"),    "raboof"
   call ch reverse(""),          ""
   call ch reverse("fubar"),     "rabuf"
   call ch reverse("f"),         "f"
   call ch reverse("  foobar "), " raboof  "



/* ======================= RIGHT ============================== */
call notify 'right'
   call ch right("",4),           "    "
   call ch right("foobar",0),     ""
   call ch right("foobar",3),     "bar"
   call ch right("foobar",6),     "foobar"
   call ch right("foobar",8),     "  foobar"
   call ch right("foobar",8,'*'), "**foobar"
   call ch right("foobar",4,'*'), "obar"



/* ======================== SIGN ============================== */
call notify 'sign'
   call ch sign("0"),    0
   call ch sign("-0"),   0
   call ch sign("0.4"),  1
   call ch sign("-10"), -1
   call ch sign("15"),   1



/* ===================== SOURCELINE ============================== */
call notify 'sourceline'
   parse source . . srcfile .
   call ch sourceline(),   lines(srcfile)   /* don't work for stdin */
   call ch sourceline(whatline()-2), "   parse source . . srcfile ."
   call ch sourceline(whatline()-4), "call notify 'sourceline'"

   signal aftersrc
   whatline: return sigl
aftersrc:


/* ======================== SPACE ============================== */
call notify 'space'
   call ch space(" foo ")               ,"foo"
   call ch space("  foo")               ,"foo"
   call ch space("foo  ")               ,"foo"
   call ch space("  foo  ")             ,"foo"
   call ch space(" foo bar ")           ,"foo bar"
   call ch space("  foo  bar  ")        ,"foo bar"
   call ch space(" foo bar ",2)         ,"foo  bar"
   call ch space(" foo bar ",,"-")      ,"foo-bar"
   call ch space("  foo  bar  ",2,"-")  ,"foo--bar"
   call ch space(" f-- b-- ",2,"-")     ,"f----b--"
   call ch space(" f o o   b a r ",0)   ,"foobar"


/* ======================= STRIP ============================== */
call notify 'strip'
   call ch strip("  foo   bar   "),          "foo   bar"
   call ch strip("  foo   bar   ",'L'),      "foo   bar   "
   call ch strip("  foo   bar   ",'T'),      "  foo   bar"
   call ch strip("  foo   bar   ",'B'),      "foo   bar"
   call ch strip("  foo   bar   ",'B','*'),  "  foo   bar   "
   call ch strip("  foo   bar",,'r'),        "  foo   ba"
   



/* ======================= SUBSTR ============================== */
call notify 'substr'
   call ch substr("foobar",2,3),  "oob"
   call ch substr("foobar",3),  "obar"
   call ch substr("foobar",3,6),  "obar  "
   call ch substr("foobar",3,6,'*'),  "obar**"
   call ch substr("foobar",6,3),  "r  "
   call ch substr("foobar",8,3),  "   "



/* ======================= SUBWORD ============================== */
call notify 'subword'
   call ch subword(" to be or not to be ",5),  "to be"
   call ch subword(" to be or not to be ",6),  "be"
   call ch subword(" to be or not to be ",7),  ""
   call ch subword(" to be or not to be ",8,7),  ""
   call ch subword(" to be or not to be ",3,2),  "or not"
   call ch subword(" to be or not to be ",1,2),  "to be"
   call ch subword(" to be or not   to be ",4,2),  "not   to"



/* ======================= SYMBOL ============================== */

call notify 'symbol'
   parse value 'foobar' with alpha 0 beta 0 omega 0 gamma.foobar
   omega = 'FOOBAR'
   call ch symbol("HEPP"),         "LIT"
   call ch symbol("ALPHA"),        "VAR"
   call ch symbol("Un*x"),         "BAD" 
   call ch symbol("gamma.delta"),  "LIT"
   call ch symbol("gamma.foobar"), "VAR"
   call ch symbol("gamma.alpha"),  "LIT"
   call ch symbol("gamma.omega"),  "VAR"
   call ch symbol("gamma.Un*x"),   "LIT"
   call ch symbol("Un*x.gamma"),   "BAD"
   call ch symbol("!!"),           "LIT"


/* ======================= TRACE ============================== */


/* ====================== TRANSLATE ============================== */
call notify 'translate'
   call ch translate("Foo Bar"), "FOO BAR"
   call ch translate("Foo Bar",""), "Foo Bar"
   call ch translate("Foo Bar",,""), "       "
   call ch translate("Foo Bar",,"",'*'), "*******"
   call ch translate("Foo Bar",,xrange('01'x,'ff'x)), "Gpp!Cbs"
   call ch translate("","klasjdf","woieruw"), ""
   call ch translate("foobar","abcdef","fedcba"), "aooefr"



/* ======================= TRUNC ============================== */
call notify 'trunc'
   call ch trunc(1234.5678, 2), '1234.57'
   call ch trunc(-1234.5678), '-1235'
   call ch trunc(.5678), '1'
   call ch trunc(.1678), '0'
   call ch trunc(1234.5678), '1235'
   call ch trunc(4.5678, 7), '4.5678000'


/* ======================= VALUE ============================== */
call notify 'value'
   x.a = 'asdf'
   x.b = 'foo'
   x.c = 'A'
   a = 'B'
   b = 'C'
   c = 'A'

   call ch value('a'), 'B'
   call ch value(a), 'C'
   call ch value(c), 'B'
   call ch value('c'), 'A'
   call ch value('x.A'), 'foo'
   call ch value(x.B), 'B'
   call ch value('x.B'), 'A'
   call ch value('x.'||a), 'A'
   call ch value(value(x.b)), 'C'

   
/* ======================= VERIFY ============================== */
call notify 'verify'
   call ch verify('foobar', 'barfo', N, 1), 0
   call ch verify('foobar', 'barfo', M, 1), 1
   call ch verify('', 'barfo'), 0
   call ch verify('foobar', ''), 1
   call ch verify('foobar', 'barf', N, 3), 3
   call ch verify('foobar', 'barf', N, 4), 0
   call ch verify('', ''), 0



/* ======================== WORD ============================== */
call notify 'word'
   call ch word('This is certainly a test',1), 'This'
   call ch word('   This is certainly a test',1), 'This'
   call ch word('This    is certainly a test',1), 'This'
   call ch word('This    is certainly a test',2), 'is'
   call ch word('This is    certainly a test',2), 'is'
   call ch word('This is certainly a    test',5), 'test'
   call ch word('This is certainly a test   ',5), 'test'
   call ch word('This is certainly a test',6), ''
   call ch word('',1), ''
   call ch word('',10), ''



/* ====================== WORDINDEX ============================== */
call notify 'wordindex'
   call ch wordindex('This is certainly a test',1), '1'
   call ch wordindex('  This is certainly a test',1), '3'
   call ch wordindex('This   is certainly a test',1), '1'
   call ch wordindex('  This   is certainly a test',1), '3'
   call ch wordindex('This is certainly a test',2), '6'
   call ch wordindex('This   is certainly a test',2), '8'
   call ch wordindex('This is   certainly a test',2), '6'
   call ch wordindex('This   is   certainly a test',2), '8'
   call ch wordindex('This is certainly a test',5), '21'
   call ch wordindex('This is certainly a   test',5), '23'
   call ch wordindex('This is certainly a test  ',5), '21'
   call ch wordindex('This is certainly a test  ',6), '0'
   call ch wordindex('This is certainly a test',6), '0'
   call ch wordindex('This is certainly a test',7), '0'
   call ch wordindex('This is certainly a test  ',7), '0'


/* ===================== WORDLENGTH ============================== */
call notify 'wordlength'
   call ch wordlength('This is certainly a test',1), '4'
   call ch wordlength('This   is   certainly a test',2), '2'
   call ch wordlength('This is certainly a test',5), '4'
   call ch wordlength('This is certainly a test ',5), '4'
   call ch wordlength('This is certainly a test',6), '0'
   call ch wordlength('',1), '0'
   call ch wordlength('',10), '0'


/* ====================== WORDPOS ============================== */
call notify 'wordpos'
   call ch wordpos('This','This is a small test'), 1
   call ch wordpos('test','This is a small test'), 5
   call ch wordpos('foo','This is a small test'), 0
   call ch wordpos('  This  ','This is a small test'), 1
   call ch wordpos('This','  This is a small test'), 1
   call ch wordpos('This','This   is a small test'), 1
   call ch wordpos('This','this is a small This'), 5
   call ch wordpos('This','This is a small This'), 1
   call ch wordpos('This','This is a small This',2), 5
   call ch wordpos('is a ','This  is a small test'), 2
   call ch wordpos('is   a ','This  is a small test'), 2
   call ch wordpos('  is a ','This  is  a small test'), 2
   call ch wordpos('is a ','This  is a small test',2), 2
   call ch wordpos('is a ','This  is a small test',3), 0
   call ch wordpos('is a ','This  is a small test',4), 0
   call ch wordpos('test  ','This  is a small test'), 5
   call ch wordpos('test  ','This  is a small test',5), 5
   call ch wordpos('test  ','This  is a small test',6), 0
   call ch wordpos('test  ','This  is a small test   '), 5
   call ch wordpos('  test','This  is a small test   ',6), 0
   call ch wordpos('test  ','This  is a small test   ',5), 5
   call ch wordpos('      ','This  is a small test'), 0
   call ch wordpos('      ','This  is a small test',3), 0
   call ch wordpos('','This  is a small test',4), 0
   call ch wordpos('test  ',''), 0
   call ch wordpos('',''), 0
   call ch wordpos('','  '), 0
   call ch wordpos('  ',''), 0
   call ch wordpos('  ','',3), 0
   call ch wordpos(' a ',''), 0
   call ch wordpos(' a ','a'), 1


/* ======================= WORDS ============================== */
call notify 'words'
   call ch words('This is certainly a test'), 5
   call ch words('   This is certainly a test'), 5
   call ch words('This    is certainly a test'), 5
   call ch words('This is certainly a test   '), 5
   call ch words('  hepp '), 1
   call ch words('  hepp	hepp   '), 2
   call ch words(''), 0
   call ch words('   '), 0


/* ======================= XRANGE ============================== */
call notify 'xrange'
   call ch xrange('f','r'), 'fghijklmnopqr'
   call ch xrange('7d'x,'83'x), '7d7e7f80818283'x
   call ch xrange('a','a'), 'a'
    


/* ======================== X2C ============================== */
call notify 'x2c'
   call ch x2c("416263"), "Abc"
   call ch x2c("DeadBeef"), "deadbeef"x
   call ch x2c("1 2 3"), "010203"x
   call ch x2c("11 222 3333 44444"), "1102223333044444"x 
   call ch x2c(""), ""
   call ch x2c("   "), ""
   call ch x2c(" 2 "), "02"x
   call ch x2c("1   2   3"), "010203"x



/* ======================== X2D ============================== */
call notify 'x2d'
   call ch x2d( 'ff80', 1), "-128"
   call ch x2d( 'ff 80', 1), "-128"
   call ch x2d( '' ),      "0"
   call ch x2d( '101' ),  "257"
   call ch x2d( 'ff' ),   "255"
   call ch x2d( 'ffff'),  "65535"
   call ch x2d( 'ffff', 2), "-1"
   call ch x2d( 'ffff', 1), "-1"
   call ch x2d( 'fffe', 2), "-2"
   call ch x2d( 'fffe', 1), "-2"
   call ch x2d( 'ffff', 3), "65535"
   call ch x2d( 'ff7f', 1), "127"
   call ch x2d( 'ff7f', 2), "-129"
   call ch x2d( 'ff7f', 3), "65407"
   call ch x2d( 'ff80', 1), "-128"
   call ch x2d( 'ff80', 2), "-128"
   call ch x2d( 'ff80', 3), "65408"
   call ch x2d( 'ff81', 1), "-127"
   call ch x2d( 'ff81', 2), "-127"
   call ch x2d( 'ff81', 3), "65409"
   call ch x2d( 'ffffffffff'), "-1"

   


   say ' '
exit 0


ch: procedure expose sigl 
   parse arg first, second
   if first ^== second then do
      say
      say "first= /"first"/"
      say "second=/"second"/"
      say "FuncTrip: error in " sigl":" sourceline(sigl) ; end
   return


notify:
   parse arg word .
   written = written + length(word) + 2
   if written>75 then do
      written = length(word)
      say ' '
   end
   call charout , word || ', '
   return


error:
   say 'Error discovered in function insert()'
   return

