#ifndef lint
static char *RCSid = "$Id: traceing.c,v 1.4 1992/04/05 20:41:29 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: traceing.c,v $
 * Revision 1.4  1992/04/05  20:41:29  anders
 * Added copyright notice
 * Added routine to interpret and set tracing state.
 *
 * Revision 1.3  1992/03/22  01:14:39  anders
 * #include'd stdio.h
 * Commented out some external definitions, since some compilers
 *    didn't like the way it was written ... sigh...
 *
 * Revision 1.2  1991/06/03  02:58:49  anders
 * Changed definitions for pushcallstack() and popcallstack(), to
 *    make it possible to remove extra entries on return from function
 *    or subroutine.
 *
 * Revision 1.1  90/08/08  02:13:53  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>

static int traceflag = 0 ;
static int lasttracedline = -1 ;   
static int ctrlcounter = 0 ;
static int notnow = 0 ;

static char tracestr[LINELENGTH+1] ;

static nodeptr callstack[MAXLEVELS] ;


int pushcallstack( treenode *this )
{
/*   extern nodeptr callstack[] ; */
   extern int ctrlcounter ;
   
   if (ctrlcounter>=(MAXLEVELS))
      exiterror(11) ;
   callstack[ctrlcounter++] = this ;
 
   return ctrlcounter ;
}


void popcallstack( int value )
{
   extern int ctrlcounter ;

   if (value>=0)
      ctrlcounter = value ;

   if ((--ctrlcounter)<0) 
      exiterror(49) ;
}


void traceerror( treenode *this, int RC )
{
   extern proclevel currlevel ;
   char savedch ;

   if ((savedch=currlevel->tracestat)=='N') {
      currlevel->tracestat = 'C' ;
      traceline(this) ; 
      currlevel->tracestat = savedch ; }
   if (savedch!='O')
      printf("       +++ RC=%d +++\n",RC) ; 
}


void tracecompound( char *stem, int length, char *index )
{
   extern proclevel currlevel ;
   extern int ctrlcounter, traceflag ;
/*   extern char tracestr[] ; */
  
   if ((traceflag)||(currlevel->tracestat!='I'))
      return ;
   
   sprintf(tracestr,"       >C> %%%ds  \"%%.%ds.%%s\"\n",ctrlcounter,length) ;
   printf(tracestr,"",stem,index ) ; 
}


void starttrace() 
{
   extern int notnow ;
   notnow = 1 ;
}

void tracemsg()
{
   printf("       +++ Interactive trace. TRACE OFF to end debug, %s",
               "ENTER to continue. +++\n") ;
}


void intertrace()
{
   char *str ;
   extern int notnow, traceflag ;
  
   if (traceflag)
      return ;

   if (notnow==1) {
      notnow = 2 ;
      return ; }
   else if (notnow==2) {
      notnow = 0 ;
      tracemsg() ; }

   traceflag = 1 ;
   for (;;) {
      str = readkbdline() ;
      if (!*str) {
         traceflag = 0 ;
         return ; }

      dointerpret( str ) ; }
}


void tracevalue( char *str, char type )
{
   extern proclevel currlevel ;
   extern int ctrlcounter, traceflag ;
/*   extern char tracestr[] ; */
   char tmpch ;

   if (traceflag)
      return ;

   tmpch = currlevel->tracestat ;
   if ((tmpch=='I')||(tmpch=='R')) {
      sprintf(tracestr,"       >%%c> %%%ds  \"%%s\"\n",ctrlcounter) ;
      printf(tracestr,type,"", str) ; }
}

void traceline( treenode *this ) 
{
   char *srcstr, tch ;
/*   extern char tracestr[] ; */
   extern proclevel currlevel ;
   extern int ctrlcounter, lasttracedline ;
/*   extern sysinfo systeminfo ; */
   extern int traceflag ;
   
   if (traceflag)
      return ;

   tch = currlevel->tracestat ;

   if ((this->charnr<0)||(this->lineno<0)) 
      return ;

   if ((tch=='I')||(tch=='R')||(tch=='A')) goto trace ;
   if ((tch=='L')&&(this->type==X_LABEL)) goto trace ;
   if ((tch=='C')&&(this->type==X_COMMAND)) goto trace ;
   return ;

trace: {
       srcstr = getsourceline(this->lineno,this->charnr) ; 
       if (this->lineno==lasttracedline) {
          sprintf(tracestr,"       *-* %%%ds%%s\n",ctrlcounter) ;
          printf(tracestr,"", srcstr) ; }
       else {
          sprintf(tracestr,"%%6d *-* %%%ds%%s\n",ctrlcounter) ;
          printf(tracestr,this->lineno,"", srcstr) ; }
       lasttracedline = this->lineno ;
       Free(srcstr) ; }
}


void traceback( void )
{
   extern nodeptr currentnode /*, callstack[] */ ;
   extern int ctrlcounter ;
   static char fmt[20] ;
   nodeptr ptr ;
   int i ;

   sprintf(fmt,"%%6d +++ %%%ds%%s\n", ctrlcounter*3 ) ;
   fprintf(stderr,fmt,currentnode->lineno,"",
      getsourceline(currentnode->lineno,currentnode->charnr)) ;

   for (i=ctrlcounter-1;i>=0;i--) {
      ptr = callstack[i] ;
      if (!ptr)
         continue ;
      sprintf(fmt,"%%6d +++ %%%ds%%s\n", i*3 ) ;
      fprintf(stderr,fmt,ptr->lineno,"",
         getsourceline(ptr->lineno,ptr->charnr)) ; } ;
}



void set_trace( char *setting )
{
   extern sysinfo systeminfo ;
   extern proclevel currlevel ;
   char *cptr, ch ;

   for (cptr=setting; *cptr; cptr++)
   {
      if (*cptr=='?')
      {
          if (systeminfo->interactive = (!systeminfo->interactive))
             starttrace() ; 
      }
      else
      {
         switch (ch = getoption( cptr ) )
         {
            case 'F':
            case 'E':
               ch = 'N' ;

            case 'A':
            case 'C':
            case 'I':
            case 'L':
            case 'N':
            case 'O':
            case 'R':
            case 'S':
               currlevel->tracestat=ch ;
               return ;
               break ;

            default:
               exiterror( ERR_INVALID_TRACE ) ;
         }         
      }
   }
}
