#ifndef lint
static char *RCSid = "$Id: strmath.c,v 1.3 1992/04/05 19:52:35 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: strmath.c,v $
 * Revision 1.3  1992/04/05  19:52:35  anders
 * Added copyright notice
 *
 * Revision 1.2  1992/03/01  19:31:30  anders
 * Added includefile "rexx.h"
 *
 * Revision 1.1  1990/08/08  02:13:14  anders
 * Initial revision
 *
 */

#include "rexx.h"

void testit()
{
   char in[100], man[100], exp[100], en[100], to[100] ;
   extern proclevel currlevel ;
   int q ;
   static char *tests[] = {
      "123456789e78     ",
      "81818181",
      "123.987E000",
      "x" } ;

   for (q=0;(tests[q][0]!='x');q++) {
      strcpy(to,"+12334") ;
      strcpy(en,"+45212") ;
      subtwostrings(en,to,in) ;
      printf("%s//%s//%s//\n", en, to, in ) ; }

   exit( 0 ) ;
{
      printf("number of decimals: %d\n",normalize( in, man, exp )) ;
      printf("//%s//%s//%s//\n\n",in,man,exp) ; }
   exit( 0 ) ;
}

char *rexxstradd( char *ffirst, char *ssecond ) 
{
   static int max=MAXNUMERIC+1 ;
   char result[MAXNUMERIC+1], first[MAXNUMERIC+1], second[MAXNUMERIC+1] ;
   int fdecim, sdecim, rdecim ;
   char fexp[MAXNUMERIC+1], sexp[MAXNUMERIC+1] ;
   int i;
 
   /* Let's initiate the arrary on which we are going to operate */
   for (i=0;i<max;result[i++]='\0') ;
   normalize( ffirst, first, fexp ) ;
   normalize( ssecond, second, sexp ) ;

   /* Let's find the decimal point in the two strings */
   for (fdecim=0;(fdecim<max||first[fdecim]=='.');fdecim++) ;
   return ;
}

int normalize( char *in, char *out, char *exp ) 
{
   extern proclevel currlevel ;
   int start, stop, iout, iexp ;
   int point_not_found, delta_exp, max, size ;
   int num_decim, org_decim, istop ;

   /* skip any leading spaces */
   for (start=0;(in[start]==' ');start++) ;

   /* then, get the sign, and skip any spaces following it */
   if ((in[start]=='-')||(in[start]=='+')) {
      out[0] = in[start++] ;
      for (;(in[start]==' ');start++) ; }
   else
      out[0] = '+' ;

   /* Let us skip any leading zeros, they are not very interesting */
   for (;(in[start]=='0');start++) ;

   /* Now, let's copy the matissa part, skipping an the point if there */
   /* are any, however, we must note where the point was. */
   point_not_found = 1 ;
   stop = start ;
   iout = 1 ;
   num_decim = 0 ;
   while ((('0'<=in[stop])&&(in[stop]<='9'))||(in[stop]=='.')) {
      if (!point_not_found) num_decim++ ;
      if (in[stop++]=='.')
         if (point_not_found) {
            point_not_found = 0 ;
            delta_exp = iout - 1 ; }
         else 
            exiterror( 41 ) ;
      else 
         out[iout++] = in[stop-1] ; }
   out[iout] = '\000' ;

   /* what if we didnt find a decimal point, if so, then set value here */
   /* since the point is implicit at the end of the matissa */
   if (point_not_found)
      delta_exp = iout - 1 ;

   /* We need to know the original number of decimals */
   org_decim = iout - delta_exp ;

   /* Let's find the current numeric digits setting */
   size = currlevel->currnumsize + 1 ;

   /* now we must check for any exponents, and get it */
   iexp = 0 ;
   if ((in[stop]=='E')||(in[stop]=='e')) {
      /* Yup, we've got an exponent, let's see if we've got a sign too */
      if ((in[stop+1]!='+')&&(in[stop+1]!='-')) 
         exp[iexp++] = '+' ;
      else
         exp[iexp++] = in[++stop] ;

      /* And then, copy over the digits of the exponent */
      for (start=++stop;
         (('0'<=in[stop])&&(in[stop]<='9')&&(stop-start<size));
         exp[iexp++]=in[stop++]) ; }

   /* but if we dont have an exponent ... then */
   else {
      exp[iexp++] = '+' ;
      exp[iexp++] = '0' ; }

   /* Terminate the string, and test for trailing junk letters */
   exp[iexp] = '\0' ;
   for (;(in[stop]==' ');stop++) ;
   if (in[stop]!='\0')
      exiterror( 42 ) ;

   /* round off the matissa, and correct exponent for any changes in */
   /* magnitude of the number - due to the rounding off */
   delta_exp += aproximate( out, size+1 ) ;

   /* Compensate exponent for decimal point */
   istop = --iexp ;
   while ((in[iexp]!='-')&&(in[iexp]!='+')&&(delta_exp>0)) {
      exp[iexp] += (delta_exp % 10) ;
      delta_exp /= 10 ;
      if (exp[iexp]>'9') {
         exp[iexp] -= 10 ;
         delta_exp++ ; }
      iexp-- ; }

   /* So if we must increase the number of numerals in the exponent */
   while (delta_exp>0) {
      for (iexp=istop++;delta_exp>0;iexp--)
         exp[iexp+1] = exp[iexp] ;
      exp[1] = (delta_exp % 10) + '0' ; 
      delta_exp /= 10 ; }

   /* and so, let's cut off leading zeros, and give errormsg if the */
   /* magnitude of the exponent is to big */
   for (i=1;((exp[i]=='0')&&(exp[i]!='\000'));i++) ;
   for (j=1;(exp[i]!='\000');exp[j++]=exp[i++]) ;
   exp[j] = '\000' ;
   if (j>size)
      exiterror( 42 ) ;

   /* if the matissa part is zero, then everyting is zero ... */
   if (out[1]=='\000') {
      out[0] = exp[0] = '+' ;
      out[1] = exp[1] = '0' ;
      out[2] = exp[2] = '\000' ; }

   return num_decim ;
}

int aproximate( char *out, int size ) 
{
   int diff, i, j ;

   /* first, get rid of leading and trailing zeros */
   for (i=1;((out[i]=='0')&&(out[i]!='\000'));i++) ;
   for (j=1;(out[i]!='\000');out[j++]=out[i++]) ; 
   for (;(out[j-1]=='0');j--) ;
   out[j] = '\000' ;

   /* then truncate the number if cessary, (wonderfully ununderstandable) */
   if (j>size) {
      if (('5'<=out[size+1])&&(out[size+1]<='9')) {
         for (i=size;(out[i]!='9');i++) ;
         (j=(i==0)) ? out[++i] = '1' : out[i]++ ; }
      out[i] = '\0' ; }
   else
      j = 0 ;
   return j ;
}
        
         
void addtwostrings( char *one, char *two, char *answer ) 
{
   int i, j, carry, min, max ;
   register int res, k ;
   register char *p ;

   k = max = (((i=strlen(one))>(j=strlen(two))) ? (p=one,i) : (p=two,j)) - 1 ;
   min = (i<j ? i : j) - 1 ;

   for (carry=0;k>max-min;k--) {
      res = one[--i] + two[--j] + carry - '0' ;
      (carry=(res>'9')) ? (answer[k]=res-10) : (answer[k]=res) ; }

   for (p+=max-min;k>0;k--) {
      res = *(p--) + carry ;
      (carry=(res>'9')) ? (answer[k]=res-10) : (answer[k]=res) ; }

   answer[0] = '+' ;
   if (carry) {
      bcopy(answer+1,answer+2,max) ;
      answer[1] = '1' ; }
    
   answer[max+2] = '\000' ;

   return ;
}


void subtwostrings( char *one, char *two, char *answer ) 
{
   int i, j, carry, min, max ;
   register int res, k ;
   register char *p ;

   k = max = (((i=strlen(one))>(j=strlen(two))) ? (p=one,i) : (p=two,j)) - 1 ;
   min = (i<j ? i : j) - 1 ;

   for (carry=0;k>max-min;k--) {
      res = one[--i] - two[--j] + '0' - carry ;
      (carry=(res<'0')) ? (answer[k]=res+10) : (answer[k]=res) ; }

   if (p=one) 
      for (p+=max-min;k>0;k--) {
         res = *(p--) - carry ;
         (carry=(res<'0')) ? (answer[k]=res+10) : (answer[k]=res) ; }
   else
      for (p+=max-min;k>0;k--) {
         res = - *(p--) - carry ;
         (carry=(res<'0')) ? (answer[k]=res+10) : (answer[k]=res) ; }

   answer[0] = '+' ;
    if (carry) {
       bcopy(answer+1,answer+2,max) ;
       answer[1] = '1' ; }
    
   answer[max+2] = '\000' ;

   return ;
}
