#ifndef lint
static char *RCSid = "$Id: shell.c,v 1.8 1992/04/05 20:07:21 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: shell.c,v $
 * Revision 1.8  1992/04/05  20:07:21  anders
 * Mostly a reimplementation of the file, large changes to make it
 * POSIX complient, added copyright notice
 *
 * Revision 1.7  1992/03/22  18:55:33  anders
 * Defined fdopen() explicitly for CRAY
 *
 * Revision 1.6  1992/03/22  01:17:33  anders
 * Included some includefiles that were removed from rexx.h
 * Added functionallity for redirecting output to fifo.
 *
 * Revision 1.5  1992/03/01  19:27:40  anders
 * Changed the type of the parameter to wait(), so it might be
 *    configured more easily
 *
 * Revision 1.4  1991/04/06  00:21:07  anders
 * Simplified redirection of input/output
 * Fixed bug in processing output for stack
 *
 * Revision 1.3  90/12/10  00:08:28  anders
 * Removed bug which made all (external) commands return 0 as returncode.
 * 
 * Revision 1.2  90/08/11  00:43:18  anders
 * Changed mysystem() to call stack_empty() instead of trying to 
 *     figure that out by itself.
 * 
 * Revision 1.1  90/08/08  02:12:49  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <limits.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/wait.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/time.h>
#include <fcntl.h>
#include <assert.h>
#include <signal.h>

#if defined(CRAY)
FILE *fdopen( int fd, char *access ) ;
#endif

#ifndef PIPE_BUF  
/* At some systems the PIPE_BUF value might be obtained through the 
 *    pathconf() call, which only works for files ... argggh 
 * So, we set PIPE_BUF to the minimum specified by POSIX
 */
#define PIPE_BUF 512
#endif

typedef struct tmpstack
{
   struct tmpstack *next ;
   char *value ;
} tmpstackbox ;

static struct tmpstack *firstbox=NULL, *lastbox=NULL ;


void tmp_stack( char *value ) 
{
   extern struct tmpstack *firstbox, *lastbox ;

   if (lastbox)
      lastbox=lastbox->next=(struct tmpstack*)Malloc(sizeof(struct tmpstack));
   else
      firstbox = lastbox = (struct tmpstack*)Malloc(sizeof(struct tmpstack));

   lastbox->next = NULL ;
   lastbox->value = value ;
}


void flush_stack( int is_fifo ) 
{
   extern struct tmpstack *firstbox, *lastbox ;
   struct tmpstack *ptr, *tptr ;
   
   for (ptr=firstbox; ptr; ) 
   {
      if (is_fifo)
         stack_fifo( ptr->value ) ;
      else
         stack_lifo( ptr->value ) ;

      tptr = ptr ;
      ptr = ptr->next ;
      Free( (char*)tptr ) ;
   }
   firstbox = lastbox = NULL ;
}



int do_command( char *command, int in, int out, int fout, int envir ) ;

int perform( char *command, char *envir )
{
   int length, in, out, fout, rc, i ;
   extern char *environments[] ;


   if ((length=strlen(command))>5) 
   {
      in = (!memcmp(&command[0],"lifo>",5)) || 
            (!memcmp(&command[0],"LIFO>",5)) ; 
      out = (!memcmp(&command[length-5],">lifo",6)) ||
            (!memcmp(&command[length-5],">LIFO",6)) ; 
      fout =(!memcmp(&command[length-5],">fifo",6)) ||
            (!memcmp(&command[length-5],">FIFO",6)) ; 
   }

   if ((out)||(fout)) 
      command[length-5] = '\000' ;

   if (in)
      for(i=5; command[i-5]=command[i]; i++) ;


/*   if ((in)&&((out)||(fout)))  
      exiterror(ERR_INTERPRETER_FAILURE) ; */

   if (!strcmp(envir,environments[ENV_COMMAND]))
      rc = do_command( command, in, out, fout, ENV_COMMAND ) ;
   else if (!strcmp(envir, environments[ENV_PATH]))
      rc = do_command( command, in, out, fout, ENV_PATH ) ; 
   else if (!strcmp(envir, environments[ENV_SYSTEM]))
      rc = do_command( command, in, out, fout, ENV_SYSTEM ) ;
   else
   {
      fprintf(stderr, "Sorry, these environments are not yet implemented\n") ;
   /*   rc = do_program( command, envir ) ;*/
   }

   Free( command ) ;
   Free( envir ) ;
   return rc ;
}


char **makeargs( char *string ) 
{
   int i, words=0, j, k ;
   char **ccptr ;

   for (i=0; string[i]; i++)
      words += ((isgraph(string[i]))&&(!isgraph(string[i+1]))) ;

   ccptr = (char**)Malloc((words+2)*sizeof(char*)) ;
   for (j=1,i=0; j<=words; j++)
   {
      for(k=i; isgraph(string[i]); i++) ;
      strncpy(ccptr[j]=Malloc(i-k+1),&string[k],i-k) ;
      (ccptr[j])[i-k] = 0x00 ;
      for (; (string[i])&&(!isgraph(string[i])); i++) ;
   }
   ccptr[j] = NULL ;

   for (i=strlen(ccptr[1])-1; (i>=0)&&((ccptr[1])[i]!='/'); i--) ;
   strcpy( ccptr[0]=Malloc(strlen(&((ccptr[1])[i+1]))+1), &(ccptr[1])[i+1]) ;

   return ccptr ;
}


int do_command( char *command, int in, int out, int fout, int envir )
{
   char **args ;
   int child, rc, i, fdin[2], fdout[2] ;
   char *cmd ; 
   char *rstring=NULL, *string=NULL ;
   char *istring=NULL ;
   static char cbuff[PIPE_BUF+1] ;
   int length, rcode, j, flush, status ;
   char *result, flags ;

   flush = out + (fout<<2) ;

   if ((!in)&&(!out)&&(!fout))
   {
      ;       /* maybe this should not be allowed. ... */
   }

   if (envir != ENV_SYSTEM)
   {
      args = makeargs( command ) ;
      cmd = args[0] ;
      args++ ;
   }

   fflush( stdin ) ;
   fflush( stdout ) ;
   fflush( stderr ) ;

   if ((in)&&(pipe( fdin )))     /* for info from stack to child */
      perror("While opening input pipe") ;

   if ((out)&&(pipe( fdout )))   /* for info from child to stack */
      perror("While opening output pipe") ;

   signal( SIGPIPE, SIG_IGN ) ;

   if (child=fork())
   {
      if (in)
         close( fdin[0]) ;

      if (out)
         close( fdout[1] ) ;

      if ((in)&&((out)||(fout)))
      {
         fcntl( fdin[1], F_SETFL, O_NONBLOCK ) ;
         fcntl( fdout[0], F_SETFL, O_NONBLOCK ) ;
      }

      for (;(in)||(out);) 
      {
         if (in)
         {
            if (((!string)&&(!stack_empty())))
            {
               if (close(fdin[1]))
                  perror("During close") ; 
               in = 0 ; 
               if ((out)||(fout))
               {
                  flags = fcntl( fdout[0], F_GETFL ) ;
                  fcntl( fdout[0], F_SETFL, flags & (~O_NONBLOCK)) ;
               }
            }
            else  /* nothing left in string, but more in the stack */
            {
               if (!string)
               {
                  rstring = string = popline() ;
                  string[length=strlen(string)] = 0x0a ;
                  length++ ;
               }
               else
                  length = strlen(string) ;

               rcode = write( fdin[1], string, length ) ;

               if ((rcode==(-1))&&(errno==EAGAIN))
                  continue ;

               if ((rcode==(-1))&&(errno==EPIPE))
               {    
                  Free( string ) ;
                  for (; (stack_empty()); )
                     Free( popline() ) ;
                  string = rstring = NULL ;
                  continue ;
               }

               if (rcode==(-1))
               {
                  perror("While writing") ;
                  continue ;
               }

               else if (rcode<length)
               {
                  string = &string[rcode] ;
               }
               else
               {
                  assert( rcode==length ) ;
                  if (rstring) 
                     Free( rstring ) ;  
                  rstring = string = NULL ;
               }
            }
         }

         if (out) 
         {
            rcode = read( fdout[0], cbuff, PIPE_BUF ) ;
            if (rcode>0)
               cbuff[rcode] = 0x00 ;

            if ((rcode==(-1))&&(errno==EAGAIN))
               continue ;

            if ((rcode==(0))) 
            {
               close( fdout[0] ) ;
               if (in)
               {
                  flags = fcntl( fdin[1], F_GETFL ) ;
                  fcntl( fdin[1], F_SETFL, flags & (~O_NONBLOCK)) ;
               }            
               out = 0 ;
               break ;
            }

            for (i=j=0; (i<rcode)&&(cbuff[i]); i++)
            {
               if (cbuff[i]==0x0d)
                  cbuff[i] = ' ' ;

               if (cbuff[i]!=0x0a) 
                  continue ;

               if (istring)
               {
                  result = Malloc( (length=strlen(istring)) + i-j + 1 ) ;
                  strcpy( result, istring ) ;
                  strncpy( &result[length], &cbuff[j], i-j ) ;
                  result[length+i-j] = 0x00 ;
                  istring = NULL ;
               }
               else
               {
                  result = Malloc( (i-j) + 1 ) ;
                  strncpy( result, &cbuff[j], i-j ) ;
                  result[i-j] = 0x00 ;
               }

               if (out)
                  tmp_stack(result) ;
               else
                  tmp_stack(result) ;

               j = i + 1 ;
            }
            assert((j<=i)&&(j>=0)&&(i>=0)) ;
            if ((j<i)&&(!istring)) /* some leftover chars ... */
            {
               istring = Malloc( i-j+1 ) ;
               strncpy( istring, &cbuff[j], (i-j)) ;
               istring[i-j] = 0x00 ;
            }
            else if ((j!=i)&&(istring)) /* leftover chars but no lf */
            {
               result = Malloc( (length=strlen(istring)) + (i-j) + 1 ) ;
               strcpy( result, istring ) ;
               strcpy( &result[length], cbuff ) ;
               istring = result ;
            }
            else if ((i==j)) /* read ended with a lf */
            {
               assert( !istring ) ;
            }  

         }
      }

      if (flush)
         flush_stack( (flush==2) ) ;

      if (in) {	  
	close( fdin[0] ) ;
	close( fdin[1] ) ;
      }
      if (out) {
	close( fdout[0] ) ;
	close( fdout[1] ) ;
      }      
      waitpid( child, &status, 0 ) ;
      rc = (WIFEXITED(status)) ? (WEXITSTATUS(status)) : 0 ;

      signal( SIGPIPE, SIG_DFL ) ;
    }
   
   else
   {
     if (in)
     {
	close( 0 ) ;
        dup2( fdin[0], 0 ) ;
	close( fdin[0] ) ;
	close( fdin[1] ) ;
     }

     if (out)
     {
        close( 1 ) ;
        dup2( fdout[1], 1 ) ;
	close( fdout[0] ) ;
	close( fdout[1] ) ;
     }

     if ((in)&&((out)||(fout)))
        fcntl( 0, F_SETFL, O_NONBLOCK ) ; 

     if (envir==ENV_PATH) 
        execvp( cmd, args ) ;
     else if (envir==ENV_COMMAND)
        execv( cmd, args ) ;
     else if (envir==ENV_SYSTEM)
        exit( system( command ) ) ; 
     else
        fprintf(stderr, "Oppps, internal error ....\n" ) ;

     fprintf(stderr,"Rexx: Command not found: %s\n", cmd ) ;
     exit( errno ) ;  
  }
/*       destroyargs( args ) ; */
  return rc ;
}



int find_environment( char *envir ) 
{
   int i ;
   extern char *environments[] ;

   for (i=0; environments[i]; i++ ) 
      if (!strcmp(envir, environments[i]))
         return i ; 

   fprintf( stderr, "Environment not found\n" ) ;
   return 0 ;
}



char *run_popen( char *command, char *envir )
{
   char *cbuffer, *nresult=NULL, *result=NULL ;
   char **args, *cmd ;
   int rc, rsize, rcode, i, status ;
   int child, length ;
   int envirno ;
   int fd[2], print() ;

   fflush(stdin) ;
   fflush(stdout) ;
   fflush(stderr) ;

   pipe(fd) ;
   if (child=fork()) {
      close(fd[1]) ;
      rsize = 0 ;
      cbuffer = Malloc(PIPE_BUF+1) ;
      for (;;) {
         rcode = read( fd[0], cbuffer, PIPE_BUF ) ; 
       
         for (i=0; (cbuffer[i])&&(i<rcode); i++) 
            if ((cbuffer[i]==0x0a)||(cbuffer[i]==0x0d))
               cbuffer[i] = ' ' ;

         if (rcode>=0)
         {
            nresult = Malloc( (length=((result)?(strlen(result)):0))+rcode+1) ;
            if (result)
            {
               strncpy( nresult, result, length ) ;
               nresult[length] = 0x00 ;
               Free( result ) ; 
            }
            else
               nresult[0] = 0x00 ;
            strncat( result=nresult, cbuffer, rcode ) ;
            result[length+rcode] = 0x00 ;
         }
         
         if (rcode<0)
            perror( "While reading from pipe" ) ;

         if (rcode<=0) 
            break ; 
      }
      close(fd[0]) ;
      if (result[length+rcode-1] = ' ')
	 result[length+rcode-1] = 0x00 ; 
      
      waitpid( child, &status, 0 ) ;
      rc = (WIFEXITED(status)) ? (WEXITSTATUS(status)) : 0 ;
   }
   else 
   {
      dup2(fd[1],1) ;
      close(fd[0]) ;

      envirno = find_environment( envir ) ;
      if ((envirno==ENV_PATH)||(envirno==ENV_COMMAND))
      {
         args = makeargs( command ) ;
         cmd = args[0] ;
         args++ ;
      }         

      if (envirno==ENV_PATH)
         execvp( cmd, args ) ;
      else if (envirno==ENV_COMMAND)
         execv( cmd, args ) ;
      else if (envirno==ENV_SYSTEM)
         exit( system( command ) ) ; 
      else
         fprintf(stderr, "Oppps, internal error ....\n" ) ;

      fprintf(stderr, "REXX command failed\n") ;
      exit(-1) ; 
   }

/*  should this be set ?
   sprintf(rcode=Malloc(SMALLSTR), "%d", rc ) ;
   setvalue( "RC", rcode ) ; */
   return(result) ; 
   
}

