/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Id: rexx.h,v 1.11 1992/04/05 20:09:54 anders Exp anders $
 *
 * $Log: rexx.h,v $
 * Revision 1.11  1992/04/05  20:09:54  anders
 * Removed most of the unneccesary prototypes used for non-ANSI C
 * compilers, but added #include for time.h, which is needed in
 * extern.h in the getsecs() prototype.
 * Added copyright notice.
 *
 * Revision 1.10  1992/03/23  05:11:14  anders
 * Incremented STRINGSPACE.
 * Added DEFAULT_NUMFORM to have the default NUMERIC FORM
 *
 * Revision 1.9  1992/03/22  01:37:44  anders
 * Removed most of the #include of standard files
 * Removed most of the explicit defining of functions.
 *
 * Revision 1.8  1992/03/01  03:54:57  anders
 * Decreased the size of some of the definitions, to save memory
 * Shuffled around on some of the prototypes to make the compiler happy
 *
 * Revision 1.7  1991/06/03  02:50:23  anders
 * The usleep() call is #ifdef'ed out when HAS_USLEEP is not defined
 *
 * Revision 1.6  91/05/28  23:42:05  anders
 * Added cpp flag PATTERN_MEMORY to decide if newly allocated and
 * deallocated memory is to be overwritten by a certain byte value
 * 
 * Revision 1.5  91/05/25  02:48:06  anders
 * Put #ifdef's around definitions of standard C-routines, to avoid
 *    complains from C-compilers
 * 
 * Revision 1.4  91/04/05  23:42:03  anders
 * Added support for not including system header files, depending
 * on the setting of the cpp macro NO_INCLUDE
 * Changed some of the explicit declarations of routines in the system
 * library, to match the definitions in the latest version of the 
 * system include files.
 * 
 * Revision 1.3  90/12/10  00:28:09  anders
 * Redefined system() to return int, instead of void.
 * Removed some definitions of standard routines, as these now are 
 *     correctly defined in the includefiles for gcc.
 * 
 * Revision 1.2  90/08/09  03:58:16  anders
 * Moved '#include <malloc.h>' to memory.c (only placed used)
 * Created '#define TRACEMEM' for controlling tracing dynamic memory
 * 
 * Revision 1.1  90/08/08  02:05:13  anders
 * Initial revision
 * 
 */

/* Things you might want to change .... (at your own risk!!!) */

/*
 * define TRACEMEM to use tracing of dynamically allocated memory. This
 * is only useful when debugging memory management of the interpreter.
 * Some conditions must be fullfilled when using this (see memory.c).
 */
#define TRACEMEM

/*
 * define PATTERN_MEMORY to initiate newly allocated dynamic memory to
 * a particular value, and freed memory to be set to another value
 * before it is freed. Useful for debugging only.
 */
#define PATTERN_MEMORY


#include "defs.h"

#include "config.h"

#define MAXNUMERIC 64		/* Max setting for NUMERIC DIGITS 	*/
/* #define REXXDEBUG */		/* You probably don't want this ... :-) */

/* #define HAVE_STRMATH */	/* Do we have *real* REXX string math ? */
/* #define HAVE_MPMATH */	/* Do we have C ``mp'' math		*/
#define HAVE_CMATH		/* Do we have std. C math calls ? 	*/
#define MATH_TYPES 1		/* How many different types available	*/

#define LINELENGTH 1024         /* max linelength of source code        */
#define STACKSIZE 512		/* It might have to be increased	*/
#define STRINGSPACE 48000	/* You might to increase this too	*/
#define BUFFERSIZE 512          /* Size of input buffer, longest line   */
#define LOOKAHEAD 256           /* Size of input lookahead              */

#define MAXSTREAMSIZE 1024      /* max length of linein() */
#define SMALLSTR 5              /* For holding small integers		*/
#define NULL_STR_LENGTH 1
#define BOOL_STR_LENGTH 2

#define DEFAULT_TRACING		'O'
#define DEFAULT_INT_TRACING	0
#define DEFAULT_NUMFORM         0 /* scientific */
#define DEFAULT_ENVIRONMENT 	ENV_SYSTEM
#define NESTEDCOMMENTS          /* The Standard wants them ....         */

#ifdef SUNOS
#define SUN_STRTOD_BUG
#endif /* SUNOS */


/* The following have been included to support national languages.       */
/*    English has a small set of letters. In the ASCII alphabet the      */
/*    English uppercase letters occupy the range from d2c(65) to d2c(90) */
/*    and the lowercase version of each letter have an offset of +32     */
/*    from the corresponding uppercase letter.                           */
/*                                                                       */
/* You may define FIRST_CHAR and LAST_CHAR to the lowermost and the      */
/*    uppermost letters of the uppercase alphabet. And you may define    */
/*    CHAR_OFFSET as the difference between upper- and lowercase.        */
/*    other Western European languages                                   */

#define FIRST_CHAR 	'A'
#define LAST_CHAR 	'Z'
#define CHAR_OFFSET	32

#define HEXNUM(c) (((c>='0')&&(c<='9'))||((c>='a')&&(c<='f')))


#define PARSE_VERSION_STRING	"REXX-UNIX 3.50-Alfa 24 Sep 1989"

#define TRUE 1
#define FALSE 0


/* Things you probably don't want to change ....			*/

#include <stdlib.h>
#include <sys/types.h>

#include "types.h"		/* various types */
#include "extern.h"		/* function prototypes */

#define Malloc(bytes)	mymalloc(bytes)
#define Free(ptr)	myfree(ptr)



