#ifndef lint
static char *RCSid = "$Id: rexx.c,v 1.7 1992/04/05 20:11:43 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: rexx.c,v $
 * Revision 1.7  1992/04/05  20:11:43  anders
 * Added copyright notice.
 * Added support for more environments
 * Added better processing of command line
 *
 * Revision 1.6  1992/03/23  05:12:08  anders
 * Added strings for the possible NUMERIC FORM's
 *
 * Revision 1.5  1992/03/22  01:01:48  anders
 * #included files which were not included in rexx.h enymore
 * Removed references to the filetable, moved to files.c
 * Added call to initfiletable() to initiate it.
 * Added call to initscanner to set up lex properly
 * removed \b (backspace) from strings, SGI dont like it (yuk!)
 *
 * Revision 1.4  1992/03/01  19:00:25  anders
 * Added new routine mark_systeminfo() to improve on memory management
 *
 * Revision 1.3  1990/08/11  00:38:04  anders
 * Removed call to initstack(), stack is automatically initiated
 *
 * Revision 1.2  90/08/09  04:02:36  anders
 * Changed magic nummer with TRC_* macro
 * 
 * Revision 1.1  90/08/08  02:12:16  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <string.h>
#include <stdio.h>

proclevel currlevel, mainlevel ;
nodeptr rootnode ;
sysinfo systeminfo ;

int nextstart=1, thischar=1, nextline=1, tstart, tline ;

char *environments[] = { "SH", "CSH", "COMMAND", "PATH", "SYSTEM" } ;

char *numeric_forms[] = { "SCIENTIFIC", "ENGINERING" } ;

char *WeekDays[] = { "Sunday", "Monday", "Tuesday", "Wednesday",
   "Thursday", "Friday", "Saturday" } ;

char *months[] = {
   "January", "February", "March", "April", "May", "June",
   "Juli", "August", "September", "October", "November", "December" } ;

#ifdef TRACEMEM
void marksubtree( nodeptr ptr )
{
   int i ;
   if ( ptr ) {
      markmemory((char *)ptr,TRC_TREENODE) ;
      for (i=0;i<5;marksubtree(ptr->p[i++])) ; }
}
         
void marktree() 
{
   extern treenode *rootnode ;
   marksubtree( rootnode ) ;
}
#endif /* TRACEMEM */


void findmothers( nodeptr tree, int lineno )
{
   int i ;

   for (i=0;i<5;i++)
      if (tree->p[i]!=NULL) {
         tree->p[i]->mother = tree ;
         if (tree->charnr== -1)
            tree->lineno = -1 ;
         findmothers(tree->p[i],lineno) ; }
}


int main(int argc,char **argv)
{
   extern proclevel currlevel, mainlevel ;
   extern treenode *rootnode ;
   extern char *environments[] ;
   extern sysinfo systeminfo ;
   extern FILE *yyin ;
   char *result, *string ;
   int rccode, i, j, stdinput=1 ;

   systeminfo = (sysinfo)Malloc(sizeof(sysinfobox)) ;
   systeminfo->environment = environments[DEFAULT_ENVIRONMENT] ;  
   systeminfo->tracing = DEFAULT_TRACING ; 
/* systeminfo->tracing = 'I' ; */ 
   systeminfo->interactive = DEFAULT_INT_TRACING ;
   systeminfo->called_as = Malloc(strlen(argv[0])+1) ;

   initfiletable() ;

   strcpy(systeminfo->called_as, argv[0]) ;
   mainlevel = currlevel = newlevel( NULL ) ; 

   i = 1 ;
   if ((argc>=2)&&(strcmp(argv[1],"-")))
   {
      stdinput = 0 ;
      systeminfo->input_file = Malloc(strlen(argv[i])+1) ;
      strcpy(systeminfo->input_file, argv[i]) ; 
      yyin=fopen(argv[i],"r") ;
      if (!yyin)
         exiterror( ERR_NO_SUCH_FILE ) ;
    }
    else {
      strcpy(systeminfo->input_file=Malloc(8),"<stdin>") ; }

   for (j=0,i=2;i<argc;i++)
      j += strlen(argv[i]) + 1 ;

   currlevel->args = (paramboxptr)Malloc(sizeof(parambox)) ;
   currlevel->args->value = argv[1] ;
   currlevel->args->next = (paramboxptr)Malloc(sizeof(parambox)) ;
   currlevel->args->next->next = NULL ;
   currlevel->args->next->value = string = Malloc( (j)?j:1 ) ;

   for (string[0]='\000',i=2;i<argc;i++) {
      strcat(string,argv[i]) ;
      strcat(string," ") ; }
   string[(j)?(j-1):0] = '\000' ;

   initscanner() ;
   if (rccode=yyparse()) return rccode ;
   if (stdinput) {
      printf("  %c%c",(char)0x08,(char)0x08) ;   /* f*ck sgi! */
      fflush(stdout) ;
      rewind(stdin) ; }

#ifdef REXXDEBUG
   printf("Starting to dump parse tree to <stdout>\n\n") ;
   dumptree(rootnode,1) ; 
#endif /* REXXDEBUG */

   if (rootnode) {
      findmothers(rootnode,1) ;
      rootnode->mother = NULL ; }
   result = interpret(rootnode) ;

#ifdef REXXDEBUG
   dumpvars( NULL ) ;
#endif /* REXXDEBUG */

   return((result==NULL) ? 0 : myatol( result )) ;
   
}


void mark_systeminfo()
{
   extern sysinfo systeminfo ;

   markmemory((char*)systeminfo, TRC_SYSINFO) ;
   markmemory(systeminfo->called_as, TRC_SYSINFO) ;
   markmemory(systeminfo->input_file, TRC_SYSINFO) ;
   markmemory(systeminfo->environment, TRC_SYSINFO) ;
}

