#ifndef lint
static char *RCSid = "$Id: parsing.c,v 1.8 1992/04/05 20:12:52 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: parsing.c,v $
 * Revision 1.8  1992/04/05  20:12:52  anders
 * Added copyright notice, and ANSI-fied some #includes
 *
 * Revision 1.7  1992/03/22  01:19:43  anders
 * Added some include-files which where removed from rexx.h
 * Removed static-decl from some prototypes, sgi didn't like it.
 * Casted strlen() to (int) ... sgi didn't like it ...
 * Added support for TAB as whitespace.
 *
 * Revision 1.6  1992/03/01  19:14:13  anders
 * Added new parameter to doparse(), to be able to differ between the
 *    start of the previous pattern, and the end of it. This fixes a
 *    bug in the previous version.
 *
 * Revision 1.5  1992/02/29  00:04:08  anders
 * Fixed bug, positional numbers and offsets should refer to the
 *    start of the previous matched pattern
 *
 * Revision 1.4  1992/02/28  20:50:19  anders
 * Numerous changes, documentation added.
 * Concept added, parses the template in two levels instead of three
 *    (which is incorrect) levels where offsets and pattern were
 *    viewed as different levels.
 * Fixed bug where last variable in a series of variables were not
 *    seen as special, so leading space *were* stripped from several
 *    of the variables before the last.
 * Fixed a lot of new bugs introduced when rewriting the code.
 * Removed doparse2() routine, that are not needed anymore
 *
 * Revision 1.3  1991/05/25  02:39:32  anders
 * Changed the local function 'strstr' to 'mystrstr' to avoid collision
 *    with the 'strstr' version in the C-library
 *
 * Revision 1.2  90/12/10  00:25:15  anders
 * Defined strstr() as a local function inside this file. strstr() 
 *     is a SystemV routine, and a local inplementation is provided 
 *     with this distribution.
 * 
 * Revision 1.1  90/08/08  02:12:06  anders
 * Initial revision
 * 
 */

/*
 * This implementation of the REXX parse template is quite near to
 * what Cowlishaw specified in his book, but there is one very
 * important difference. Cowlishaw sees a template as patterns and
 * variables, with patterns in each end (and some of the patterns
 * and/or the variables might be empty).
 * 
 * The concept here is any sequence of variables and patterns, and 
 * the system is parsed into two levels and interpreted as such. 
 * First there is the level of patterns, which is anchored to 
 * particular places in the string to be parsed. 
 *
 * When the anchor-points are determined, the variables are filled 
 * in with the parts of the string that comes between each anchor. 
 *
 * In addition to the anchors that are specified, there are one 
 * anchor at the beginning of the template specifying char 1, and
 * one anchor at the end. 
 */

#include "rexx.h"
#include <ctype.h>
#include <string.h>

/* these should be static, but sgi doesn't understand that ... */
void doparse3( char *start, nodeptr this, char *stop ) ;
char *mystrstr( char *heystack, char *needle ) ;
     


paramboxptr parseargtree( nodeptr this, paramboxptr argbox, int upper ) 
{
   int i ;
   char *source ;

   for (i=0;i<5;i++) {
      if ((this->p[i])&&(this->p[i]->type==X_TMPLS))
         argbox = parseargtree( this->p[i], argbox, upper ) ;
      else
         if (this->p[i]) {
            if ((argbox)&&(argbox->value))
               source = argbox->value ;
            else
               source = nullstringptr() ;

            if (upper) (void)upcase( source ) ;      
            doparse( source, this->p[i], 0, 0 ) ;
            if (argbox)
               argbox = argbox->next ; } ; }

   return argbox ;
}


/*
 * This routine parses a string (source) into the template that is 
 * specified by the structure in the (this) tree. (start) is the 
 * start postion into the (source) string.
 */

void doparse( char *source, nodeptr this, int start, int point ) 
{
   int length, end, nextstart, solid ;
   char *pattern, *stop ;

   length = strlen( source ) ;

   pattern = "" ;
   if (this->p[1]) 
   {
      solid = this->p[1]->type ;
      if ((solid==X_TPL_MVE)||(solid==X_TPL_VAR)) 
      {
         if (solid==X_TPL_MVE) 
            pattern = this->p[1]->name ;
         else
            pattern = getvalue( this->p[1]->name,1 ) ;

         stop = mystrstr( &source[start], pattern ) ;
         end = (stop) ? (stop-source) : 0 ;
         if ((!end)||(end>length))
            end = length ;

         nextstart = end + strlen(pattern) ;
      }
      else
      {
         end = myatol( this->p[1]->name ) ;
         if (solid==X_NEG_OFFS) 
         {
            nextstart = point - end ;
            end = length ; 
         }
         else if (solid==X_POS_OFFS)
            nextstart = end = point + end ;
         else if (solid==X_ABS_OFFS)
            nextstart = --end ; 
      }
   }
   else 
      end = nextstart = length ;

   if (nextstart>length) nextstart = length ;
   if (nextstart<0) nextstart = 0 ;

   if ((end>length)||(end<=(start-(int)strlen(pattern)))) 
      end = length ;

   if (this->p[0])
      doparse3( &source[start], this->p[0], source+end ) ;

   if (this->p[2]) 
      doparse( source, this->p[2], nextstart, nextstart-strlen(pattern) ) ;   
}


/*
 * This parses a part of the source string, determined by (start)
 * and (stop) into the variables of the (this) tree. Only variables
 * are handled, not patterns.
 */

void doparse3( char *start, nodeptr this, char *stop ) 
{
   char *rstart, *nextstart, tempch ;

   if (this->p[0]) 
   {
      for (;(start<stop)&&(isspace(*start));start++) ;
      for (rstart=start;(rstart<stop)&&(!isspace(*rstart));rstart++) ;
      nextstart = (rstart==stop) ? stop : rstart+1 ;
   }
   else 
      rstart = stop ;

   tempch = *rstart ;
   *rstart = '\000' ;
   if (this->type==X_TPL_SYMBOL) {
      setvalue( this->name, start ) ;
      tracevalue(start,'>') ; }

   else 
      tracevalue(start,'.') ;

   *rstart = tempch ; 

   if (this->p[0]) 
      doparse3( nextstart, this->p[0], stop ) ;
}


/*
 * This is a quick and dirty implementation of the System V strstr()
 * routine, it really should be rewritten!!!
 */

char *mystrstr( char *heystack, char *needle ) 
{
   int length ;
   length = strlen( needle ) ;
   while (*(heystack+length-1)) {
      if (!memcmp(heystack,needle,length)) return heystack ;
      heystack++ ; }
   return NULL ;
}

