#ifndef lint
static char *RCSid = "$Id: misc.c,v 1.4 1992/04/05 20:14:38 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: misc.c,v $
 * Revision 1.4  1992/04/05  20:14:38  anders
 * Added copyright notice
 * Fixed bug where signed char were set to 0x80
 * Packed in gettimeofday() into some cpp macros, and implemented
 *    an alternative (which is far from as good as gettimeofday())
 * Implemented my own versions of strcasecmp and strncasecmp
 *
 * Revision 1.3  1992/03/22  01:31:26  anders
 * Added definition of gettimeofday()
 * Implemented getsecs() for interface to gettimeofday()
 * Implemented xor()
 *
 * Revision 1.2  1990/08/11  00:36:00  anders
 * Moved nullstringptr to misc.c from stack.c
 *
 * Revision 1.1  90/08/08  02:11:14  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <ctype.h>

#ifdef HAS_TIMEVAL
# ifdef _POSIX_SOURCE
#  undef _POSIX_SOURCE
#  include <sys/time.h>
#  define _POSIX_SOURCE
# else
#  include <sys/time.h>
# endif
   int gettimeofday( struct timeval *tp, struct timezone *tpz) ;
#else
# include <time.h>
#endif /* HAS_TIMEVAL */



int strccmp( char *one, char *two )
{
   int i = 0  ;
   for (; (one[i])&&(two[i])&&((tolower(one[i]))==(tolower(two[i]))); i++) ;
   return one[i]-two[i] ;
}


int strnccmp( char *one, char *two, int l )
{
   int i = 0 ;
   for (;(i<l)&&(one[i])&&(two[i])&&((tolower(one[i]))==(tolower(two[i])));)
      i++ ;

   if (i>=l)
      return 0 ;

   return one[i]-two[i] ;
}


char *upcase( char *source ) 
{
   int i ;
   char ch ;

   for (i=0;(ch=source[i]);i++)
      if ((ch<=LAST_CHAR+CHAR_OFFSET)&&(ch>=FIRST_CHAR+CHAR_OFFSET))
         source[i] -= CHAR_OFFSET ;
   
   return source ;
}


void getsecs( time_t *secs, time_t *usecs )
{
#ifdef HAS_TIMEVAL
   struct timeval times ;

   gettimeofday(&times, NULL) ;
   *secs = times.tv_sec ;
   *usecs = times.tv_usec ;
#else
   *secs = time(NULL) ;
   *usecs = 0 ;
#endif
}



char *nullstringptr( void ) 
{
   char *string ;

   string = Malloc(NULL_STR_LENGTH) ;
   string[0] = '\000' ;
   return string ;
}
 


char xor( char one, char two )
{
   int i ;
   unsigned char outchar=0, m[] = {1,2,4,8,16,32,64,128} ;
 
  for (i=0;i<8;i++)
      if (( (one&m[i]) && (!(two&m[i])) ) || ( (!(one&m[i])) && (two&m[i]) ))
         outchar += m[i] ;

   return outchar ;
}

