#ifndef lint
static char *RCSid = "$Id: maths.c,v 1.3 1992/04/05 19:43:25 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: maths.c,v $
 * Revision 1.3  1992/04/05  19:43:25  anders
 * Added copyright notice.
 *
 * Revision 1.2  1992/03/01  19:17:21  anders
 * Removed the system where the apropriate .c files where included
 *    directly into this files, it was really not a Good concept.
 *
 * Revision 1.1  1990/08/08  02:10:48  anders
 * Initial revision
 *
 */

#include "rexx.h"
#include <math.h>

#define ADD 0
#define SUB 1
#define MULT 2
#define DIV 3
#define IDIV 4
#define REMINDER 5
#define NEGATE 6
#define LOGICAL_OR 7
#define LOGICAL_AND 8
#define MATH_FUNCS 9

/*
#define STRMATH 0
#define MPMATH 1
#define CMATH 2

char *(mathtypes[]) = 
   { "STRMATH", "MPMATH", "CMATH" } ;
 */

#define CMATH 0
char *(mathtypes[]) =
   { "CMATH" } ;

#ifdef HAVE_STRMATH
void stradd( char *one, char *two, char *answer ) ;
void strsub( char *one, char *two, char *answer ) ;
void strmult( char *one, char *two, char *answer ) ;
void strdiv( char *one, char *two, char *answer ) ;
void stridiv( char *one, char *two, char *answer ) ;
void strrem( char *one, char *two, char *answer ) ;
#endif /* HAVE_STRMATH */

#ifdef HAVE_MPMATH
void mpadd( char *one, char *two, char *answer ) ;
void mpsub( char *one, char *two, char *answer ) ;
void mpmult( char *one, char *two, char *answer ) ;
void mpdiv( char *one, char *two, char *answer ) ;
void mpidiv( char *one, char *two, char *answer ) ;
void mprem( char *one, char *two, char *answer ) ;
#endif /* HAVE_MPMATH */

#ifdef HAVE_CMATH
void cadd( char *one, char *two, char *answer ) ;
void csub( char *one, char *two, char *answer ) ;
void cmult( char *one, char *two, char *answer ) ;
void cdiv( char *one, char *two, char *answer ) ;
void cidiv( char *one, char *two, char *answer ) ;
void crem( char *one, char *two, char *answer ) ;
void cneg( char *one, char *answer ) ;
void clogor( char *one, char *two, char *answer ) ;
void clogand( char *one, char *two, char *answer ) ;
#endif /* HAVE_CMATH */


void (*funcs[][MATH_FUNCS])() = { 
#ifdef HAVE_STRMATH
   { stradd, strsub, strmult, strdiv, stridiv, strrem },
#endif /* HAVE_STRMATH */
#ifdef HAVE_MPMATH
   { mpadd, mpsub, mpmult, mpdiv, mpidiv, mprem },
#endif /* HAVE_MPMATH */
#ifdef HAVE_CMATH
   { cadd, csub, cmult, cdiv, cidiv, crem, cneg, clogor, clogand }
#endif /* HAVE_CMATH */
} ;


char *add( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;
   
   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][ADD]( one, two, answer ) ;
   return answer ;
}


char *subtract( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;

   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][SUB]( one, two, answer ) ;
   return answer ;
}


char *multiply( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;

   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][MULT]( one, two, answer ) ;
   return answer ;
}


char *devide( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;

   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][DIV]( one, two, answer ) ;
   return answer ;
}


char *intdevide( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;

   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][IDIV]( one, two, answer ) ;
   return answer ;
}


char *reminder( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;

   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][REMINDER]( one, two, answer ) ;
   return answer ;
}


char *negate( char *one )
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;

   answer = Malloc( (currlevel->currnumsize)*2 + 3 ) ;
   funcs[currlevel->mathtype][NEGATE]( one, answer ) ;
   return answer ;
}


char *logical_or( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;
   
   answer = Malloc(SMALLSTR) ;
   funcs[currlevel->mathtype][LOGICAL_OR]( one, two, answer) ;
   return answer ;
}


char *logical_and( char *one, char *two ) 
{
   extern proclevel currlevel ;
   extern void (*funcs[][MATH_FUNCS])() ;
   char *answer ;
   
   answer = Malloc(SMALLSTR) ;
   funcs[currlevel->mathtype][LOGICAL_AND]( one, two, answer) ;
   return answer ;
}


int true( char *string ) 
{
   if ((string[1])||((string[0]!='0')&&(string[0]!='1')))
      exiterror(ERR_UNLOGICAL_VALUE) ;

   return (string[0]=='1') ;
}
