%{

#ifndef lint
static char *RCSid = "$Id: lexsrc.l,v 1.7 1992/04/05 20:40:21 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: lexsrc.l,v $
 * Revision 1.7  1992/04/05  20:40:21  anders
 * Added copyright notice
 * Added support for traceing, had to set up limits for allocations
 *
 * Revision 1.6  1992/03/23  05:13:36  anders
 * Fixed bug that (randomly) didn't recognize "12"x as a hexstring
 *    because of the double-quotes (singel-quote were ok)
 *
 * Revision 1.5  1992/03/22  00:44:58  anders
 * Made the code compatible with standard lex. This includes:
 *    - directives for space allocations
 *    - setting initial startcondition through yy_start
 *    - checking for FLEX_SCANNER to see if yy_init should be set
 *    - making all rules case-insensitive.
 *
 * Revision 1.4  1992/02/29  13:27:39  anders
 * Fixed two bugs.
 * When parsing with value, the value-mode ends at 'with'
 * When reading input, ',' the interpreter will not try to interpret
 *    any ',' as a line continuation.
 *
 * Revision 1.3  1991/04/05  23:31:47  anders
 * Added a cludge to make the  #include <rexx.h>  not include any
 * of the system include-files ... this ought to be done *better*
 *
 * Revision 1.2  90/12/10  17:38:26  anders
 * Removed bug that made it impossible to use with as a variable name
 * in a parse-statement (f.ex  parse var x one with two )
 * 
 * Revision 1.1  90/08/08  02:28:41  anders
 * Initial revision
 * 
 * Revision 1.1  90/08/08  02:23:41  anders
 * Initial revision
 * 
 */

#define NO_INCLUDE
#include "rexx.h"
#include "symbols.h"

#ifdef FLEX_SCANNER
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size)\
     { int c=mygetchar(); result=((c==EOF)?YY_NULL:(buf[0]=c,1)) ; }
#else
#undef input
#define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):mygetchar())==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#endif


int obs_with=0, in_do=0, in_then=0, commentlevel=0, dontlast=0 ;
int sum=0, flag=1, nnextstart=0, nnextline ;
extern int nextline ;
int i, j, k, code=0, next=0, in_parse=0, support=0, in_trace=0, itflag=0 ;
int seek_with=0 ;
static int firsttime=0, prev=0, last=0 ;
char retvalue[256], char1, ch ;
extern int thischar, nextstart, tstart, tline ;
char *rmspc( char *instr ) ;
void striptext( char *text ) ;
%}


%start nothing comm trace signal sigtype procd parse then with
%start numeric do1 other value1 ifcont

%e 3000
%p 30000
%k 2000
%a 20000
%n 1500
%o 20000

%{
int yy_startcond=comm ;
%}

not [\\^]

csym [0-9.][a-zA-Z0-9.@#$!?_]* 
ssym [a-zA-Z@#$!?_][a-zA-Z0-9.@#$!?_]*
sym [a-zA-Z0-9.@#$!?_]+
hsym [ a-fA-F0-9]
hex {bl}*{hsym}*({bl}+({hsym}{hsym})+)*{bl}*

a [aA]
b [bB]
c [cC]
d [dD]
e [eE]
f [fF]
g [gG]
h [hH]
i [iI]
j [jJ]
k [kK]
l [lL]
m [mM]
n [nN]
o [oO]
p [pP]
q [qQ]
r [rR]
s [sS]
t [tT]
u [uU]
v [vV]
w [wW]
x [xX]
y [yY]
z [zZ]


bl (\ |\~|\t)*
bbl (\ |\t)+

%%

   { /* if (nnextstart) {
           nextline += support ; 
           nextstart = nnextstart ;
           nnextstart = support = 0 ; } */

     if (next==1) {
        next = 0 ;
        last = (dontlast==0) ;
        dontlast = 0 ;
        return code ; }

     if (itflag)
        in_trace = in_trace = seek_with = 0 ;
     itflag = (in_trace) ;
     
     tstart = thischar ;
     tline = nextline ;
     prev = last ;
     last = 0 ; }

\~ ;

<ifcont>{bl}[;\n]{bl} {
   nextstart = thischar ;   
   return STATSEP ; }

{bl}[;\n]{bl} {
   BEGIN comm ;
   if (obs_with==1)
      exiterror( 38 ) ;
   obs_with = in_do = 0 ;
   in_parse = 0 ;
   nextstart = thischar ;   
   return STATSEP ; }

<nothing>. {
   exiterror( 21 ) ; }

<comm>{bl}{a}{d}{d}{r}{e}{s}{s}{bl} {
   BEGIN value1 ;
   return ADDRESS ; }

<comm>{bl}{a}{r}{g}{bl} {
   BEGIN other ;
   in_parse = 1 ;
   return ARG ; }

<comm>{bl}{c}{a}{l}{l}{bl} {
   BEGIN other ;
   return CALL ; }

<comm>{bl}{d}{o}{bl} {
   BEGIN do1 ;
   in_do = 1 ;
   return DO ; }

<comm>{bl}{d}{r}{o}{p}{bl} {
   BEGIN other ;
   return DROP ; }

<comm>{bl}{e}{l}{s}{e}{bl} {
   BEGIN comm ;
   return ELSE ; }

<comm>{bl}{e}{x}{i}{t}{bl} {
   BEGIN other ;
   return EXIT ; }

<comm>{bl}{i}{f}{bl} {
   BEGIN ifcont ;
   in_then = 1 ;
   return IF ; }

<comm>{bl}{i}{n}{t}{e}{r}{p}{r}{e}{t}{bl} {
   BEGIN other ;
   return INTERPRET ; }

<comm>{bl}{i}{t}{e}{r}{a}{t}{e}{bl} {
   BEGIN other ;
   return ITERATE ; }

<comm>{bl}{l}{e}{a}{v}{e}{bl} {
   BEGIN other ;
   return LEAVE ; }

<comm>{bl}{n}{o}{p}{bl} {
   BEGIN nothing ;
   return NOP ; }

<comm>{bl}{n}{u}{m}{e}{r}{i}{c}{bl} {
   BEGIN numeric ;
   return NUMERIC ; }

<comm>{bl}{p}{a}{r}{s}{e}{bl} {
   BEGIN parse ;
   in_parse = 1 ;
   return PARSE ; }

<comm>{bl}{p}{r}{o}{c}{e}{d}{u}{r}{e}{bl} {
   BEGIN procd ;
   return PROCEDURE ; }

<comm>{bl}{p}{u}{l}{l}{bl} {
   BEGIN other ;
   in_parse = 1 ;
   return PULL ; }

<comm>{bl}{p}{u}{s}{h}{bl} {
   BEGIN other ;
   return PUSH ; }

<comm>{bl}{q}{u}{e}{u}{e}{bl} {
   BEGIN other ;
   return QUEUE ; }

<comm>{bl}{r}{e}{t}{u}{r}{n}{bl} {
   BEGIN other ;
   return RETURN ; }

<comm>{bl}{s}{a}{y}{bl} {
   BEGIN other ;
   return SAY ; }

<comm>{bl}{s}{e}{l}{e}{c}{t}{bl} {
   BEGIN nothing ;
   return SELECT ; }

<comm>{bl}{s}{i}{g}{n}{a}{l}{bl} {
   BEGIN other ;
   return SIGNAL ; }

<comm>{bl}{t}{r}{a}{c}{e}{bl} {
   BEGIN trace ;
   in_trace = 1 ;
   return TRACE ; }

<comm>{bl}{u}{p}{p}{e}{r}{bl} {
   BEGIN other ;
   return UPPER ; }

<comm>{bl}{w}{h}{e}{n}{bl} {
   BEGIN ifcont ;
   in_then = 1 ;
   return WHEN ; }

<comm>{bl}{o}{t}{h}{e}{r}{w}{i}{s}{e}{bl} {
   BEGIN comm ;
   return OTHERWISE ; }

<comm>{bl}{e}{n}{d}{bl} {
   BEGIN other ;
   return END ; }

<comm>{bl}{ssym}{bl}={bl} {
   BEGIN other ;
   
   j = 0 ;
   for (i=0;yytext[i];i++)
      if ('a' <= yytext[i] && yytext[i] <= 'z')
         retvalue[j++] = yytext[i] & 0xDF ;
      else if (yytext[i]!='=' && yytext[i]!='\t' && yytext[i]!='\n' && yytext[i]!=' ' && yytext[i]!='~')
         retvalue[j++] = yytext[i] ;
   retvalue[j] = 0x00 ;

   return ASSIGNMENTVARIABLE ; }


<trace,signal,value1>{bl}{v}{a}{l}{u}{e}{bl} {
   BEGIN other ;
   if (!in_trace)
      obs_with = 1 ;
   return VALUE ; }

<signal>{bl}{o}{n}{bl} {
   BEGIN sigtype ;
   return ON ; }

<signal>{bl}{o}{f}{f}{bl} {
   BEGIN sigtype ;
   return OFF ; }

<sigtype>{bl}{e}{r}{r}{o}{r}{bl} {
   BEGIN nothing ;
   return ERROR ; }

<signal>{bl}{h}{a}{l}{t}{bl} {
   BEGIN nothing ;
   return HALT ; }

<signal>{bl}{n}{o}{v}{a}{l}{u}{e}{bl} {
   BEGIN nothing ;
   return NOVALUE ; }

<signal>{bl}{s}{y}{n}{t}{a}{x}{bl} {
   BEGIN nothing ;
   return SYNTAX ; }

<trace>{bl}[!\?]*[a-zA-Z]+{bl} {
   strcpy(retvalue,rmspc( yytext )) ;
   return WHATEVER ; }

<trace>{bl}!{bl} {
   return BANG ; }

<trace>{bl}\?{bl} {
   return WHAT ; }

<trace>{bl}{a}({l}({l})?)?{bl} {
   return ALL ; }

<trace>{bl}{c}({o}({m}({m}({a}({n}({d}({s})?)?)?)?)?)?)?{bl} {
   return COMMANDS ; }

<trace>{bl}{e}({r}({r}({o}({r}({s})?)?)?)?)?{bl} {
   return ERRORS ; }

<trace>{bl}{i}({n}({t}({e}({r}({m}({e}({d}({i}({a}({t}({e}({s})?)?)?)?)?)?)?)?)?)?)?)?{bl} {
   return INTERMEDIATES ; }

<trace>{bl}{l}({a}({b}({e}({l}({s})?)?)?)?)?{bl} {
   return LABELS ; }

<trace>{bl}{n}({o}({r}({m}({a}({l})?)?)?)?|{e}({g}({a}({t}({i}({v}({e})?)?)?)?)?)?)?{bl} {
   return NORMAL ; }

<trace>{bl}{o}({f}({f})?)?{bl} {
   return OFF ; }

<trace>{bl}{r}({e}({s}({u}({l}({t}({s})?)?)?)?)?)?{bl} {
   return RESULTS ; }

<trace>{bl}{s}({c}({a}({n})?)?)?{bl} {
   return SCAN ; }


<procd>{bl}{e}{x}{p}{o}{s}{e}{bl} {
   BEGIN other ;
   in_parse = 1 ;
   return EXPOSE ; }

<parse>{bl}{u}{p}{p}{e}{r}{bl} {
   return UPPER ; }

<parse>{bl}{a}{r}{g}{bl} {
   BEGIN other ;
   return ARG ; }

<parse>{bl}{n}{u}{m}{e}{r}{i}{c}{bl} {
   BEGIN other ;
   return NUMERIC ; }

<parse>{bl}{p}{u}{l}{l}{bl} {
   BEGIN other ;
   return PULL ; }

<parse>{bl}{s}{o}{u}{r}{c}{e}{bl} {
   BEGIN other ;
   return SOURCE ; }

<parse>{bl}{e}{x}{t}{e}{r}{n}{a}{l}{bl} {
   BEGIN other ;
   return EXTERNAL ; }

<parse>{bl}{l}{i}{n}{e}{i}{n}{bl} {
   BEGIN other ;
   return LINEIN ; }

<parse>{bl}{v}{e}{r}{s}{i}{o}{n}{bl} {
   BEGIN other ;
    return VERSION ; }

<parse>{bl}{v}{a}{r}{bl} {
   BEGIN other ;
   return VAR ; }

<parse>{bl}{v}{a}{l}{u}{e}{bl} {
   seek_with = 1 ;
   in_trace = 0 ;
   BEGIN with ;
   return VALUE ; }

<comm,other,ifcont>{bl}{t}{h}{e}{n}{bl} {
   if (in_then!=1) REJECT
   BEGIN comm ;
   in_then = 0 ;
   return THEN ; }

{bl}{w}{i}{t}{h}{bl} {
   BEGIN other ;
   if ((!in_parse)||(in_do)||(!seek_with)) 
      REJECT ;
   seek_with = 0 ;
   return WITH ; }


<numeric>{bl}{d}{i}{g}{i}{t}{s}{bl} {
   BEGIN other ;
   return DIGITS ; }

<numeric>{bl}{f}{o}{r}{m}{bl} {
   return FORM ; }

<numeric>{bl}{s}{c}{i}{e}{n}{t}{i}{f}{i}{c}{bl} {
   return SCIENTIFIC ; }

<numeric>{bl}{e}{n}{g}{i}{n}{e}{e}{r}{i}{n}{g}{bl} {
   return ENGINEERING ; }

<numeric>{bl}{f}{u}{z}{z}{bl} {
   BEGIN other ;
   return FUZZ ; }

<do1>{bl}{f}{o}{r}{e}{v}{e}{r}{bl} {
   BEGIN other ;
   return FOREVER ; }

<do1>{bl}{ssym}{bl}/= {
   BEGIN other ;
   strcpy(retvalue,rmspc( yytext )) ;
   return DOVARIABLE ; }   

{bl}{t}{o}{bl} {
   if (in_do) {
      BEGIN other ;
      return TO ; }
   REJECT ; }

{bl}{b}{y}{bl} {
   if (in_do) {
      BEGIN other ; 
      return BY ; }
   REJECT ; }

{bl}{f}{o}{r}{bl} {
   if (in_do) {
      BEGIN other ;
      return FOR ; }
   REJECT ; }

{bl}{w}{h}{i}{l}{e}{bl} {
   if (in_do) {
      BEGIN other ;
      return WHILE ; }
   REJECT ; }

{bl}{u}{n}{t}{i}{l}{bl} {
   if (in_do) {
      BEGIN other ;
      return UNTIL ; }
   REJECT ; }


<comm>{bl}{sym}{bl}:{bl} { 
   BEGIN comm ;
   
   for (i=j=0;ch=yytext[i];i++) {
      if ('a' <= ch && ch <= 'z')
         retvalue[j++] = ch & 0xDF ;
      else if ((ch!=' ')&&(ch!=',')&&(ch!='\t')&&(ch!='\n')&&(ch!=':')&&(ch!='~'))
         retvalue[j++] = ch ; }
   retvalue[j] = 0x00 ;
  /* nnextline = nextline ;
   nnextstart = thischar ;   
   nextstart = tstart ; 
   support = nextline - tline ;
   nextline = tline ; */
   return LABEL ; }


('([^']|'')+'|\"([^"]|\"\")+\")\({bl} {
   BEGIN other ;
   char1 = yytext[0] ;
   for (i=1; yytext[i+1]!='('; i++)
      if (yytext[i]==char1 && yytext[i+1]==char1)
         for (j=i+1; yytext[j]; j++)
            yytext[j] = yytext[j+1] ;
   yytext[i] = 0x00 ;
   strcpy(retvalue,&yytext[1]) ;

   if (prev==1) {
      next = dontlast = 1 ;
      code = INFUNCNAME ;
      return CONCATENATE ; }

   last = 0 ;
   return EXFUNCNAME ; }

{sym}\({bl} {   /* buggy */ 
   BEGIN other ; 
   for (i=0;yytext[i]!='(';i++) 
      if ('a' <= yytext[i] && yytext[i] <= 'z')
         retvalue[i] = yytext[i] & 0xDF ;
      else
         retvalue[i] = yytext[i] ;
   retvalue[i] = 0x00 ;

   if (prev==1) {
      next = dontlast = 1 ;
      code = INFUNCNAME ;
      return CONCATENATE ; }

   last = 0 ;
   return INFUNCNAME ; }


('{hex}'|\"{hex}\")[xX]/[^a-zA-Z0-9.@#$!?_] {
   BEGIN other ;
   for (i=j=1;yytext[i];i++)
      if (!isspace(yytext[i]))
         yytext[j++] = yytext[i] ; 

   flag=((j/2)*2==j) ;
   for (sum=i=k=0;(((ch=yytext[++i])!='\'')&&(ch!='"'));) {
      if ((ch>='0')&&(ch<='9')) {
         sum = sum*16 + (ch-'0') ; }
      else if ((ch>='a')&&(ch<='f')) {
         sum = sum*16 + (ch-'a'+10) ; }
      else if ((ch>='A')&&(ch<='F')) {
         sum = sum*16 + (ch-'A'+10) ; }
      
      if (flag) {
         retvalue[k++] = sum ;
         sum = 0 ; }
      flag = !flag ; }

   retvalue[k] = 0x00 ;

   if ((prev==1)&&(!in_parse)) {
      next = 1 ;
      code = STRING ;
      return CONCATENATE ; }

   last = 1 ;
   return HEXSTRING ; }

('([^']|'')*'|\"([^"]|\"\")*\") { 
   BEGIN other ;
   char1 = yytext[0] ;
   for (i=1; yytext[i+1]; i++)
      if (yytext[i]==char1 && yytext[i+1]==char1)
         for (j=i+1; yytext[j]; j++)
            yytext[j] = yytext[j+1] ;

   yytext[strlen(yytext)-1] = 0x00 ;
   strcpy(retvalue,&yytext[1]) ;

   if ((prev==1)&&(!in_parse)) {
      next = 1 ;
      code = STRING ;
      return CONCATENATE ; }

   last = 1 ;
   return STRING ; }

{csym} {
   if ((in_parse)&&(!in_do)&&(!seek_with))
      REJECT ;
   BEGIN other ;
   for (i=0;yytext[i];i++)
      if ('a' <= yytext[i] && yytext[i] <= 'z')
         retvalue[i] = yytext[i] & 0xDF ;
      else
         retvalue[i] = yytext[i] ;
   retvalue[i] = 0x00 ;

   if ((prev==1)&&(!in_parse)) {
      next = 1 ;
      code = CONSYMBOL ;
      return CONCATENATE ; }

   last = 1 ;
   return CONSYMBOL ; }

[0-9]+ {
   strcpy(retvalue,yytext) ;
   return OFFSET ; }

{ssym} {
   if (in_trace) REJECT ;
   BEGIN other ;
   for (i=0;yytext[i];i++)
      if ('a' <= yytext[i] && yytext[i] <= 'z')
         retvalue[i] = yytext[i] & 0xDF ;
      else
         retvalue[i] = yytext[i] ;
   retvalue[i] = 0x00 ;

   if ((prev==1)&&(!in_parse)) {
      next = 1 ;
      code = SIMSYMBOL ;
      return CONCATENATE ; }

   last = 1 ;
   return SIMSYMBOL ; }

{bl}\) {
   last = 1 ;
   return ')' ; }

\({bl} {
   if (prev==1) {
      next = 1 ;
      code = '(' ;
      return CONCATENATE ; }

   return '(' ; }

{bl}\,{bl} {
   return ',' ; }

{bl}\-{bl} {
   BEGIN other ;
   return '-' ; }

{bl}\+{bl} {
   BEGIN other ;
   return '+' ; }

{bl}\/{bl} {
   return '/' ; }

{bl}%{bl} {
   return '%' ; }

{bl}\*{bl} {
   return '*' ; }

{bl}\|{bl} {
   return '|' ; }

{bl}&{bl} {
   return '&' ; }

{bl}={bl} {
   return '=' ; }

{not}{bl} {
   BEGIN other ;
   return NOT ; }

{bl}(\>|{not}{bl}(\<{bl}=|={bl}\<)){bl} {
   return GT ; }

{bl}({not}{bl}\<|={bl}\>|\>{bl}=){bl} {
   return GTE ; }

{bl}(\<|{not}{bl}(\>{bl}=|={bl}\>)){bl} {
   return LT ; }

{bl}({not}{bl}\>|={bl}\<|\<{bl}=){bl} {
   return LTE ; }

{bl}({not}{bl}=|\<{bl}\>|\>{bl}\<){bl} {
   return DIFFERENT ; }

{bl}={bl}={bl} {
   return EQUALEQUAL ; }

{bl}{not}{bl}={bl}={bl} {
   return NOTEQUALEQUAL ; }

{bl}\/{bl}\/{bl} { 
   return MODULUS ; } 

{bl}&{bl}&{bl} { 
   return XOR ; }	

{bl}\|{bl}\|{bl} { 
   return CONCATENATE ; }

{bl}\*{bl}\*{bl} { 
   return EXP ; } 

{bl}\.{bl} {
   return PLACEHOLDER ; }

{bl}[ \t]{bl} { 
   return (((in_parse)&&(!seek_with)) ? yylex() : SPACE) ; }


[^A-Za-z0-9 \t\n@#$&|.?!_*()+^'";:<,>/-] {
                             exiterror( 13 ) ; }

.               { printf("DEBUG UNRECOGNIZED CHAR //%s//\n",yytext) ; }


%%

#define NORMALSTAT  0
#define COMMENTSTAT 1
#define SINGLEQUOTE 2
#define DOUBLEQUOTE 3

void myungetc( int ch, FILE *str ) ;
int xxstate=NORMALSTAT, linenr=1 ;
nodeptr currentnode ;

char *rmspc( char *instr ) 
{
   char ch ;
   int i, j=0 ;

   for (i=0;instr[i];i++) {
      ch = instr[i] ;
      if ('a' <= ch && ch <= 'z')
         instr[j++] = ch & 0xDF ;
      else if ((ch!=' ') && (ch!=',') && (ch!='\t') && (ch!='\n'))
         instr[j++] = ch ; }
   instr[j] = 0x00 ;
 
   return( instr ) ;
}


int bufptr=0 ;
char chbuffer[LOOKAHEAD] ;
lineboxptr firstline=NULL, lastline=NULL ;
int ipretflag=0, cch=0 ;
char *interptr=NULL ;

void initinterpret( char *str )
{
   extern char *interptr ; 
#ifdef FLEX_SCANNER
   extern int yy_init ;
#endif
   extern int ipretflag, cch ;

   cch = 0 ;
   ipretflag = 1 ;
#ifdef FLEX_SCANNER
   yy_init = 1 ;
#endif
   BEGIN comm ;
   interptr = str ;
}


void initvalue( char *str )
{
   extern int isvalue, yy_start ;
#ifdef FLEX_SCANNER
   extern int yy_init ;
#endif
   
   initinterpret( str ) ;
   BEGIN other ;
#ifdef FLEX_SCANNER
   yy_init = 1 ;
#endif
}


int mygetc( FILE *str )
{
   extern int xxstate, nextline ;
   extern lineboxptr firstline, lastline ;
   lineboxptr newline ;
   extern int linenr, bufptr ;
   extern char chbuffer[] ;
   extern int cch ;
   extern int thischar ;
   static char thisline[BUFFERSIZE] ;
   int nextchar ;
   extern int ipretflag ;
   extern char *interptr ;

   if (bufptr>0) 
      return chbuffer[--bufptr] ;
   else if (ipretflag) {
      if ((!(thisline[cch++]=nextchar=*interptr++)) && xxstate!=NORMALSTAT)
         exiterror( 6 ) ; 
      else
         if (nextchar==0x00) {
            myungetc(EOF,yyin) ;
            return 0x0a ; } ; }
   else
      if (((thisline[cch++]=nextchar=getc(str))==EOF) && xxstate!=NORMALSTAT)
         exiterror( 6 ) ; 

   thisline[cch] = nextchar = (nextchar) ? nextchar : EOF ;
   thischar++ ;
   if (nextchar=='\n')
      nextline++ ;

   if (cch>=BUFFERSIZE) 
      exiterror(12) ;

   if (nextchar=='\n') {
      thischar = 0 ;
      thisline[--cch] = 0x00 ;
      newline = (lineboxptr)Malloc(sizeof(linebox)) ;
      newline->line = Malloc(cch+1) ;
      memcpy(newline->line,thisline,cch+1) ;
      newline->prev = lastline ;
      newline->next = NULL ;
      newline->lineno = linenr++ ; 
      cch = 0 ;
      if (firstline==NULL) 
         firstline = newline ;
      else
         lastline->next = newline; 
      lastline = newline ; }

   return ( nextchar ) ;
}


static int first=0, singlequote=0, doblequote=0, wascomment=0, lastone=0 ; 

void myungetc( int ch, FILE *str )
{
   extern int linenr, bufptr ;
   extern char chbuffer[] ;

   chbuffer[bufptr++] = (char) ch ;
}


int mygetchar()
{
   static char buff[BUFFERSIZE] ;
   int ptr=0, this ;
   static int prev, haveprev=0 ;
   extern FILE *yyin ;
   extern int first, singlequote, doblequote, wascomment, lastone ;

   if (haveprev==1) {
      haveprev = 0 ;
      this=prev ; }
   else
      this = mmygetchar() ;

   if ((this==',')&&(!singlequote)&&(!doblequote)) {
      this = mmygetchar() ;
      while ((this==' ')||(this=='\t')||(this=='~')) {
         this = mmygetchar() ; }

      if (this=='\n') 
         return (int)' ' ;

      prev = this ;
      haveprev = 1 ;
      return (int)',' ; }

   return this ;
}


int mmygetchar()
{
   int this, next, oldstate, comment, lev ;
   extern FILE *yyin ;
   extern int xxstate ;
   extern int first, singlequote, doblequote, wascomment, lastone ; 

   this = mygetc( yyin ) ;

   if (first==0) {
      first = 1 ;
      if (this=='#') {
         for (;mygetc(yyin)!='\n';) ;
         if ((this=mygetc(yyin))==EOF)
            exiterror( 6 ) ; } ; }

   if ((this=='\'')&&(doblequote==0))
      singlequote = (singlequote==0) ;

   if ((this=='"')&&(singlequote==0))
      doblequote = (doblequote==0) ;

   if ((this=='~')&&(singlequote==0)&&(doblequote==0))
      exiterror(13) ;

   if ((this=='/')&&(singlequote==0)&&(doblequote==0)) {
      if ((next = mygetc(yyin))=='*') {
         for (lev=1;lev>0;) {
            if ((next=mygetc(yyin))=='*') {
               if ((next=mygetc(yyin))=='/')
                  lev-- ;
               else
                  myungetc(next,yyin) ; }
#ifdef NESTEDCOMMENTS
            else if (next=='/') {
               if ((next=mygetc(yyin))=='*')
                  lev++ ;
               else
                  myungetc(next,yyin) ; }
#endif
               }
         this = '~' ; }
      else
         myungetc(next,yyin) ; }

   return( lastone=this ) ;
}


void initscanner()
{
#ifdef FLEX_SCANNER
   yy_init = 1 ;
#endif
   BEGIN comm ;
}


void striptext( char *text )
{
   int i, j=0 ;

   for (i=0; text[i]; i++) {
      if ('a' <= text[i] && text[i] <= 'z')
         text[i] &= 0xDF ;
      if (('A'<=text[i] && text[i]<='Z'))
         text[j++] = text[i] ; }

   text[j] = 0x00 ;
}
