
#ifndef lint
static char *RCSid = "$Id: interpret.c,v 1.10 1992/04/05 20:38:55 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: interpret.c,v $
 * Revision 1.10  1992/04/05  20:38:55  anders
 * Added copyright notice
 * Fixed problems with address, drop, external functions, envionments
 * Removed several memorylossed i DO and IF
 *
 * Revision 1.9  1992/03/23  05:13:08  anders
 * Added support for storing NUMERIC FORM in currlevel
 *
 * Revision 1.8  1992/03/22  19:00:01  anders
 * Defined popen() explicitly for CRAY
 *
 * Revision 1.7  1992/03/22  01:33:34  anders
 * Added include for some files which were removed from rexx.h
 * Fixed bug in ITERATE/LEAVE
 * Fixed type-confusion between char/int
 * Implemented QUEUE
 * Fixed off-by-one error in call to malloc()
 *
 * Revision 1.6  1992/03/01  19:34:49  anders
 * Fixed problem with returnvalue of sprintf()
 * Fixed some problems with memoryleakage
 * Added new parameter to doparse()
 *
 * Revision 1.5  1991/06/03  02:41:57  anders
 * Added support for deleting extra entries in the call-stack when
 *    a routine returns while some do-groups (or similar) is still
 *    active. This is done by the markstack variable, and by
 *    changing the definition of pushcallstack() and pullcallstack()
 * Removed debugging printout that was not used
 * Added support for PROCEDURE and EXPOSE
 * Added som kludging to the code removing old levels, this code does
 *    not belong in this routine
 * Added configurable defaults for values in currlevel when a new
 *    level is created
 *
 * Revision 1.4  91/04/05  23:12:35  anders
 * Fix bug. Two uninitialized fields in function newlevel()
 * 
 * Revision 1.3  90/12/11  02:02:49  anders
 * Several minor changes, to make (interactive) traceing better. 
 *     Unfortunately, most of this code must be rewritten if it should
 *     function properly, it contains too much garbage an unreadable 
 *     kludges!
 * 
 * Revision 1.2  90/12/10  00:32:29  anders
 * Removed bug, RC was not set after calling an external command as
 *     a rexx function.
 * 
 * Revision 1.1  90/08/08  02:10:33  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <string.h>

#if defined(CRAY)
FILE *popen( char *command, char *access ) ;
#endif


#define ADD(var,val) setvalue(var,add(getvalue(var,0),val)) 
#define XOR(a,b) (( (a) && (!(b)) )||( (!(a)) && (b) ))

nodeptr getlabel( char *name ) ;

int numbtest( char *first, char *second )  /* buggy, use routine in maths.c */
{
   double tmp;

   tmp = atof(first) - atof(second) ;
   if (tmp<0.0) 
      return -1 ;
   else 
      if (tmp>0.0) 
         return 0 ;
      else
         return 1 ;
}



/* 
 * This routine is a huge beast, the best thing to say about it is that
 * it is nearly as bad as interpret()
 */
char *evaluate( nodeptr this ) 
{
   extern nodeptr currentnode ;
   int three, i, j, k, stackmark ;
   static char command[1024] ;
   char *ptr, *ptr1, *ptr2 ;
   static char strptr[SMALLSTR] ;
   char *strone, *strtwo, *strthree ;
   extern proclevel currlevel ;
   proclevel oldlevel ;
   paramboxptr args, targs ;
   nodeptr entry ;

   if (!this) 
      exiterror(ERR_INTERPRETER_FAILURE) ;

   if (this->value) {     /* delete, ->value should not be used */
      Free(this->value) ;
      this->value = NULL ; }

   switch ( this->type ) {

      case X_STRING:
      case X_CON_SYMBOL: 
         ptr = Malloc(i=(strlen(this->name)+1)) ;
         memcpy(ptr,this->name,i) ;
         tracevalue(ptr,'L') ;
         return ptr ; 

      case X_SIM_SYMBOL:
         return getvalue(this->name,1) ; 

      /* wasting one byte if type==X_CONCAT */
      case X_CONCAT:
      case X_SPACE:
         ptr1 = evaluate(this->p[0]) ;
         ptr2 = evaluate(this->p[1]) ;
         ptr = Malloc(strlen(ptr1)+strlen(ptr2)+2) ; 
         strcpy(ptr,ptr1) ;
         if (this->type==X_SPACE) 
            strcat(ptr," ") ;
         strcat(ptr,ptr2) ;
         tracevalue(ptr,'O') ;
         Free( ptr1 ) ;
         Free( ptr2 ) ;
         return ptr ;

      case X_IN_FUNC:
         entry = getlabel(this->name) ;
         if (entry) {
            sprintf(strptr,"%d",currentnode->lineno ) ;
	    setvalue("SIGL",strptr) ;
            oldlevel = currlevel ;
            currlevel = newlevel( currlevel ) ;
            currlevel->args = initplist( this ) ;
            stackmark = pushcallstack(currentnode) ;

            ptr = interpret( entry->mother->p[1] ) ; /* must be wrong*/

            popcallstack(stackmark) ;
            removelevel( currlevel ) ;
            currlevel = oldlevel ; 
            tracevalue(ptr,'F') ;
            return ptr ; }

         ptr = buildtinfunc( this ) ;
         tracevalue(ptr,'F') ;
         return ptr ;
/*       break ; */

      case X_EX_FUNC:
      {
         args = targs = initplist( this ) ;
         strcpy(command,this->name) ;
         for (;targs;targs=targs->next) 
            if (targs->value) {
               strcat(command," ") ; 
               strcat(command,targs->value) ; }
	 
         deallocplink( args ) ;
         
         ptr = run_popen( command, currlevel->environment ) ;
         strcpy( ptr2=Malloc( strlen(ptr)+1 ), ptr) ;
         tracevalue(ptr2,'F') ;
         return ptr2 ;         
      }

      case X_LOG_NOT:
         ptr = evaluate(this->p[0]) ;
         ptr[0] = (true(ptr)) ? '0' : '1' ;
         tracevalue(ptr,'P') ;
         return ptr ;
         
      case X_U_MINUS:
         ptr = negate(evaluate(this->p[0])) ;
         tracevalue(ptr,'P') ;
         return ptr ;

      case X_LOG_OR:
         ptr = logical_or(evaluate(this->p[0]),evaluate(this->p[1])) ;
         tracevalue(ptr,'O') ;
         return ptr ;

      case X_LOG_AND:
         ptr = logical_and(evaluate(this->p[0]),evaluate(this->p[1])) ;
         tracevalue(ptr,'O') ;
         return ptr ;

      case X_PLUSS:
      case X_MINUS:
      case X_MULT:
      case X_S_DIFF:
      case X_S_EQUAL:
      case X_DEVIDE:
      case X_MODULUS:
      case X_EQUAL:
      case X_GT:
      case X_LT:	 
      case X_GTE:
      case X_LTE:
      case X_DIFF:
      case X_INTDIV:
         strone = evaluate( this->p[0] ) ;
         strtwo = evaluate( this->p[1] ) ;

         switch ( this->type ) {
            case X_PLUSS:
               strthree = add(strone,strtwo) ;
               break ;
   
            case X_MINUS:
               strthree = subtract(strone,strtwo) ;
               break ;
            
            case X_MULT:
               strthree = multiply(strone,strtwo) ;
               break ;

            case X_DEVIDE:
              strthree = devide(strone,strtwo) ;
               break ;
 
            case X_MODULUS:
              strthree = reminder(strone,strtwo) ;
               break ;

            case X_EQUAL:
            case X_DIFF: {
               static double first, second ;
               int AnSwer ;
               char *s1, *s2 ;
               if ((myisnumber(strone,&first))&&(myisnumber(strtwo,&second)))
                  AnSwer = XOR((first==second),(this->type==X_DIFF)) ; 
               else {
                  for (s1=strone;(*s1==' ');s1++) ;
                  for (s2=strtwo;(*s2==' ');s2++) ;
                  for (;(*s1==*s2)&&(*s1);s1++,s2++) ;
               
                  for (;(*s1==' ');s1++) ;
                  for (;(*s2==' ');s2++) ;
                  AnSwer = XOR((!(*s1)&&!(*s2)),this->type==X_DIFF) ; }

               sprintf(strthree=Malloc(BOOL_STR_LENGTH),"%d",AnSwer) ;
               break ; }

            case X_GT:
            case X_LT:
            case X_LTE:
            case X_GTE: {
               int AnSwer=0 ;
               static double first, second ;
               k = this->type ;
               if ((myisnumber(strone,&first))&&(myisnumber(strtwo,&second))) {
                  if ((first>second)&&((k==X_GT)||(k==X_GTE)))
                     AnSwer = 1 ;
                  else if ((first==second)&&((k==X_GTE)||(k==X_LTE)))
                     AnSwer = 1 ;
                  else if ((first<second)&&((k==X_LT)||(k==X_LTE)))
                     AnSwer = 1 ; 

                  sprintf(strthree=Malloc(BOOL_STR_LENGTH),"%d",AnSwer) ;
                  break ; }
               
               strthree = Malloc(2) ;
               strthree[1] = '\000' ;

               for (j=0;(strtwo[j]==' ');j++) ;
               for (i=0;(strone[i]==' ');i++) ;
               for (;((strone[i]==strtwo[j])&&(strone[i]!='\000'));i++,j++) ;
               
               for (;(strone[i]==' ');i++) ;
               for (;(strtwo[j]==' ');j++) ;
               if ((strone[i]=='\000')&&(strtwo[j]=='\000')) {
                  strthree[0] = ((k==X_GTE)||(k==X_LTE)) ? '1' : '0' ;
                  break ; }

               if ((k==X_GTE)||(k==X_GT))
                  strthree[0] = (strone[i]>strtwo[j]) ? '1' : '0' ;
               else 
                  strthree[0] = (strone[i]<strtwo[j]) ? '1' : '0' ;
               break ; }

            case X_S_DIFF:
               three = (strcmp(strone,strtwo)!=0) ;
               strthree = Malloc(2) ;
               sprintf(strthree,"%d",three) ;
               break ;
		 
            case X_S_EQUAL:
               three = (strcmp(strone,strtwo)==0) ;
               strthree = Malloc(2) ;
               sprintf(strthree,"%d",three) ;
               break ;

            case X_INTDIV:
               strthree = intdevide(strone,strtwo) ;
               break ;
            }
       tracevalue(strthree,'O') ;
       Free( strone ) ;
       Free( strtwo ) ;
       return strthree ;
/*     break ; */
     }   
 return NULL ;
}
   


char *interpret(treenode *this) 
{
   int i, number, stackmark ;
   extern proclevel currlevel ;
   paramboxptr args ;
   extern nodeptr currentnode ;
   proclevel oldlevel ;
   char *increment, *stopval, *result ;
   treenode *newthis, *iptr, *entry, *ptr ; 
   char *rexxaddstr(), *chptr, *tptr ;
   static nodeptr tmpptr ;
   char *retval, *strptr, *source, *origfile, *inpfile ;
   int stackptr=0, no_next_interactive=0 ;
   stackbox stack[STACKSIZE] ;
   int whereto ;
   extern sysinfo systeminfo ;
   char *stringen ;

reinterpret:
   if (this==NULL)
      goto fakereturn ;

   currentnode = this ;
   traceline(this) ;

   if (this->now) 
      this->now = this->unow = this->sec = this->usec = 0 ;

   whereto = 0 ;   
   switch ( this->type ) {

      case X_OTHERWISE:
         this = this->p[0] ;
         goto reinterpret ;
    
      case X_PROGRAM:
      case X_WHENS:
      case X_STATS:          /* not a very good structure, has to be */
         newthis = this->p[0] ;      /* changed before optimalisation */
         whereto = 3 ;
         goto fakerecurse ;
        
three:   newthis = this->p[1] ;
         whereto = 0 ;
         goto fakerecurse ;

      case X_DO:
         if (!((this->p[0])||(this->p[1]))) {
            newthis = this->p[2] ;
            whereto = 0 ;
            goto fakerecurse ; }

         if ((this->p[0])&&(this->p[0]->name))  
         {
            tmpptr = this->p[0]->p[0] ;       
            setvalue(this->p[0]->name,tptr=evaluate(tmpptr)) ; 
            Free( tptr ) ;
         }

         increment = stopval = NULL ;
         number = -1 ;
	 for (i=1;i<4;i++)
            if ((this->p[0])&&(this->p[0]->p[i]))
               switch( this->p[0]->p[i]->type ) {
                  case X_DO_TO:
                     tmpptr = this->p[0]->p[i]->p[0] ;
                     stopval = Malloc(strlen(chptr=evaluate(tmpptr))+1) ;
                     strcpy(stopval,chptr) ; 
                     Free(chptr) ;
                     break ;
                 
                  case X_DO_BY:
                     tmpptr = this->p[0]->p[i]->p[0] ;
                     increment = Malloc(strlen(chptr=evaluate(tmpptr))+1) ;
                     strcpy(increment,chptr) ; 
                     Free( chptr ) ;
                     break ;

                  case X_DO_FOR:
                     tmpptr = this->p[0]->p[i]->p[0] ;
                     number = atozpos(chptr=evaluate(tmpptr)) ; 
                     Free( chptr ) ;
                     break ; }

         if (systeminfo->interactive)
            intertrace() ;
         goto startloop2 ;

startloop:          
         traceline(this) ;  
startloop2:
         if (this->p[0]) 
         {
            chptr = NULL ;
            if ((stopval)&&(numbtest(stopval,
                                     chptr=getvalue(this->p[0]->name,0))<0))
            {
               Free( chptr ) ;
               goto endloop ; 
            }
            else if (chptr)
               Free( chptr ) ;

            if ((number!=-1)&&(number--<=0))
               goto endloop ; }

         if ((this->p[1])&&((this->p[1]->type)==X_WHILE))
            if (!true(chptr=evaluate(this->p[1]->p[0]))) 
            {
               Free( chptr ) ;
               goto endloop ; 
            }
            else
               Free( chptr ) ;

         whereto = 1 ;
         newthis = this->p[2] ;
         pushcallstack(NULL) ;
         goto fakerecurse ;

one:     popcallstack(-1) ;
         traceline(this->p[3]) ;
         if ((this->p[1])&&((this->p[1]->type)==X_UNTIL)) {
            if (true(chptr=evaluate(this->p[1]->p[0])))
            {
               Free( chptr ) ;
               goto endloop ; 
            }
            else
               Free( chptr ) ;
         }

         if ((this->p[0])&&(this->p[0]->name)) 
         {
            setvalue(this->p[0]->name,chptr=add(tptr=
                 getvalue(this->p[0]->name,0),((increment)?increment :"1"))) ;
            Free( tptr ) ;
            Free( chptr ) ;
         }
 
         goto startloop ;

endloop: if (increment) Free(increment) ;
         if (stopval) Free(stopval) ;
         no_next_interactive = 1 ;
         break ;

       case X_IF:
         newthis = this->p[(true(tptr=evaluate(this->p[0])) ? 1 : 2)] ;
         Free( tptr ) ;
         if (systeminfo->interactive)
            intertrace() ;
         whereto = 6 ;
         pushcallstack(NULL) ;
         goto fakerecurse ;
six:     popcallstack(-1) ;
         no_next_interactive = 1 ;
         break ; 
         
      case X_ASSIGN:
         {
            char *cptr ;
            setvalue( this->name, cptr=evaluate(this->p[0]) ) ;
            Free( cptr ) ;
         }
         break ;
 
      case X_IPRET:
         dointerpret(evaluate(this->p[0])) ;
         break ;	
                  
      case X_SELECT:
         newthis = this->p[0] ;
         whereto = 5 ;
         goto fakerecurse ;

five:    newthis = this->p[1] ;
         whereto = 0 ;
         goto fakerecurse ;

      case X_WHEN:
         if (true(evaluate(this->p[0]))) {
            newthis = this->p[1] ;
            whereto = 4 ;
            goto fakerecurse ;

four:       for (;(stackptr>=0);stackptr--)
               if (stack[stackptr].this->type==X_SELECT)
                  goto fakereturn ; }
         break ;

      case X_SAY:
         if (!this->p[0])
            printf("\n") ;
         else {
            printf("%s\n",stringen=evaluate(this->p[0])) ;
            Free(stringen) ; }
         break ;

      case X_TRACE:
      {
         char *tptr ;

         if (this->name)
            set_trace( this->name ) ;
         else if (this->p[0])
	 {
            set_trace( tptr=evaluate(this->p[0]) ) ;
            Free( tptr ) ;
         }
         else
            exiterror( ERR_INTERPRETER_FAILURE ) ;

         break ; 
      }     

      case X_EXIT:
#ifdef REXXDEBUG
         printf("\n") ;
         dumpvars( NULL ) ;
#endif /* REXXDEBUG */
         if (this->p[0]==NULL) 
            exit(0) ;
         else {
            exit(myatol(evaluate(this->p[0]))) ; }
         break ;

      case X_COMMAND:
         if (this->p[0]) {
            int RC ;
            if (RC=perform(evaluate(this->p[0]),cpy(currlevel->environment)))
               traceerror( this, RC ) ;
            sprintf(tptr=Malloc(SMALLSTR),"%d",RC) ;            
            setvalue("RC",tptr) ;
            break ; }


      case X_ADDR_N:   /* ADDRESS environment [expr] */
      {
         char *envir, *tptr ;
         int rc ;

         envir = this->name ;
         if (this->p[0])
         {
            if (rc=perform(evaluate(this->p[0]), envir))
               traceerror( this, rc ) ;
            sprintf( tptr=Malloc(SMALLSTR), "%d", rc ) ;
            setvalue( "RC", tptr ) ;
         }
         else
         {
            Free( currlevel->prev_env ) ;
            currlevel->prev_env = currlevel->environment ;
            strcpy( tptr=Malloc(strlen(envir)+1), envir ) ;
            currlevel->environment = tptr ;
         }
         break ;
      }

	 
      case X_ADDR_V:   /* ADDRESS [VALUE] expr */
      {
         char *cptr ;

         cptr = evaluate(this->p[0]) ;
         Free( currlevel->prev_env ) ;
         currlevel->prev_env = currlevel->environment ;
         currlevel->environment = cptr ;
         break ;
      }


      case X_ADDR_S:   /* ADDRESS */
      {
         char *tptr ;

         tptr = currlevel->environment ;
         currlevel->environment = currlevel->prev_env ;
         currlevel->prev_env = tptr ;
         break ;
      }         


      case X_DROP:
      {
         nodeptr nptr ;
 
         for (nptr=this->p[0]; nptr; nptr=nptr->p[0] ) 
            if (nptr->name)
               drop_var( nptr->name ) ;

         break ;
      }


      case X_SIG_LAB:
         for (;stackptr;stackptr--) {
            if (stack[stackptr].increment) stack[stackptr].increment = 0 ;
            if (stack[stackptr].stopval) stack[stackptr].stopval = 0 ; }

         strptr = Malloc(SMALLSTR) ;
         sprintf( strptr, "%d", this->lineno ) ;
	 setvalue( "SIGL", strptr ) ;

         if ((entry=getlabel(this->name))==NULL) exiterror(16) ;
         this = entry->mother->p[1] ; /* Be careful!!! */
         goto reinterpret ;
         break ;

      case X_PROC: 
         if (currlevel->varflag) 
            exiterror(ERR_UNEXPECTED_PROC) ;

         for (ptr=this->p[0];(ptr);ptr=ptr->p[0])
	    if (ptr->name) 
               expose_var(ptr->name) ;
            else
               exiterror(ERR_INTERPRETER_FAILURE) ;

         expose_var(NULL) ;
         break ; 

      case X_CALL:
         entry = getlabel(this->name) ;
         if (entry!=NULL) {
            strptr = Malloc(SMALLSTR) ;
            sprintf( strptr, "%d", this->lineno ) ;
	    setvalue( "SIGL", strptr ) ;
            Free( strptr ) ;

            oldlevel = currlevel ;
            currlevel = newlevel( currlevel ) ;
            currlevel->args = initplist( this ) ;
            stackmark = pushcallstack( this ) ;
            traceline(entry) ;

            result = interpret( entry->mother->p[1] ) ;

            popcallstack( stackmark ) ;
            removelevel( currlevel ) ;
            currlevel = oldlevel ; }
         else 
            result = buildtinfunc( this ) ; 

         if (result!=NULL)
         {
            setvalue( "RESULT", result ) ;
            Free( result ) ;
         }
         
         break ;

      case X_PARSE_ARG:
      case X_PARSE_ARG_U:
        args = currlevel->args->next ;
        (void)parseargtree( this, args, this->type!=X_PARSE_ARG ) ;
        break ;

      case X_PARSE_U:
      case X_PARSE:
         switch (this->p[0]->type) {
             case X_PARSE_VAR:
                source = getvalue( this->p[0]->name, 1 ) ;
                break ; 

             case X_PARSE_VAL:
                source = evaluate(this->p[0]->p[0]);
                break ;

	     case X_PARSE_PULL:
	        source = popline() ;
                break ;

             case X_PARSE_VER:
                source = Malloc(strlen(PARSE_VERSION_STRING+1)) ;
                strcpy(source,PARSE_VERSION_STRING) ;
                break ;

             case X_PARSE_EXT:
                source = readkbdline() ;
                break ; 

             case X_PARSE_SRC:
                origfile = systeminfo->called_as ;
                inpfile = systeminfo->input_file ;
                source=Malloc(15+strlen(origfile)+strlen(inpfile)) ;
                strcpy(source,"UNIX COMMAND ") ;
                strcat(source,inpfile) ;
                strcat(source," ") ;
                strcat(source,origfile) ;
                break ;      
             } 

        if (this->type==X_PARSE_U) 
           (void)upcase(source) ;

        doparse( source, this->p[1], 0, 0 ) ;
        Free( source ) ;
        break ;

      case X_PULL:
        doparse(upcase(popline()),this->p[0],0,0) ;
        break ;

      case X_PUSH:
        stack_lifo( (this->p[0]) ? evaluate(this->p[0]) : nullstringptr() ) ; 
        break ;

      case X_QUEUE:
	stack_fifo( (this->p[0]) ? evaluate(this->p[0]) : nullstringptr() ) ;
        break ; 

      case X_RETURN:
         /* buggy, need to deallocate procbox and vars ... */
        if (this->p[0])
           retval = evaluate(this->p[0]) ;
        else 
           retval = NULL ;
  
        return( retval ) ;
        break ;

      case X_LEAVE:
      case X_ITERATE:
         i = stackptr ;

         /* surely, there must be a more structured way !!! */
         /* ... probably, but not early in the morning ... |-) */
         foobar1:
            if (i<=0) exiterror( 28 ) ;
            iptr = stack[i-1].this ;
            if (iptr->type==X_IF) goto foobar666 ;
            if (iptr->type!=X_DO) goto foobar3 ; 
            if ((iptr->p[1]==NULL)&&(iptr->p[0]==NULL)) goto foobar3 ;
/*            if (this->p[0]==NULL) goto foobar2 ; */
            if (this->name==NULL) goto foobar2 ;
            if ((iptr->p[0]==NULL)||(iptr->p[0]->name==NULL)) goto foobar666 ;
/*          if (strcmp(this->p[0]->name,iptr->p[0]->name)==0) goto foobar2;*/
            if (strcmp(this->name,iptr->p[0]->name)==0) goto foobar2 ;

            foobar666:
            popcallstack(-1) ;

            foobar3:
            i -= 1 ;
            goto foobar1 ;

         foobar2:
         if (this->type==X_LEAVE) {
            i -= 1 ;
            popcallstack(-1) ; }
         if (i<=0) exiterror( 28 ) ;
         if (systeminfo->interactive)
            intertrace() ;
         traceline(iptr) ;
         stackptr = i ;
         goto fakereturn ;
         break ;

      default:
        break ;
   }

   if ((systeminfo->interactive)&&(!no_next_interactive))
      intertrace() ;
   no_next_interactive = 0 ;

fakereturn:
   if (stackptr<0)
      exiterror(49) ;

   if (stackptr==0) {
      return NULL ; }
   
   stackptr-- ;

   whereto = stack[stackptr].whereto ;
   number = stack[stackptr].number ;
   this = stack[stackptr].this ;
   stopval = stack[stackptr].stopval ;
   increment = stack[stackptr].increment ;

   switch ( whereto ) {
      case 0: goto fakereturn ;
      case 1: goto one ; 
      case 3: goto three ;
      case 4: goto four ;
      case 5: goto five ;
      case 6: goto six ;
      default:
         exiterror( 49 ) ; }

 fakerecurse:
   if (stackptr>=STACKSIZE)
      exiterror(11) ;

   stack[stackptr].increment = increment ;
   stack[stackptr].stopval = stopval ;
   stack[stackptr].this = this ;
   stack[stackptr].number = number ;
   stack[stackptr++].whereto = whereto ;

   this = newthis ;
   goto reinterpret ;

}


nodeptr getlabel( char *name ) 
{
   extern proclevel mainlevel ;
   labelboxptr lptr ;

   for (lptr=mainlevel->first;
      (lptr!=NULL)&&(strcmp(lptr->entry->name,name)!=0);
      lptr=lptr->next) ;

   return (lptr==NULL) ? NULL : lptr->entry ;
}


void removelevel( proclevel level ) 
{
   int i ;
   variableptr ptr, next ;

   if (level->varflag==1) { /* does not belong *here* !!! */
      for (i=0;i<256;i++)
         for (ptr=(level->vars)[i];ptr!=NULL;ptr=next) {
            next = ptr->next ;
            Free(ptr->name) ;
            if (ptr->value)
               Free(ptr->value) ;
            Free((char *)ptr) ; }

      Free((char *)level->vars) ; }
 
   if (level->args)
      deallocplink( level->args ) ;

   if (level->prev) 
      level->prev->next = NULL ;
   Free((char *)level) ; 
}


proclevel newlevel( proclevel oldlevel )
{
   extern char *environments[] ;
   extern char *numeric_forms[] ;
   extern sysinfo systeminfo ;
   proclevel level ;

   level = (proclevel)Malloc(sizeof(proclevbox)) ;

   if (!oldlevel) {
      level->first = NULL ;
      level->last = NULL ;
      level->numfuzz = DEFAULT_NUMERIC_FUZZ ;
      level->numsize = DEFAULT_NUMERIC_SIZE ;
      level->numform = numeric_forms[DEFAULT_NUMFORM] ;
      level->sec = 0 ;
      level->usec = 0 ;
      level->currnumsize = 9 ;
      level->mathtype = DEFAULT_MATH_TYPE ;
      level->prev = NULL ;
      level->next = NULL ;
      level->varflag = 1 ; 
      level->tracestat = systeminfo->tracing ;

      level->environment = Malloc(strlen(environments[DEFAULT_ENVIRONMENT])) ;
      strcpy(level->environment, environments[DEFAULT_ENVIRONMENT]) ;

      level->prev_env = Malloc(strlen(environments[DEFAULT_ENVIRONMENT])) ;
      strcpy(level->prev_env, environments[DEFAULT_ENVIRONMENT]) ;

      level->vars = inithashtbl() ; }
   else {
      memcpy(level,oldlevel,sizeof(proclevbox)) ;
      level->prev = oldlevel ;
      level->varflag = 0 ;
      oldlevel->next = level ; }
   
   return( level ) ;
}
