#ifndef lint
static char *RCSid = "$Id: funcs.c,v 1.8 1992/04/05 20:19:19 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: funcs.c,v $
 * Revision 1.8  1992/04/05  20:19:19  anders
 * Added copyright notice
 * Added support for DATATYPE, DELWORD and TRACE
 * Moved getoption() to this file.
 *
 * Revision 1.7  1992/03/23  05:09:42  anders
 * Added several new builtin functions
 *
 * Revision 1.6  1992/03/22  01:35:44  anders
 * Added include for files removed from rexx.h
 * Added support for lots of functions
 *
 * Revision 1.5  1992/03/01  19:21:26  anders
 * Added support for traceing memory-lossed better.
 * Added routine to mark memory used temporarily by the routine
 *    that find lost memory.
 * Removed some memory-loss
 *
 * Revision 1.4  1991/04/05  23:21:09  anders
 * Added support for dbg_memorystats() and std_strip()
 * Put #ifdef's around code spesific for TRACEMEM
 *
 * Revision 1.3  90/08/26  01:52:00  anders
 * Added support for new function, eof()
 * 
 * Revision 1.2  90/08/19  02:27:47  anders
 * Added support for makebuf, dropbuf, desbuf and buftype
 * 
 * Revision 1.1  90/08/08  02:09:54  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <string.h>
#include <ctype.h>

char *std_abbrev( paramboxptr parms ) ;
char *std_abs( paramboxptr parms ) ;
char *std_address( paramboxptr parms ) ;
char *std_arg( paramboxptr parms ) ;
char *std_bitand( paramboxptr parms ) ;
char *std_bitor( paramboxptr parms ) ;
char *std_bitxor( paramboxptr parms ) ;
char *std_c2d( paramboxptr parms ) ;
char *std_c2x( paramboxptr parms ) ;
char *std_center( paramboxptr parms ) ;
char *std_charin( paramboxptr parms ) ;
char *std_charout( paramboxptr parms ) ;
char *std_chars( paramboxptr parms ) ;
char *std_compare( paramboxptr parms ) ;
char *std_copies( paramboxptr parms ) ;
char *std_d2c( paramboxptr parms ) ;
char *std_d2x( paramboxptr parms ) ;
char *std_datatype( paramboxptr parms ) ;
char *std_date( paramboxptr parms ) ;
char *std_delstr( paramboxptr parms ) ;
char *std_delword( paramboxptr parms ) ;
char *std_digits( paramboxptr parms ) ;
char *std_errortext( paramboxptr parms ) ;
char *std_form( paramboxptr parms ) ;
char *std_format( paramboxptr parms ) ;
char *std_fuzz( paramboxptr parms ) ;
char *std_insert( paramboxptr parms ) ;
char *std_lastpos( paramboxptr parms ) ;
char *std_length( paramboxptr parms ) ;
char *std_left( paramboxptr parms ) ;
char *std_linein( paramboxptr parms ) ;
char *std_lineout( paramboxptr parms ) ;
char *std_lines( paramboxptr parms ) ;
char *std_max( paramboxptr parms ) ;
char *std_min( paramboxptr parms ) ;
char *std_overlay( paramboxptr parms ) ;
char *std_pos( paramboxptr parms ) ;
char *std_queued( paramboxptr parms ) ;
char *std_right( paramboxptr parms ) ;
char *std_reverse( paramboxptr parms ) ;
char *std_random( paramboxptr parms ) ;
char *std_sign( paramboxptr parms ) ;
char *std_sourceline( paramboxptr parms ) ;
char *std_space( paramboxptr parms ) ;
char *std_strip( paramboxptr parms ) ;
char *std_substr( paramboxptr parms ) ;
char *std_subword( paramboxptr parms ) ;
char *std_symbol( paramboxptr parms ) ;
char *std_time( paramboxptr parms ) ;
char *std_trace( paramboxptr parms ) ;
char *std_translate( paramboxptr parms ) ;
char *std_trunc( paramboxptr parms ) ;
char *std_value( paramboxptr parms ) ;
char *std_verify( paramboxptr parms ) ;
char *std_word( paramboxptr parms ) ;
char *std_wordindex( paramboxptr parms ) ;
char *std_wordlength( paramboxptr parms ) ;
char *std_wordpos( paramboxptr parms ) ;
char *std_words( paramboxptr parms ) ;
char *std_x2c( paramboxptr parms ) ;
char *std_x2d( paramboxptr parms ) ;
char *std_xrange( paramboxptr parms ) ;

#ifdef TRACEMEM
char *dbg_allocated( paramboxptr parms ) ;
#endif
char *dbg_dumpvars( paramboxptr parms ) ;
char *dbg_dumptree( paramboxptr parms ) ;
char *dbg_traceback( paramboxptr parms ) ;     
char *dbg_dumpfiles( paramboxptr parms ) ;
#ifdef TRACEMEM
char *dbg_listleaked( paramboxptr parms ) ;
char *dbg_memorystats( paramboxptr parms ) ;    
#endif /* TRACEMEM */

char *cms_sleep( paramboxptr parms ) ;
char *cms_state( paramboxptr parms ) ;
char *cms_makebuf( paramboxptr parms ) ;
char *cms_dropbuf( paramboxptr parms ) ;
char *cms_desbuf( paramboxptr parms ) ;
char *cms_buftype( paramboxptr parms ) ;

char *rex_userid( paramboxptr parms ) ;
  
char *unx_getenv( paramboxptr parms ) ;
char *unx_getpath( paramboxptr parms ) ;  /* not working ... */
char *unx_chdir( paramboxptr parms ) ;
char *unx_open( paramboxptr parms ) ;
char *unx_close( paramboxptr parms ) ;
char *unx_unixerror( paramboxptr parms ) ;
char *unx_eof( paramboxptr parms ) ;
char *unx_popen( paramboxptr parms ) ;

struct {
   char *(*function)() ;
   char *funcname ; } functions[] = {
      { std_abbrev, "ABBREV" },     
      { std_abs, "ABS" }, 
      { std_address, "ADDRESS" }, 
#ifdef TRACEMEM
      { dbg_allocated, "ALLOCATED" },
#endif
      { std_arg, "ARG" },    
      { std_bitand, "BITAND" },  
      { std_bitor, "BITOR" },  
      { std_bitxor, "BITXOR" }, 
      { cms_buftype, "BUFTYPE" },
      { std_c2d, "C2D" },     
      { std_c2x, "C2X" },
      { unx_chdir, "CD" },
      { std_center, "CENTER" },
      { std_center, "CENTRE" },  
      { std_charin, "CHARIN" }, 
      { std_charout, "CHAROUT" }, 
      { std_chars, "CHARS" }, 
      { unx_chdir, "CHDIR" },
      { unx_close, "CLOSE" },
      { std_compare, "COMPARE" },
      { std_copies, "COPIES" }, 
      { std_d2c, "D2C" },
      { std_d2x, "D2X" },
      { std_datatype, "DATATYPE" },
      { std_date, "DATE" },   
      { std_delstr, "DELSTR" },
      { std_delword, "DELWORD" }, 
      { cms_desbuf, "DESBUF" },
      { std_digits, "DIGITS" }, 
      { cms_dropbuf, "DROPBUF" },
      { dbg_dumpfiles, "DUMPFILES" },
      { dbg_dumptree, "DUMPTREE" },
      { dbg_dumpvars, "DUMPVARS" },
      { unx_eof, "EOF" },
      { std_errortext, "ERRORTEXT" },
      { unx_close, "FINIS" },
      { std_form, "FORM" }, 
      { std_format, "FORMAT" },
      { std_fuzz, "FUZZ" }, 
      { unx_getenv, "GETENV" }, 
      { unx_getpath, "GETPATH" },
      { std_insert, "INSERT" },
      { std_lastpos, "LASTPOS" }, 
      { std_left, "LEFT" },
      { std_length, "LENGTH" },
      { std_linein, "LINEIN" },
      { std_lineout, "LINEOUT" },
      { std_lines, "LINES" },
#ifdef TRACEMEM
      { dbg_listleaked, "LISTLEAKED" },
#endif
      { cms_makebuf, "MAKEBUF" },
      { std_max, "MAX" },
#ifdef TRACEMEM
      { dbg_memorystats, "MEMORYSTATS" },
#endif
      { std_min, "MIN" },
      { unx_open, "OPEN" },
      { std_overlay, "OVERLAY" },
      { unx_popen, "POPEN" },
      { std_pos, "POS" }, 
      { std_queued, "QUEUED" }, 
      { std_random, "RANDOM" }, 
      { std_reverse, "REVERSE" }, 
      { std_right, "RIGHT" }, 
      { std_sign, "SIGN" },
      { cms_sleep, "SLEEP" },
      { std_sourceline, "SOURCELINE" },
      { std_space, "SPACE" },
      { cms_state, "STATE" },
      { std_strip, "STRIP" },
      { std_substr, "SUBSTR" },
      { std_subword, "SUBWORD" },
      { std_symbol, "SYMBOL" }, 
      { std_time, "TIME" },
      { std_trace, "TRACE" },
      { dbg_traceback, "TRACEBACK" },
      { std_translate, "TRANSLATE" },
      { std_trunc, "TRUNC" }, 
      { unx_unixerror, "UNIXERROR" },
      { rex_userid, "USERID" },
      { std_value, "VALUE" }, 
      { std_verify, "VERIFY" }, 
      { std_word, "WORD" },
      { std_wordindex, "WORDINDEX" }, 
      { std_wordlength, "WORDLENGTH" }, 
      { std_wordpos, "WORDPOS" }, 
      { std_words, "WORDS" },
      { std_x2c, "X2C" },
      { std_x2d, "X2D" },
      { std_xrange, "XRANGE" },
      { NULL, NULL } 
} ;

int num_funcs = (sizeof(functions)/(2*(sizeof(char *)))) - 1 ;


#ifdef TRACEMEM
static paramboxptr listleaked_params ;

void mark_listleaked_params()
{
   extern paramboxptr listleaked_params ;
   paramboxptr pptr ;

   for (pptr=listleaked_params; pptr; pptr=pptr->next) 
   {
      markmemory( (char*)pptr, TRC_PROCARG ) ;
      if (pptr->value) 
         markmemory( pptr->value, TRC_PROCARG ) ;
   }
}
#endif

   
paramboxptr initplist( nodeptr this )
{
#ifdef TRACEMEM
   extern paramboxptr listleaked_params ;
#endif
   paramboxptr first, last ;

   first = (paramboxptr)Malloc(sizeof(parambox)) ;
   first->value = NULL ;
   last = getnextp(this,first) ;

#ifdef TRACEMEM
   listleaked_params = first ;
#endif
   return first ;
}

char *buildtinfunc( nodeptr this ) 
{
   extern int num_funcs ;
   paramboxptr first ;
   int low=0, mid, end=1, up=num_funcs-1 ;
   char *ptr ;

   while ((end)&&(up>=low)) {
      mid = (up+low)/2 ;
      end = (strcmp(functions[mid].funcname,this->name)) ;
      if (end>0) 
         up = mid-1 ;
      else 
         low = mid+1 ; }

   if (end)
      exiterror( 43 ) ;

   first = initplist( this ) ;
   ptr = functions[mid].function(first->next) ;
   deallocplink( first ) ;
   return ptr ;
}


paramboxptr getnextp( nodeptr this, paramboxptr lastp ) 
{
   char *pptr ;
   nodeptr ptr ;
   int i ;

   for (i=0;i<5;i++) {
      if ((ptr=this->p[i])&&(ptr->type!=X_EXPRLIST)) {
         pptr = evaluate( this->p[i] ) ;
         lastp = lastp->next = (paramboxptr)Malloc(sizeof(parambox) ) ;
         lastp->next = NULL ;
         if (pptr) 
            lastp->value = pptr ;
         else
            lastp->value = NULL ; }
      else
         if (ptr)
            lastp = getnextp( ptr, lastp ) ; }

   return lastp ;
}


void deallocplink( paramboxptr first ) 
{
   if (first) {
      deallocplink( first->next ) ;
      if (first->value) 
         Free( first->value ) ;
      Free( (char *)first ) ; }
}


int myatol( char *text )
{
   char *ptr ;
   int output ;
   
   output = strtol( text, &ptr, 10 ) ;
   for (;(*ptr)==' ';ptr++) ;
   if (*ptr)
      exiterror( ERR_INVALID_INTEGER ) ; 

   return output ;
}


int atozpos( char *text )
{ 
   int result ;

   if ((result=myatol(text))<0)
      exiterror(ERR_INCORRECT_CALL) ;

   return result ;
}


char getonechar( char *text )
{
   if ((!text)||(!text[0])||(text[1]))
      exiterror( ERR_INCORRECT_CALL ) ;
   
   return text[0] ;
}

int atopos( char *text )
{ 
   int result ;

   if ((result=myatol(text))<=0)
      exiterror( ERR_INCORRECT_CALL ) ;

   return result ;
}


void checkparam( paramboxptr params, int min, int max )
{
   int i ;

   for (i=0;i<min;i++,params=params->next)
      if ((!params)||(!params->value)) 
         exiterror(ERR_INCORRECT_CALL) ;

   for (;(i<max)&&(params);i++,params=params->next) ;
   if (((i==max)&&(params))&&((max)||(params->value)))
      exiterror(ERR_INCORRECT_CALL) ;
}
   

char *cpy( char *source )
{
   int length ;
   char *target ;

   length = strlen(source)+1 ;
   memcpy(target=Malloc(length),source,length) ;
   return target ;
}


char *param( paramboxptr ptr, int num )
{
   int i ;
   for (i=1;i<num;i++,ptr=ptr->next) 
      if (!ptr)
         exiterror( ERR_INTERPRETER_FAILURE ) ;

   return ((ptr)&&(ptr->value)) ? ptr->value : "" ;
}

char getoption( char *test ) 
{ 
   if ((!test)||(!test[0]))
      return 0x00 ;
  
   return toupper(test[0]) ; 
}
