/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Id: extern.h,v 1.11 1992/04/05 20:22:35 anders Exp anders $
 *
 * $Log: extern.h,v $
 * Revision 1.11  1992/04/05  20:22:35  anders
 * Added copyright notice
 * Added definititions for several routines.
 *
 * Revision 1.10  1992/03/22  18:53:16  anders
 * Renamed parameter errno to errorno, this crashes on CRAY where
 *    'errno' is a macro when <errno.h> is included.
 *
 * Revision 1.9  1992/03/22  01:45:46  anders
 * Added definitions for yylex() and yyparse()
 * Added syntactic sugar (added void lots of places)
 * Added several new functions.
 *
 * Revision 1.8  1992/03/01  03:57:22  anders
 * Added new parameters to doparse() and listleaked()
 * Added definitions for mark_systeminfo(), mark_listleaked_params()
 *    and expose_var()
 *
 * Revision 1.7  1991/06/03  02:51:44  anders
 * Changed definitions for pushcallstack() and popcallstack(), to better
 *    the control over extra entries on the stack
 *
 * Revision 1.6  91/05/28  23:45:17  anders
 * Removed references to cleareverything() and markall(), since these
 * are incorporated into listleaked().
 * 
 * Revision 1.5  91/04/05  23:40:08  anders
 * Added definitions for memory_stats() and myatof()
 * 
 * Revision 1.4  90/12/10  00:20:59  anders
 * Some changes in formatting.
 * Added some functions and routines which were implicit defined
 * Put some definitions inside #ifdef's, these were definitions
 *     for traceing memory usage, and should only be present when 
 *     such traceing is anabled.
 * 
 * Revision 1.3  90/08/11  00:28:09  anders
 * Removed the initstack() routine (not needed anymore).
 * Moved the nullstringptr() routine to misc.c
 * Added new routines in stack: mark_stack(), lines_in_stack() 
 * and stack_empty()
 * 
 * Revision 1.2  90/08/09  04:06:53  anders
 * Defined all extern routines in memory.c
 * Wrapped relevant routines in '#ifdef TRACEMEM'
 * 
 * Revision 1.1  90/08/08  02:04:40  anders
 * Initial revision
 * 
 */


/* 
 * Routines in lexsrc.l 
 */
   void initinterpret( char *string ) ;
   void initvalue( char *string ) ;
   void initscanner( void ) ;


/* 
 * Routines in maths.c 
 */
   int true( char *string ) ;
   char *add( char *first, char *second ) ;
   char *subtract( char *first, char *second ) ;
   char *multiply( char *first, char *second ) ;
   char *devide( char *first, char *second ) ;
   char *intdevide( char *first, char *second ) ;
   char *reminder( char *first, char *second ) ;
   char *negate( char *first ) ;
   char *logical_or( char *first, char *second ) ;
   char *logical_and( char *first, char *second ) ;


/* 
 * Routines in parse.c 
 */
   void doparse( char *source, nodeptr subtree, int end, int point ) ;
   paramboxptr parseargtree(nodeptr this,paramboxptr argbox,int upper);


/* 
 * Routines in debug.c 
 */
   void dumpvars( variableptr *hashptr ) ;
   void dumptree( treenode *this, int level ) ;
   int numsourcelines( void ) ;
   char *sourceline( int line ) ;
   char *getsourceline( int line, int charnr ) ;
   char *getsym( int number ) ;
#ifdef TRACEMEM
   void marksource( void ) ;
#endif


/* 
 * Routines in files.c 
 */
   char *readkbdline( void ) ;
   void mark_filetable( void ) ;
   void initfiletable( void ) ;
     

/*
 * Routines in rexx.h
 */
#ifdef TRACEMEM
   void marktree( void ) ;
#endif /* TRACEMEM */


/* ------------------------------ memory.c ------------------------------ */
   char *mymalloc( int bytes ) ;
   void myfree( char *ptr ) ;
#ifdef TRACEMEM
   int have_allocated( int flag ) ;
   void markmemory( char *ptr, int i ) ;
   int listleaked( int pflag ) ;
   void memory_stats( void ) ;
   void mark_listleaked_params( void ) ;
#endif /* TRACEMEM */

/* ------------------------------ stack.c ------------------------------ */
   char *popline( void ) ;
   void stack_lifo( char *line ) ;
   void stack_fifo( char *line ) ;
   int lines_in_stack( void ) ;
   int stack_empty( void ) ;
#ifdef TRACEMEM
   void mark_stack( void ) ;
#endif /* TRACEMEM */
   int drop_buffer( int num ) ;
   int make_buffer( void ) ;
   int destroy_buffer( void ) ;
   void type_buffer( void ) ;


/* 
 * Routines in misc.c 
 */
   char *upcase( char *text ) ;
   int strccmp( char *one, char *two ) ;
   int strnccmp( char *one, char *two, int length ) ;  
   char *nullstringptr( void ) ;  
   void getsecs( time_t *secs, time_t *usecs ) ;
   char xor( char first, char second ) ;
     


/* 
 * Routines in error.c 
 */
   char *errortext( int errorno ) ;     
   void exiterror( int errorno ) ;
   void yyerror( char *errtext ) ;
   char *getsym( int numb ) ;
 
  
/* 
 * Routines in variable.c 
 */
   variableptr *inithashtbl( void ) ;
   void setvalue( char *name, char *value ) ;
   char *getvalue( char *name, int trace ) ;
   char *isvariable( char *name ) ;
   void expose_var( char *name ) ;
   void drop_var( char *name ) ;
#ifdef TRACEMEM
   void markvariables( void ) ;
#endif /* TRACEMEM */



/* 
 * Routines in shell.c 
 */
   int perform( char *command, char *envir ) ;
   char *run_popen( char *command, char *envir ) ;
     


/* 
 * Routines in traceing.c 
 */
   void set_trace( char * ) ;
   int pushcallstack( treenode *this ) ;
   void popcallstack( int value ) ;
   void traceerror( treenode *this, int RC ) ;
   void tracecompound( char *stem, int length, char *index ) ;
   void starttrace( void ) ;
   void tracemsg( void ) ;
   void intertrace( void ) ;
   void tracevalue( char *str, char type ) ;
   void traceline( treenode *this ) ;
   void traceback( void ) ;


/* 
 * Routines in interp.c 
 */
   char *dovalue( char *string ) ;
   void dointerpret( char *string ) ;



/* 
 * Routines in interpret.c 
 */
   proclevel newlevel( proclevel oldlevel ) ;
   char *interpret( nodeptr rootnode ) ;
   void removelevel( proclevel level ) ;
   char *evaluate( nodeptr this ) ;

/*
 * Routines in yaccsrc.y
 */
   extern int yyparse() ;


     
/* 
 * Routines in funcs.c 
 */
   char *buildtinfunc( nodeptr this ) ;
   void deallocplink( paramboxptr first ) ;
   paramboxptr initplist( nodeptr this ) ;
   int myatol( char *text ) ;
   paramboxptr getnextp( nodeptr this, paramboxptr lastp ) ;
   void checkparam( paramboxptr params, int min, int max ) ;
   int atozpos( char *text ) ;
   int atopos( char *text ) ;
   char getonechar( char *text ) ;
   char *cpy( char *source ) ;     
   char *param( paramboxptr ptr, int num ) ;
   char getoption( char * ) ;



   int normalize( char *in, char *matissa, char *exponent ) ;
   int apoximate( char *in, int size ) ;
   void addtwostrings( char *one, char *two, char *answer ) ;   


/* 
 Functions in cmath.c 
 */
   double myatof( char *string ) ;
   int myisnumber( char *string, double *num ) ;


/* 
 Functions in rexx.c 
 */
   void mark_systeminfo() ;
     
