#ifndef lint
static char *RCSid = "$Id: error.c,v 1.4 1992/04/05 20:23:48 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: error.c,v $
 * Revision 1.4  1992/04/05  20:23:48  anders
 * Added copyright notice
 * Made source more ANSI C compatible.
 * Fixed small bug in exiterror. Code was not good enough
 * Added new errormessage.
 *
 * Revision 1.3  1992/03/22  18:56:47  anders
 * Renamed variable local variable errno to errorno, because on CRAY
 *    that is a macro to a function, if <errno.h> is included.
 *
 * Revision 1.2  1992/03/22  00:49:09  anders
 * Adding some UNIX-REXX specific errormessage at numbers 61-99
 * Adding support for interfacing to perror() for numbers above 99
 *    thise are shifted 100 numbers down (errortext(123)==perror(23))
 *
 * Revision 1.1  1990/08/08  02:09:26  anders
 * Initial revision
 *
 */

#include "rexx.h"
#include <errno.h>
#include <string.h>
#include <stdio.h>

void exiterror( int errorno ) 
{
   extern nodeptr currentnode ;
   extern sysinfo systeminfo ;
   int lineno, charno ;
   char *inputfile ;
   static char err1[]="REXX: Error %d running \"%s\", line %d: %s\n" ;
   static char err2[]="REXX: Error %d running \"%s\": %s\n" ;

   if (currentnode) {
      lineno = currentnode->lineno ; 
      charno = currentnode->charnr ; }
   else
      charno = lineno = 0 ;

   inputfile = systeminfo->input_file ;   
   if (lineno>0) {
      traceback() ; 
      fprintf( stderr, err1, errorno,inputfile,lineno, errortext(errorno) ) ; }
   else
      fprintf( stderr, err2, errorno,inputfile,errortext(errorno) ) ;
   
   exit( errorno ) ;
}



void yyerror(char *errtext) 
{
   extern int linenr ;
   fprintf( stderr, "REXX: yacc error in line %d: %s\n",linenr-1, errtext ) ;
}



char *errortext( int errorno ) 
{
   extern char *sys_errlist[] ;
   static char *errmsg[] = {
/*  0 */     "" ,
/*  1 */     "" ,
/*  2 */     "" ,
/*  3 */     "Program is unreadable" ,
/*  4 */     "Program interrupted" ,
/*  5 */     "Machine storage exhausted" ,
/*  6 */     "Unmatched \"/*\" or quote" ,
/*  7 */     "WHEN or OTHERWISE expected" ,
/*  8 */     "Unexpected THEN or ELSE" ,
/*  9 */     "Unexpected WHEN or OTHERWISE" ,
/* 10 */     "Unexpected or unmatched END" ,
/* 11 */     "Control stack full" ,
/* 12 */     "Clause > 500 characters" ,
/* 13 */     "Invalid character in data" ,
/* 14 */     "Incomplete DO/SELECT/IF" ,
/* 15 */     "Invalid HEX constant" ,
/* 16 */     "Label not found" ,
/* 17 */     "Unexpected PROCEDURE" ,
/* 18 */     "THEN expected" ,
/* 19 */     "String or symbol expected" ,
/* 20 */     "Symbol expected" ,
/* 21 */     "Invalid data on end of clause" ,
/* 22 */     "" ,
/* 23 */     "" ,
/* 24 */     "Invalid TRACE request" ,
/* 25 */     "Invalid sub-keyword found" ,
/* 26 */     "Invalid whole number" ,
/* 27 */     "Invalid DO symtax" ,
/* 28 */     "Invalid LEAVE or ITERATE" ,
/* 29 */     "Environment name to long" ,
/* 30 */     "Name or String > 250 characters" ,
/* 31 */     "Name starts with number or \".\"" ,
/* 32 */     "Invalid use of stem" ,
/* 33 */     "Invalid expression result" ,
/* 34 */     "Logical value not 0 or 1",
/* 35 */     "Invalid expression" ,
/* 36 */     "Unmatched \"(\" in expression" ,
/* 37 */     "Unexpected \",\" or \")\"" ,
/* 38 */     "Invalid template or pattern" ,
/* 39 */     "Evaluation stack overflow" ,
/* 40 */     "Incorrect call to routine" ,
/* 41 */     "Bad aritmetric conversion" ,
/* 42 */     "Arithmetric Overflow/Underflow" ,
/* 43 */     "Routine not found" ,
/* 44 */     "Function did not return data" ,
/* 45 */     "No data specified on function" ,
/* 46 */     "" ,
/* 47 */     "" ,
/* 48 */     "Failure in system service" ,
/* 49 */     "Interpreter failure",
/* 50 */     "",
/* 51 */     "",
/* 52 */     "",
/* 53 */     "",
/* 54 */     "",
/* 55 */     "",
/* 56 */     "",
/* 57 */     "",
/* 58 */     "",
/* 59 */     "",
/* 60 */     "Can't rewind transient file",
/* 61 */     "Improper seek operation on file",
/* 62 */     "Internal buffer too small",
/* 63 */     "Could not find REXX program",
/* 64 */     "",
             ""
             } ;

   if ((errorno<65)&&(errorno>0)) 
      return( errmsg[errorno] ) ;
 
   if (errorno>100)
     return( sys_errlist[errorno-100] ) ;

   return ( "" ) ;
}

char *getsym( int numb )
{
   char *symb ;

   if (numb==X_NULL) symb="Null statement" ;
   else if (numb==X_PROGRAM) symb="Program" ;
   else if (numb==X_STATS) symb="Statements" ;
   else if (numb==X_COMMAND) symb="External command" ;
   else if (numb==X_ADDR_V) symb="ADDRESS (value) statement" ;
   else if (numb==X_ADDR_N) symb="ADDRESS (normal) statement" ;
   else if (numb==X_ARG) symb="ARG statement" ;
   else if (numb==X_CALL) symb="CALL statement" ;
   else if (numb==X_DO) symb="DO statement" ;
   else if (numb==X_REP) symb="Repetitor in DO" ;
   else if (numb==X_REP_FOREVER) symb="Forever in DO" ;
   else if (numb==X_REP_COUNT) symb="Counter in DO" ;
   else if (numb==X_DO_TO) symb="Upper limit in DO" ;
   else if (numb==X_DO_BY) symb="Step-size in DO" ;
   else if (numb==X_DO_FOR) symb="Max number in DO" ;
   else if (numb==X_WHILE) symb="WHILE expr in DO" ;
   else if (numb==X_UNTIL) symb="UNTIL expr in DO" ;
   else if (numb==X_DROP) symb="DROP statement" ;
   else if (numb==X_EXIT) symb="EXIT statement" ;
   else if (numb==X_IF) symb="IF statement" ;
   else if (numb==X_IPRET) symb="INTERPRET statement" ;
   else if (numb==X_ITERATE) symb="ITERATE statement" ;
   else if (numb==X_LABEL) symb="Label specification" ;
   else if (numb==X_LEAVE) symb="LEAVE statement" ;
   else if (numb==X_NUM_D) symb="NUMERIC DIGIT statement" ;
   else if (numb==X_NUM_F) symb="NUMERIC FORM statement" ;
   else if (numb==X_NUM_FUZZ) symb="NUMERIC FUZZ statement" ;
   else if (numb==X_NUM_SCI) symb="Scientific numeric form" ;
   else if (numb==X_NUM_ENG) symb="Engeenering scientific form" ;
   else if (numb==X_PARSE) symb="PARSE statement" ;
   else if (numb==X_PARSE_U) symb="UPPER PARSE statement" ;
   else if (numb==X_PARSE_ARG) symb="PARSE ARG atatement" ;
   else if (numb==X_PARSE_EXT) symb="External parsing" ;
   else if (numb==X_PARSE_NUM) symb="Numeric parsing" ;
   else if (numb==X_PARSE_PULL) symb="Parse pull" ;
   else if (numb==X_PARSE_SRC) symb="Parse source" ;
   else if (numb==X_PARSE_VAR) symb="Parse variable" ;
   else if (numb==X_PARSE_VAL) symb="Parse value" ;
   else if (numb==X_PARSE_VER) symb="Parse version" ;
   else if (numb==X_PARSE_ARG_U) symb="PARSE UPPER ARG statement" ;
   else if (numb==X_PROC) symb="PROCEDURE statement" ;
   else if (numb==X_PULL) symb="PULL statement" ;
   else if (numb==X_PUSH) symb="PUSH statement" ;
   else if (numb==X_QUEUE) symb="QUEUE statement" ;
   else if (numb==X_RETURN) symb="RETURN statement" ;
   else if (numb==X_SAY) symb="SAY statement" ;
   else if (numb==X_SELECT) symb="SELECT statement" ;
   else if (numb==X_WHENS) symb="WHEN connector" ;
   else if (numb==X_WHEN) symb="WHEN clause" ;
   else if (numb==X_OTHERWISE) symb="OTHERWISE clause" ;
   else if (numb==X_SIG_VAL) symb="SIGNAL VALUE statement" ;
   else if (numb==X_SIG_LAB) symb="SIGNAL (label) statement" ;
   else if (numb==X_SIG_SET) symb="SIGNAL (setting) statement" ;
   else if (numb==X_ON) symb="Setting is ON" ;
   else if (numb==X_OFF) symb="Setting is OFF" ;
   else if (numb==X_S_ERROR) symb="ERROR option" ;
   else if (numb==X_S_HALT) symb="HALT option" ;
   else if (numb==X_S_NOVALUE) symb="NOVALUE option" ;
   else if (numb==X_S_SYNTAX) symb="SYNTAX option" ;
   else if (numb==X_TRACE) symb="TRACE statement" ;
   else if (numb==X_T_ALL) symb="ALL option" ;
   else if (numb==X_T_COMM) symb="COMMAND option" ;
   else if (numb==X_T_ERR) symb="ERROR option" ;
   else if (numb==X_T_INTER) symb="INTERMEDIATE option" ;
   else if (numb==X_T_LABEL) symb="LABEL option" ;
   else if (numb==X_T_NORMAL) symb="NORMAL option" ;
   else if (numb==X_T_OFF) symb="OFF option" ;
   else if (numb==X_T_SCAN) symb="SCAN option" ;
   else if (numb==X_UPPER_VAR) symb="UPPER statement" ;
   else if (numb==X_ASSIGN) symb="Assignment" ;
   else if (numb==X_LOG_NOT) symb="Logical NOT" ;
   else if (numb==X_PLUSS) symb="Plus operator" ;
   else if (numb==X_EQUAL) symb="Equal operator" ;
   else if (numb==X_MINUS) symb="Minus operator" ;
   else if (numb==X_MULT) symb="Multiplication operator" ;
   else if (numb==X_DEVIDE) symb="Division operator" ;
   else if (numb==X_MODULUS) symb="Modulus operator" ;
   else if (numb==X_LOG_OR) symb="Logical or" ;
   else if (numb==X_LOG_AND) symb="Logical and" ;
   else if (numb==X_LOG_XOR) symb="Logical xor" ;
   else if (numb==X_EXP) symb="Exponent operator" ;
   else if (numb==X_CONCAT) symb="String concatenation" ;
   else if (numb==X_SPACE) symb="Space separator" ;
   else if (numb==X_GTE) symb="Greater than or equal operator" ;
   else if (numb==X_LTE) symb="Less than or equal operator" ;
   else if (numb==X_GT) symb="Greater than operator" ;
   else if (numb==X_LT) symb="Less than operator" ;
   else if (numb==X_DIFF) symb="Different operator" ;
   else if (numb==X_SIM_SYMBOL) symb="Simple symbol" ;
   else if (numb==X_CON_SYMBOL) symb="Constant symbol" ;
   else if (numb==X_HEX_STR) symb="Hexadecimal string" ;
   else if (numb==X_STRING) symb="Constant string" ;
   else if (numb==X_FUNC) symb="Function call" ;
   else if (numb==X_U_MINUS) symb="Unary minus" ;
   else if (numb==X_S_EQUAL) symb="String equal operator" ;
   else if (numb==X_S_DIFF) symb="String different operator" ;
   else if (numb==X_SIMSYMB) symb="Simple symbol (2)" ;
   else if (numb==X_INTDIV) symb="Integer division" ;
   else if (numb==X_EX_FUNC) symb="External function call" ;
   else if (numb==X_IN_FUNC) symb="Internal function call" ;
   else if (numb==X_TPL_SOLID) symb="Solid point in template" ;
   else if (numb==X_TPL_MVE) symb="Constant pattern" ;
   else if (numb==X_TPL_VAR) symb="Variable pattern" ;
   else if (numb==X_TPL_TO) symb="Ehh, what does \"TO\" mean???" ;
   else if (numb==X_TPL_SYMBOL) symb="Variable in tamplate" ;
   else if (numb==X_TPL_SPACE) symb="Space in template" ;
   else if (numb==X_TPL_POINT) symb="Placeholder in template" ;
   else if (numb==X_TMPLS) symb="Template connector" ;
   else if (numb==X_TPL_OFF) symb="Offset in template" ;
   else if (numb==X_TPL_PATT) symb="Pattern in template" ;
   else if (numb==X_NEG_OFFS) symb="Negative offset" ;
   else if (numb==X_POS_OFFS) symb="Positive offset" ;
   else if (numb==X_ABS_OFFS) symb="Absolute offset" ;
   else if (numb==X_EXPRLIST) symb="Expression connector" ;
   else if (numb==X_SYMBOLS) symb="Symbol connector" ;
   else if (numb==X_SYMBOL) symb="Symbol?" ;
   else if (numb==X_END) symb="End statement" ;
   else
      symb="Unrecognized value" ;

   return symb ;
}

  
/*    
   switch ( numb ) {     
   
      case ADDRESS:
      case VALUE:
      case ARG:
      case CALL:
      case DO:
      case FOREVER:
      case TO:
      case BY:
      case FOR:
      case WHILE:
      case UNTIL:
      case END:
      case DROP:
      case EXIT:
      case IF:
      case THEN:
      case ELSE:
      case INTERPRET:
      case ITERATE:
      case LEAVE:
      case NOP:
      case NUMBERIC:
      case DIGITS:
      case FORM:
      case SCIENTIFIC:
      case ENGINEERING:
      case FUZZ:
      case UPPER:
      case PARSE:
      case EXTERNAL:
      case PULL:
      case SOURCE:
      case WITH:
      case VAR:
      case PROCEDURE:
      case PUSH:
      case QUEUE:
      case RETURN:
      case SAY:
      case SELECT:
      case WHEN:
      case OTHERWISE:
      case SIGNAL:
      case ON:
      case OFF:
      case ERROR:
      case HALT:
      case NOVALUE:
      case SYNTAX:
      case TRACE:
      case ALL:
      case COMMANDS:
      case COMMAND:
      case ERRORS:
      case INTERMEDIATES:
      case LABELS:
      case NORMAL:
      case RESULTS:
      case SCAN:
         printf("Debug: found keyword/instruction :%s:\n", symb ) ;
         break ;

      case SYMBOL:
         printf("Debug: found symbol :%s:\n", symb ) ;
         break ;

      case STRING: 
         printf("Debug: found string :%s:\n", symb ) ;
         break ;

      }
}

 */
