#ifndef lint
static char *RCSid = "$Id: debug.c,v 1.7 1992/04/05 20:27:00 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: debug.c,v $
 * Revision 1.7  1992/04/05  20:27:00  anders
 * Added copyright notice, and ANSI-fied the code
 *
 * Revision 1.6  1992/03/22  00:51:45  anders
 * Added support for writing out the default value for associative
 *    arrays, or "<none>" it the default is not set.
 * #included <stdio.h> and <strings.h>, as these are removed from rexx.h
 * Fixed bug: tried to read variable value as a hashtable, this was
 *    once a quick'n dirty sideeffect and had been changed elsewhere,
 *    but still existed in this file.
 *
 * Revision 1.5  1991/04/05  23:30:25  anders
 * Put #ifdef's around markmemory()
 *
 * Revision 1.4  90/12/11  00:02:58  anders
 * Removed two bugs connected to line continuation.
 *     1) The first character in the continuation line was omitted when
 *     the line was written out during tracing.
 *     2) If to symbols were separated by just line continuation (and 
 *     not any white-space) they were concatenated when written out during
 *     traceing.
 * 
 * Revision 1.3  90/12/10  00:30:26  anders
 * Casted a pointer to (char*), to avoid compiler warning.
 * 
 * Revision 1.2  90/08/09  04:01:38  anders
 * Changed magic numbers with TRC_* macros
 * 
 * Revision 1.1  90/08/08  02:09:11  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <string.h>

void dumpvars( variableptr *hashptr ) 
{ 
   variableptr ptr, tptr ;
   extern proclevel currlevel ;
   int i, j ;

   if (hashptr==NULL)
      hashptr = currlevel->vars ;
   
   printf("\nDumping variables to <stdout>\n") ;
   for (i=0;i!=256;i++) {
      if (hashptr[i]!=NULL)
         printf("   Variables from bin no %d\n",i) ;
      for (ptr=hashptr[i];ptr!=NULL;ptr=ptr->next)  
         if ((ptr->name)[strlen(ptr->name)-1]=='.') {
            printf("   >>> Stem    : //%s// Default: //%s//  Values:\n",
                    ptr->name,(ptr->value)?(ptr->value):"<none>") ;
            for (j=0;j<256;j++) {
               if (tptr=((ptr->index))[j]) {
                  printf("      Sub-bin no %d\n",j) ;
                  for (;tptr;tptr=tptr->next) 
                     if ((tptr->value)&&(tptr->name))
                        printf("      >>> Variable: //%s// Value: //%s//\n",
                                    tptr->name,tptr->value) ; } ; } ; }
         else 
            printf("   >>> Variable: //%s// Value: //%s//\n",
                                            ptr->name,ptr->value) ; }

   return ;
}


void dumptree(treenode *this, int level) 
{
   int i, j ;

   for (i=0;i!=level;i++)
      printf("  ") ;
   
   printf(">>> in type=%d == %s\n", this->type, getsym(this->type)) ; 
   if ((this->value)!=NULL) {
      for (i=0;i!=level;i++) printf("  ") ;
      printf("Value: //%s//\n", this->value) ; } ;

   if ((this->name)!=NULL) {
      for (i=0;i!=level;i++) printf("  ") ;
      printf("Name: //%s//\n", this->name) ; } ;

   if ((this->charnr)!=0) {
      for (i=0;i!=level;i++) printf("  ") ;
      printf("Lineno: %d   Charno: %d\n", this->lineno, this->charnr) ; } ;

   for (j=0;j!=5;j++)
      if (this->p[j]!=NULL) {
         for (i=0;i!=level;i++) 
            printf("  ") ;
         printf("==> (%d) going down in branch %d, type %d = %s\n",
                this->type,j+1,this->p[j]->type,getsym(this->p[j]->type)) ;
         dumptree( this->p[j], level+1 ) ; }
         
   for (i=0;i!=level;i++) 
      printf("  ") ;
   printf("<<< out of type=%d = %s\n", this->type,getsym(this->type)) ; 

}


int numsourcelines( void )
{
   extern lineboxptr lastline ;
   return (lastline) ? lastline->lineno : 0 ;
}



#ifdef TRACEMEM
void marksource()
{
   extern lineboxptr firstline ;
   lineboxptr ptr ;
   
   for (ptr=firstline;ptr;ptr=ptr->next) {
      markmemory( ptr->line,TRC_SOURCEL ) ;
      markmemory( (char *)ptr, TRC_SOURCE ) ; }
}
#endif


char *sourceline( int line ) 
{
   extern lineboxptr firstline ;
   static lineboxptr ptr=NULL ;
   static int lineno=0 ;

   if (!ptr) {
      lineno = 1 ;
      ptr = firstline ; }

   for (;(lineno<line);) {
      if ((ptr=ptr->next)==NULL) return NULL ;
      lineno = ptr->lineno ; }

   for (;(lineno>line);) {
      if ((ptr=ptr->prev)==NULL) return NULL ;
      lineno = ptr->lineno ; }

   return (ptr) ? ptr->line : NULL ;
}


char *getsourceline( int line, int charnr )
{
   int finished=0, j=0, i, dquote=0, squote=0 ;
   char *string, *ptr ;


   if ((--charnr)<0) charnr=0 ;

   ptr = sourceline(line) ;
   while (!ptr) 
      ptr = sourceline(--line) ;
   
   for (;ptr[charnr]==' ';charnr++) ;
   string = Malloc(BUFFERSIZE+1) ;

   while ((!finished)&&(j<BUFFERSIZE)&&(ptr)) {
      if (((!ptr[charnr])||(ptr[charnr]==';')||(ptr[charnr]==':'))&&!(dquote||squote))
         finished = 1 ;
      else if ((ptr[charnr]==',')&&(!(dquote||squote))) {
         for (i=charnr+1;(ptr[i]==' ');i++) ;
         if (ptr[i])
            string[j++] = ptr[charnr++] ; 
         else {
            string[j++] = ' ' ;
            ptr = sourceline(++line) ; 
            for (charnr=0;ptr[charnr]==' ';charnr++) ;
                                       } ; } /* hva om det var siste linje? */
               
      else if ((ptr[charnr]=='\'')&&(!dquote))
         squote = !squote ;

      else if ((ptr[charnr]=='\"')&&(!squote))
         dquote = !dquote ;

     if ((!finished)||(ptr[charnr]==':'))
         string[j++] = ptr[charnr++] ; }

   string[j] = '\000' ;
   return string ;
}
      
         
      
      



