#ifndef lint
static char *RCSid = "$Id: dbgfuncs.c,v 1.6 1992/04/05 20:27:56 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: dbgfuncs.c,v $
 * Revision 1.6  1992/04/05  20:27:56  anders
 * Added copyright notice
 * Added options to listleaked()
 *
 * Revision 1.5  1992/03/22  01:27:18  anders
 * #include'd stdio.h, which was removed from rexx.h
 * Added support for options in allocated()
 *
 * Revision 1.4  1992/03/01  04:00:14  anders
 * Rewrote use of sprintf(), since it can not be trusted to return
 *    the string it has been writing to.
 * Added support for a parameter to listleaked() (quick and dirty)
 *
 * Revision 1.3  1991/05/28  23:40:26  anders
 * Removed calls to cleareverything() and markall(), since these two
 * routines are incorporated in listleaked()
 *
 * Revision 1.2  91/04/05  23:23:32  anders
 * Added dbg_memorystats()
 * Put #ifdef's around list_leaked()
 * 
 * Revision 1.1  90/08/08  02:08:51  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <ctype.h>

char *dbg_traceback( paramboxptr parms )
{
   traceback() ;
   return nullstringptr() ;
}


char *dbg_dumpvars( paramboxptr parms ) 
{
   char *ptr ;
   extern proclevel currlevel ;

   dumpvars(currlevel->vars) ;
   ptr = Malloc(1) ;
   *ptr = '\000' ;  
   return ptr ;
}


#ifdef TRACEMEM
char *dbg_memorystats( paramboxptr parms )
{
/*    memory_stats() ; */
   return nullstringptr() ;
}


char *dbg_allocated( paramboxptr parms )
{
   char ch, *ptr ;

   checkparam( parms, 0, 1 ) ;
   if (!parms->value)
      ch = 'A' ;
   else
      ch = getonechar(parms->value) & 0xdf ;

   switch ( ch ) 
   {
      case 'A' :
         sprintf(ptr=Malloc(SMALLSTR),"%d",have_allocated(MEM_ALLOC)) ;
         break ;

      case 'L' :
         sprintf(ptr=Malloc(SMALLSTR),"%d",have_allocated(MEM_LEAKED)) ;
         break ;

      case 'C' : 
         sprintf(ptr=Malloc(SMALLSTR),"%d",have_allocated(MEM_CURRENT)) ;
         break ;

      case 'S' :
         sprintf(ptr=Malloc(80),"Memory: Allocated=%d, Current=%d, Leaked=%d",
                 have_allocated(MEM_ALLOC), have_allocated(MEM_CURRENT),
                 have_allocated(MEM_LEAKED)) ;     
          break ;

      default:
          exiterror( ERR_INCORRECT_CALL ) ;
   }

   return( ptr ) ;
}
#endif


char *dbg_dumptree( paramboxptr parms ) 
{
   char *ptr ;
   extern treenode *rootnode ;

   dumptree( rootnode, 1 ) ;
   ptr = Malloc(1) ;
   *ptr = '\000' ;
   return ptr ;
}


#ifdef TRACEMEM


char *dbg_listleaked( paramboxptr parms )
{
   char *ptr, ch ;
   int i ;

   checkparam( parms, 0, 1 ) ;
   if (parms->value)
      ch = toupper(getonechar(parms->value)) ;
   else 
      ch = 'L' ;

   if (ch=='N')
      i = listleaked( MEMTRC_NONE ) ;
   else if (ch=='L')
      i = listleaked( MEMTRC_LEAKED ) ;
   else if (ch=='A')
      i = listleaked( MEMTRC_ALL ) ;
   else
      exiterror( ERR_INCORRECT_CALL ) ;

   ptr = Malloc(SMALLSTR) ;
   sprintf(ptr,"%d",i) ;
   return ptr ;
}
#endif
