#ifndef lint
static char *RCSid = "$Header: /auto/home/flipper/anders/flipper/prosj/rexx/RCS/convert.c,v 1.2 1992/04/05 20:28:55 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: convert.c,v $
 * Revision 1.2  1992/04/05  20:28:55  anders
 * Added copyright notice
 * Make code more ANSI compatible
 * Made a cpp macro more clean (some compiler just has to get it Right)
 * Removed code that was not used.
 *
 * Revision 1.1  1992/03/23  05:07:26  anders
 * Initial revision
 *
 */


#include "rexx.h"
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <ctype.h>


#define HEXVAL(x) (((x)>='A')?((((x)>='a')?((x)&(0xdf)):(x))-'A'+10):((x)-'0'))


static char *unpack_hex( char *string ) 
{   
   static char hexnum[] = "0123456789ABCDEF" ;
   char *result, *hptr ;
   unsigned char *cptr ;

   result = hptr = Malloc( strlen( string )*2 + 1 ) ;

   for (cptr=(unsigned char*)string; *cptr; cptr++ )
   {
      *hptr++ = hexnum[ (*cptr>>4) ] ; 
      *hptr++ = hexnum[ (*cptr & 0x0f) ] ;
   }
 
   *hptr = 0x00 ;
   return result ;
}


static char *make_binary( int number, int length ) 
{
   char *result ;
   int itmp, i, j ;

   if ((length==(-1))&&(number<0))
      exiterror( ERR_INCORRECT_CALL ) ;

   if ((length==(-1))&&(number==0))
   {
      result=Malloc(2) ;
      result[0] = 0x00 ;
      result[1] = 0x00 ;  /* jaja ... */
   }
   else if (length==(-1))
   {
      for (i=0,itmp=number; itmp ; itmp/=0x100) ;
      result = Malloc( itmp + 2 ) ;
      for (j=0,itmp=number; itmp ; itmp/=0x100) 
         result[i-j] = itmp%(0x100) ;
      result[i+1] = 0x00 ;
   }
   else if (number>=0)
   {
      result = Malloc( length + 1 ) ;
      for (j=length-1,itmp=number; j>=0; itmp/=0x100)
         result[j--] = itmp%(0x100) ;
      result[length] = 0x00 ;
   }
   else
   {
      result = Malloc( length + 1 ) ;
      for (j=length-1; j>=0; j--)
      {
         result[j] = (number&(0xff)) ;
         number = number>>8 ;
      }
      result[length] = 0x00 ;
   }

   return result ;
}


static char *pack_hex( char *string )
{
   char *result, *cptr, *ptr ;
   int out=0 ;

   result = Malloc( strlen(string) + 2 ) ;
   for (cptr=string; *cptr; )
   {
      for (; (isspace(*cptr)); cptr++) ;
      for (ptr=cptr; (isxdigit(*ptr)); ptr++ ) ;
      if ((ptr-cptr)%2)
      {
         result[out++] = HEXVAL(*cptr) ;
         cptr++ ;
      }
       
      for (; cptr<ptr; cptr+=2 ) 
         result[out++] = (HEXVAL(*cptr)<<4) + HEXVAL(*(cptr+1)) ;  
   }
   result[out] = 0x00 ;
   return result ;
}



static char *numerize( char *string, int number ) 
{
   char *result, *ptr ;
   int sleng, res, negative=0 ;

   sleng = strlen( string ) ;
   if ((number<=sleng)&&(number!=(-1)))
   {
      string += sleng-number ;
      negative = (((unsigned char)(*string)) & 0x80) ;
   }
   else
      negative = 0 ;

   result = Malloc( strlen(string)*3 + 2 ) ; /* +sign +null-byte */

   res = 0 ;
   for (ptr=string; *ptr; ptr++) 
      res = res*256 + (unsigned char)*ptr ;
 
   if (negative)
      res = res - pow(256,number) ;     
 
   sprintf( result, "%d", res ) ;
   return result ;
}


char *std_x2d( paramboxptr parms )
{
   int length=(-1) ;
   char *result, *packed ;

   checkparam( parms, 1, 2 ) ;
   if ((parms->next)&&(parms->next->value))
      length = atozpos( parms->next->value ) ;

   packed = pack_hex( parms->value ) ;
   result = numerize( packed, length ) ;
   Free( packed ) ;
   return result ;
}



char *std_x2c( paramboxptr parms ) 
{
   checkparam( parms, 1, 1 ) ;
   return pack_hex( parms->value ) ;
}



char *std_c2d( paramboxptr parms )
{
   int length=(-1) ;
 
   checkparam( parms, 1, 2 ) ;

   if ((parms->next)&&(parms->next->value))
      length = atozpos( parms->next->value ) ;

   return numerize( parms->value, length ) ;
}


char *std_c2x( paramboxptr parms )
{
   checkparam( parms, 1, 1 ) ;
   return unpack_hex( parms->value ) ;
}


char *std_d2c( paramboxptr parms )
{
   int length=(-1), number ;

   checkparam( parms, 1, 2 ) ;
   number = myatol( parms->value ) ;
   if ((parms->next)&&(parms->next->value))    
      length = atozpos(parms->next->value) ;

   return make_binary( number, length ) ;
}

   

char *std_d2x( paramboxptr parms )
{
   int number, length=(-1), i ;
   char *result, *packed, *ptr ;

   checkparam( parms, 1, 2 ) ;
   number = myatol( parms->value ) ;
   if ((parms->next)&&(parms->next->value))    
      length = atozpos(parms->next->value) ;

   packed = make_binary( number, (length==(-1))?(-1):((length+1)/2) ) ;
   result = unpack_hex( packed ) ;
   Free( packed ) ;

   if ((length==(-1))&&(strlen(result)>1)&&(result[0]=='0'))
   {
      for (i=0; (result[i]=='0')&&(result[i+1]) ; i++) ;
      for (ptr=result; (ptr==result)||(*(ptr+i-1)); ptr++ )
         *ptr = *(ptr+i) ;
   }

   if ((length>=0)&&(length%2))
   {
      for (ptr=result; *ptr; ptr++ ) 
         *ptr = *(ptr+1) ;
   }


   return result ;
}
