/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Id: config.h,v 1.7 1992/04/05 20:30:52 anders Exp anders $
 *
 * $Log: config.h,v $
 * Revision 1.7  1992/04/05  20:30:52  anders
 * Added copyright notice
 * Added macros for isolation of gettimeofday() and ftruncate()
 * Added macro for isolation of rand() and srand()
 * Added soim code needed for Dolphin
 *
 * Revision 1.6  1992/03/22  18:52:42  anders
 * Added support for CRAY
 *
 * Revision 1.5  1992/03/22  01:23:26  anders
 * Added FIX_PROTOS to switch patching of prototypes.
 * Added support for configuring wether to use rand() or random()
 * Added cpp-macros for most OS'es i compile on.
 *
 * Revision 1.4  1992/03/01  18:57:58  anders
 * Removed EIGHTBITCLEAN from m88k ... I don't remember why ... ?
 *
 * Revision 1.3  1991/06/03  02:52:55  anders
 * On ultrix-mashines, HAS_USLEEP is #ifdef'ed away
 * Added defaults for numeric fuzz and size, and default math type
 *
 * Revision 1.2  91/04/05  23:45:48  anders
 * Addet support for configurable directory separator character
 * Added flag for the existence of usleep()
 * 
 * Revision 1.1  90/08/08  02:04:01  anders
 * Initial revision
 * 
 */

/* Configurable values */


/* The macro MAXLEVELS is the maximum number of levels that the 
 *   interpreter shall handle. One level is used for functioncalls and
 *   the commands CALL, IF, DO and SELECT
 */
#define MAXLEVELS        1024

/* The macro HASHTABLENGTH is the number of sloths in the hash table
 *   containing the values of the rexx variables
 */
#define HASHTABLENGTH     256

/* The macro MAX_INDEX_LENGTH defines the maximum length that the name
 *   of an compund variable might expand to.
 */
#define MAX_INDEX_LENGTH  256

/*
 * Define the following macro if you have 'struct timeval' and gettimeofday()
 *   these should be in /usr/include/sys/time.h
 */
#define HAS_TIMEVAL

/* 
 * The FILE_SEPARATOR is one character, and defines the char that separates
 *    directories, and filename from directories
 */

#define FIX_PROTOS

#ifdef MSDOS
# define FILE_SEPARATOR	   '\\'
#else
# define FILE_SEPARATOR    '/'
#endif


#if defined(hpux) || defined(__hpux)
# define HPUX
# undef HAS_TIMEVAL
#endif


#if defined(m88k) || defined(__m88k__)
# define SYSV88 1
# define PIPE_BUF 4096
#endif

#ifdef sun
# define SUNOS 1
#endif

#if defined(sgi) || defined(__sgi)
# define SGI 1
#endif

#if defined(__osf__)
# define OSF 1
#endif

#if defined(ultrix) || defined(__ultrix__)
# define ULTRIX 1
#endif

/* 
 * Define HAS_USLEEP if you have the usleep() function available. It will
 *    take the number of micro-seconds to sleep. If this is not defined, 
 *    the 'normal' sleep() will be used.
 */

#ifdef SUNOS
#define HAS_USLEEP
#endif


/*
 * Define HAS_RANDOM if your machine has the routines random() and 
 *    srandom(). If it is not defined, rand() and srand() are used
 *    instead. There are several reason why you might want to use 
 *    random() instead of rand()
 */

#if SUNOS || ULTRIX
# define HAS_RANDOM
#endif

#ifdef HAS_RANDOM
  extern long random( void ) ;
  extern void srandom( int ) ;
#endif 


#define DEFAULT_NUMERIC_FUZZ 0
#define DEFAULT_NUMERIC_SIZE 9
#define DEFAULT_MATH_TYPE 0


#ifndef SYSV88
#define HAS_FTRUNCATE
#endif

#if ! SYSV88
# define EIGHTBITCLEAN
#endif


#if defined(sysV88) || defined(CRAY)
# define WAITTYPE (int*)
#else
# define WAITTYPE (union wait *)
#endif

