#ifndef lint
static char *RCSid = "$Id: cmsfuncs.c,v 1.8 1992/04/05 20:32:48 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: cmsfuncs.c,v $
 * Revision 1.8  1992/04/05  20:32:48  anders
 * Added copyright notice, and did some changes to make code more
 * compatible.
 *
 * Revision 1.7  1992/03/22  01:29:13  anders
 * #include'd some files, which were removed from rexx.h
 * Added explicit definition of sleep() for Ultrix
 * Added alternative cms_state for machines without scandir
 *
 * Revision 1.6  1992/03/01  19:10:16  anders
 * Fixed problems with returnvalue for sprintf
 *
 * Revision 1.5  1991/06/03  02:57:53  anders
 * Fixed a typo.
 *
 * Revision 1.4  91/05/28  23:39:03  anders
 * Initiated number of buffers til drop to correct number (drop the last
 * buffer, counted as "-1")
 * 
 * Revision 1.3  91/03/27  18:19:27  anders
 * Inserted #ifdef's for choosing usleep() or sleep(), which to use is 
 * defined in config.h by the macro HAS_USLEEP
 * Moved definitions of filename and select() further down in the file, 
 * and renamed select() to select_file() to avoid shaddowing select(2)
 * Swapped hardcoded '/' with macro FILE_SEPARATOR defined in config.h
 * 
 * Revision 1.2  90/08/19  02:26:58  anders
 * Implemented makebuf, dropbuf, desbuf and buftype
 * 
 * Revision 1.1  90/08/08  02:07:51  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>


char *cms_sleep( paramboxptr parms )
{
   checkparam( parms, 1, 1) ;
#ifdef HAS_USLEEP
   usleep( (int)((myatof(parms->value))*1000*1000) ) ;
#else
   sleep( atozpos( parms->value ) ) ;
#endif
   return nullstringptr() ;
}   


char *cms_makebuf( paramboxptr parms )
{
   char *ptr ;
   checkparam( parms, 0, 0 ) ;
   sprintf(ptr=Malloc(SMALLSTR),"%d",make_buffer()) ;
   return( ptr ) ;
}


char *cms_desbuf( paramboxptr parms )
{
   char *ptr ;
   checkparam( parms, 0, 0 ) ;
   sprintf(Malloc(SMALLSTR),"%d",destroy_buffer()) ;      
   return( ptr ) ;
}


char *cms_buftype( paramboxptr parms )
{
   checkparam( parms, 0, 0 ) ;
   type_buffer() ;
   return (nullstringptr()) ;
}


char *cms_dropbuf( paramboxptr parms )
{
   int buffer=-1 ;
   char *ptr ;

   checkparam( parms, 0, 1 ) ;
   if (parms->value)
      buffer = atopos(parms->value) ;

   sprintf(ptr=Malloc(SMALLSTR),"%d",drop_buffer(buffer)) ;      
   return( ptr ) ;
}
 

#ifdef HAS_SCANDIR
char *filename ;

int select_file( struct direct *entry )
{
   extern char *filename ;
   return !(strcmp(entry->d_name,filename)) ;
}


char *cms_state( paramboxptr parms ) 
{
   extern char *filename ;
   struct direct *names ;
   int last, result ;
   char *dir, *string, *retval ;

   checkparam( parms, 1, 1 ) ;
   last = strlen(string=parms->value) ;
   for (;(string[last]!=FILE_SEPARATOR)&&(last>0);last--) ;
   if (last) {
      string[last] = '\000' ;
      filename = &string[last+1] ;
      dir = string ; }
   else {
      dir = "." ;
      filename = &string[last] ; }

   result = scandir(dir,&names,&select_file,NULL) ;
   if (last)
      string[last] = FILE_SEPARATOR ;
   retval = Malloc(BOOL_STR_LENGTH) ;
   sprintf(retval,"%d",(result==1)) ;

   /* Ought to open or stat the file to check if it is readable */

   return retval ;
}
#else


char *cms_state( paramboxptr parms )
{
   char *retval ;
   int rcode ;
   struct stat buffer ;
   
   checkparam( parms, 1, 1 ) ;
   retval = Malloc( BOOL_STR_LENGTH ) ;
   
   rcode = stat( parms->value, &buffer ) ;
   sprintf( retval, "%d", (rcode==1)) ;
   return retval ;
}
#endif

