#ifndef lint
static char *RCSid = "$Id: cmath.c,v 1.6 1992/04/05 20:33:56 anders Exp anders $";
#endif

/*
 * Copyright (C) 1992 Anders Christensen <anders@solan.unit.no>
 * Read file README for more information on copying
 */

/*
 * $Log: cmath.c,v $
 * Revision 1.6  1992/04/05  20:33:56  anders
 * Added copyright notice
 * Made a kludge for Dolphin, which has a bad /usr/include
 *
 * Revision 1.5  1992/03/22  01:07:53  anders
 * #include'd stdio.h and ctype.h, as these are not included in rexx.h now
 * Removed references to EIGHTBITCLEAN, not really a good way to
 *    do it anyway.
 *
 * Revision 1.4  1992/03/01  19:08:21  anders
 * Included proper includefiles ( <math.h> and "rexx.h" )
 * Fixed types for strtod(), both parameters and returnvalues
 *
 * Revision 1.3  91/06/03  02:55:57  anders
 * Kludged away the definition of RCSid, this file should not be included
 *    into another .c file!!
 *
 * Revision 1.2  91/03/27  17:46:29  anders
 * Made a warning about overflow and underflow conditions.
 * Removed local prototype of myatof, since it is prototyped in rexx.h
 * Put GCC-specific code in #ifdef's -- over/under-flow conditions.
 * Removed to redundant calls to myatof()
 * Fixed type conflict error in arguments of a sprintf() call
 * Added test for a devide-by-zero condition
 * Deleted unreferenced (and redundant) function myatod
 * 
 * Revision 1.1  90/08/08  02:06:11  anders
 * Initial revision
 * 
 */

/* 
 * More attention should be paid to overflow and underflow conditions. 
 * This *is* done in some of the routines for the GCC compiler, but should
 * be done in an ANSI-compatible manner.
 */


#include "rexx.h"
#include <math.h>
#include <stdio.h>
#include <ctype.h>

void cadd( char *one, char *two, char *answer ) 
{
   sprintf(answer, "%G", ((double)myatof(one)+(double)myatof(two))) ;
}


void csub( char *one, char *two, char *answer ) 
{
   sprintf(answer, "%G", (myatof(one)-myatof(two))) ;
}


void cmult( char *one, char *two, char *answer ) 
{
   sprintf(answer, "%G", (myatof(one)*myatof(two))) ;
}


void cdiv( char *one, char *two, char *answer ) 
{
   sprintf(answer, "%G", (myatof(one)/myatof(two))) ;
#ifdef GCC
   if (answer[0]=='I')    /* ==> (answer=="Inf") */
      exiterror(ERR_ARITH_OVERFLOW) ;
#endif
}


void cidiv( char *one, char *two, char *answer ) 
{
   double real ;

   real = myatof(one)/myatof(two) ;
   sprintf(answer, "%d", (int)real) ;

#ifdef GCC   
   if (answer[0]=='I')
      exiterror(ERR_ARITH_OVERFLOW) ;
#endif

}


void crem( char *one, char *two, char *answer ) 
{
   double r1, r2, r3 ;

   r1 = myatof(one) ;
   r2 = myatof(two) ;
   r3 = (r2) ? r1/r2 : r1 ;
      
   sprintf(answer, "%G", (r1-((int)r3)*r2)) ;
}


void cneg( char *one, char *answer ) 
{
   sprintf(answer, "%G", -myatof(one)) ;
}

void clogor( char *one, char *two, char *answer )
{
   sprintf(answer, "%d", myatol(one) || myatol(two)) ;
}

void clogand( char *one, char *two, char *answer )
{
   sprintf(answer, "%d", myatol(one) && myatol(two)) ;
}


double myatof( char *string )
{
   char *ptr ;
   double answer ;

   answer = strtod(string,&ptr
#ifdef SYSV88
                              ,0
#endif
                                ) ;
   
   for (;(*ptr)&&(isspace(*ptr));ptr++) ;
#ifdef SUN_STRTOD_BUG
   for (;*ptr=='0';ptr++) ;
#endif /* SUN_STRTOD_BUG */
   if (*ptr)
      exiterror(ERR_BAD_ARITHMETRIC) ;
   return answer ;
}


int myisnumber( char *string, double *num )
{
   char *ptr ;

   if (*string==0x00)
      return 0 ;
   
   *num = strtod(string,&ptr
#ifdef SYSV88
                            ,0
#endif
                               ) ;
   for (;(*ptr)&&(isspace(*ptr));ptr++) ;
#ifdef SUN_STRTOD_BUG
   for (;*ptr=='0';ptr++) ;
#endif /* SUN_STRTOD_BUG */
   return (!*ptr) ;
}

      
