/*  $Id: file_selector.pl,v 1.1.1.1 1994/06/27 13:14:49 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1994 University of Amsterdam. All rights reserved.
*/

:- module(pce_file_selector,
	  [ ask_file/1
	  ]).
:- use_module(library(pce)).
:- require([ make_dialog/2
	   ]).

dialog(file_selector,
       [ object        :=
	   File_Selector,
	 parts         :=
	   [ File_Selector :=
	       dialog('File Selector'),
	     Extension     :=
	       text_item(extension),
	     Path          :=
	       text_item(path),
	     Directories   :=
	       list_browser(@default, 28, 13),
	     Files         :=
	       list_browser(@default, 28, 13),
	     Ok            :=
	       button(ok),
	     Cancel        :=
	       button(cancel)
	   ],
	 modifications :=
	   [ Extension   :=
	       [ length    := 5
	       ],
	     Path        :=
	       [ type      := directory,
		 length    := 46,
		 alignment := left
	       ],
	     Directories :=
	       [ name       :=
		   directories,
		 show_label :=
		   @on,
		 alignment  :=
		   column
	       ],
	     Files       :=
	       [ name       := files,
		 show_label := @on
	       ]
	   ],
	 layout        :=
	   [ right(Path, Extension),
	     below(Directories, Extension),
	     right(Files, Directories),
	     below(Ok, Directories),
	     right(Cancel, Ok)
	   ],
	 behaviour     :=
	   [ Extension   :=
	       [ message := message(Path, execute)
	       ],
	     Path        :=
	       [ message := and(message(Directories,
					members,
					?(Path?selection,
					  directories,
					  hidden_too := @on)),
				message(Directories, delete, '.'),
				message(Files,
					members,
					?(Path?selection,
					  files,
					  ?(@string_class,
					    instance,
					    '%s$',
					    Extension?selection))))
	       ],
	     Directories :=
	       [ select_message := and(message(Path,
					       selection,
					       ?(Path?selection,
						 directory,
						 Directories?selection?key)),
				       message(Path, execute))
	       ],
	     Files       :=
	       [ open_message := message(Ok, execute)
	       ],
	     Ok          :=
	       [ message := message(File_Selector,
				    return,
				    ?(Path?selection,
				      file,
				      Files?selection?key)?absolute_path)
	       ],
	     Cancel      :=
	       [ message := message(File_Selector, return, @nil)
	       ]
	   ],
	 initialise    :=
	   [ initialise := and(message(Path, selection, '.'),
			       message(Path, execute))
	   ]
       ]).



ask_file(F) :-
	make_dialog(D, file_selector),
	get(D, confirm_centered, File),
	send(D, destroy),
	File \== @nil,
	F = File.
	
