/*  $Id: ask_name.pl,v 1.1.1.1 1994/06/27 13:14:48 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1994 University of Amsterdam. All rights reserved.
*/

:- module(ask_name, [ask_name/1]).

dialog(ask_name,
       [ object        :=
	   Ask_Name,
	 parts         :=
	   [ Ask_Name := dialog('Ask Name'),
	     Name     := text_item(name),
	     Ok       := button(ok),
	     Cancel   := button(cancel)
	   ],
	 modifications :=
	   [ Name := [ length    := 15,
		       alignment := right
		     ],
	     Ok   := [ default_button := @on
		     ]
	   ],
	 layout        :=
	   [ below(Ok, Name),
	     right(Cancel, Ok)
	   ],
	 behaviour     :=
	   [ Ok     := [ message := message(Ask_Name,
					    return,
					    Name?selection)
		       ],
	     Cancel := [ message := message(Ask_Name, return, @nil)
		       ]
	   ]
       ]).


ask_name(Name) :-
	make_dialog(D, ask_name),
	get(D, confirm, RawName),
	send(D, destroy),
	RawName \== @nil,		% cancel
	Name = RawName.
