MODULE ZeusBundle;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..4] OF TEXT {
  "digital.pbm",
  "zeusSession.fv",
  "zeusIcon.pbm",
  "zeusPanel.fv",
  NIL
};

VAR Elements := ARRAY [0..4] OF TEXT {
  E0,
  NIL (* E1 .. E1_0 *),
  E2,
  NIL (* E3 .. E3_3 *),
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 1 =>
        Wr.PutText (wr, E1);
        Wr.PutText (wr, E1_0);
    | 3 =>
        Wr.PutText (wr, E3);
        Wr.PutText (wr, E3_0);
        Wr.PutText (wr, E3_1);
        Wr.PutText (wr, E3_2);
        Wr.PutText (wr, E3_3);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "P4\n190 65\n\000\000\377\377\361\377\377\343\377\377\307\377\377\217\377"
 & "\377\037\377\376?\377\374}\004\000\000\377\377\361\377\377\343\377\377\307"
 & "\377\377\217\377\377\037\377\376?\377\374\021\214\000\000\377\377\361\377"
 & "\377\343\377\377\307\377\377\217\377\377\037\377\376?\377\374\021T\000\000"
 & "\377\377\361\377\377\343\377\377\307\377\377\217\377\377\037\377\376?\377"
 & "\374\021$\000\000\377\377\361\377\377\343\377\377\307\377\377\217\377\377"
 & "\037\377\376?\377\374\021\004\000\000\377\377\361\377\377\343\377\377\307"
 & "\377\377\217\377\377\037\377\376?\377\374\021\004\000\000\377\377\361\377"
 & "\377\343\377\377\307\377\377\217\377\377\037\377\376?\377\374\021\004\000"
 & "\000\377\377\361\377\377\343\377\377\307\377\377\217\377\377\037\377\376"
 & "?\377\374\000\000\000\000\377\377\361\377\377\343\377\377\307\377\377\217"
 & "\377\377\037\377\376?\377\374\000\000\000\000\377\3741\376\037\343\377\377"
 & "\307\370\177\217\377\377\037\377\376?\303\374\000\000\000\000\377\3741\376"
 & "\037\343\377\377\307\370\177\217\377\377\037\377\376?\303\374\000\000\000"
 & "\000\377\3741\376\037\343\377\377\307\370\177\217\377\377\037\377\376?\303"
 & "\374\000\000\000\000\377\3741\376\037\343\377\377\307\370\177\217\360\377"
 & "\037\377\376?\303\374\000\000\000\000\377\3741\377\377\343\377\377\307\377"
 & "\377\217\360\377\037\377\376?\303\374\000\000\000\000\377\3741\377\377\343"
 & "\377\377\307\377\377\217\360\377\037\377\376?\303\374\000\000\000\000\377"
 & "\3741\377\377\343\377\377\307\377\377\217\360\377\037\377\376?\303\374\000"
 & "\000\000\000\376\0141\376\037\343\360a\307\370\177\217\360\377\037\340\376"
 & "?\303\374\000\000\000\000\374\0041\376\037\343\340!\307\370\177\217\300"
 & "?\037\000>?\303\374\000\000\000\000\370\0001\376\037\343\300\001\307\370"
 & "\177\217\300?\036\000\036?\303\374\000\000\000\000\360\0001\376\037\343"
 & "\300\001\307\370\177\217\300?\036\000\036?\303\374\000\000\000\000\360`"
 & "1\376\037\343\201\001\307\370\177\217\360\377\034\037\016?\303\374\000\000"
 & "\000\000\360\3701\376\037\343\207\301\307\370\177\217\360\377\034?\016?"
 & "\303\374\000\000\000\000\340\3701\376\037\343\207\301\307\370\177\217\360"
 & "\377\034?\016?\303\374\000\000\000\000\341\3741\376\037\343\017\341\307"
 & "\370\177\217\360\377\037\376\016?\303\374\000\000\000\000\341\3741\376\037"
 & "\343\017\341\307\370\177\217\360\377\037\370\016?\303\374\000\000\000\000"
 & "\341\3741\376\037\343\017\341\307\370\177\217\360\377\037\200\016?\303\374"
 & "\000\000\000\000\341\3741\376\037\343\017\341\307\370\177\217\360\377\037"
 & "\000\016?\303\374\000\000\000\000\341\3741\376\037\343\017\341\307\370\177"
 & "\217\360\377\036\001\016?\303\374\000\000\000\000\341\3741\376\037\343\017"
 & "\341\307\370\177\217\360\377\034\037\016?\303\374\000\000\000\000\340\370"
 & "1\376\037\343\007\301\307\370\177\217\360\377\034?\016?\303\374\000\000"
 & "\000\000\360\3701\376\037\343\207\301\307\370\177\217\360\377\034?\016?"
 & "\303\374\000\000\000\000\360p1\376\037\343\203\201\307\370\177\217\360\377"
 & "\034>\016?\303\374\000\000\000\000\370\0001\376\037\343\200\001\307\370"
 & "\177\217\360?\034\030\016?\303\374\000\000\000\000\370\0001\376\037\343"
 & "\300\001\307\370\177\217\360?\036\000\016?\303\374\000\000\000\000\374\004"
 & "1\376\037\343\340!\307\370\177\217\370?\036\001\016?\303\374\000\000\000"
 & "\000\376\0141\376\037\343\360a\307\370\177\217\374?\037\207\006?\303\374"
 & "\000\000\000\000\377\377\361\377\377\343\377\341\307\377\377\217\377\377"
 & "\037\377\376?\377\374\000\000\000\000\377\377\361\377\377\343\377\341\307"
 & "\377\377\217\377\377\037\377\376?\377\374\000\000\000\000\377\377\361\377"
 & "\377\343\017\301\307\377\377\217\377\377\037\377\376?\377\374\000\000\000"
 & "\000\377\377\361\377\377\343\017\303\307\377\377\217\377\377\037\377\376"
 & "?\377\374\000\000\000\000\377\377\361\377\377\343\003\203\307\377\377\217"
 & "\377\377\037\377\376?\377\374\000\000\000\000\377\377\361\377\377\343\200"
 & "\003\307\377\377\217\377\377\037\377\376?\377\374\000\000\000\000\377\377"
 & "\361\377\377\343\300\007\307\377\377\217\377\377\037\377\376?\377\374\000"
 & "\000\000\000\377\377\361\377\377\343\340\037\307\377\377\217\377\377\037"
 & "\377\376?\377\374\000\000\000\000\377\377\361\377\377\343\377\377\307\377"
 & "\377\217\377\377\037\377\376?\377\374\000\000\000\000\377\377\361\377\377"
 & "\343\377\377\307\377\377\217\377\377\037\377\376?\377\374\000\000\000\000"
 & "\377\377\361\377\377\343\377\377\307\377\377\217\377\377\037\377\376?\377"
 & "\374\000\000\000\000\377\377\361\377\377\343\377\377\307\377\377\217\377"
 & "\377\037\377\376?\377\374\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000x\000\001\000\000\000\000>\000\000\000\000\000\020\001\340"
 & "\000\004\000\000\000\000\000\000\204\000\001\000\000\000\000!\000\000\000"
 & "\000\000\020\002\020\000\004\000\000\000\000\000\000\200\210\343\207\026"
 & "a\300!\0348p\342\347\026\002\001\305\216\034\\\000\000\000\000\200\211\021"
 & "\010\231\222 !\"D\211\023\010\231\002\002&D\"`\000\000\000\000x\211\001"
 & "\010\221\022\000>\"@\210\362\010\021\002\002$D\"@\000\000\000\000\004\210"
 & "\341\017\221\021\300(>8\371\022\010\021\002\003\344D>@\000\000\000\000\004"
 & "\210\021\010\021\020 $ \004\201\022\010\021\002\002\004D @\000\000\000\000"
 & "\204\211\021\010\221\022 \"\"D\211\022\010\221\002\022$D\"@\000\000\000"
 & "\000xx\340\307\021\021\300!\0348p\362\007\021\001\341\304C\034@\000\000"
 & "\000\000\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\210\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000p\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E1 = 
   "(Scale\n  %scale\n  (HScale 1)\n  (VScale 1)\n(Rim\n  (Pen 8)\n  (Macro"
 & " Fixed BOA (child) `(Shape (Width + 0) (Height + 0) ,child))\n  (Macro\n"
 & "    Divider\n    BOA\n    (name str)\n    `(Boolean\n       %,name\n   "
 & "    (HBox\n         (VBox Fill Bar Fill)\n         (Shape (Width + 0) ("
 & "Height + 0) ,str)\n         (VBox Fill Bar Fill))))\n  (Macro\n    Divi"
 & "dee\n    BOA\n    (name child)\n    `(TSplit Flex =0 %,name Circular (G"
 & "eneric) ,child))\n  (Macro\n    AlgInside\n    ()\n    `(VBox\n       ("
 & "TSplit\n         Flex\n         =1\n         %showButtons\n         Cir"
 & "cular\n         (Generic)\n         (VBox\n           (Glue 12)\n      "
 & "     (HBox\n             Fill\n             (Filter (Border (Button %ab"
 & "ort (Rim (Pen 2) \"Abort Alg\"))))\n             (Glue 10)\n           "
 & "  Fill\n             (Border\n               (Guard\n                 ("
 & "Button\n                   (DarkShadow \"LightPink\")\n                "
 & "   (LightShadow \"VeryVeryLightPink\")\n                   (BgColor \"V"
 & "eryLightPink\")\n                   %destroy\n                   (Rim ("
 & "Pen 2) \"Destroy Session\"))))\n             Fill)))\n       (Glue 12)\n"
 & "       (HBox\n         (Border\n           (Pen 2)\n           (VBox\n "
 & "            (Glue 4)\n             (HBox Fill (Shape (Width + 0) (Heigh"
 & "t + 0) \"Algorithms\") Fill)\n             (Glue 4)\n             Bar\n"
 & "             (Filter\n               (Shape\n                 (Width 80"
 & " + Inf)\n                 (Height 100 + 0)\n                 (Browser ("
 & "ShadowSize 0) %algs Quick)))))\n         (Glue 12)\n         (Border\n "
 & "          (Pen 2)\n           (VBox\n             (Glue 4)\n           "
 & "  (HBox Fill (Shape (Width + 0) (Height + 0) \"Views\") Fill)\n        "
 & "     (Glue 4)\n             Bar\n             (Filter\n               ("
 & "Shape\n                 (Width 80 + Inf)\n                 (Height 100 "
 & "+ 0)\n                 (Browser (ShadowSize 0) %views Quick))))))))\n  "
 & "(VBox\n    (Divider\n      algBool\n      (HBox Fill (Fixed \"Algorithm"
 & ": \") (Fixed (Text %algName \"Unknown\")) Fill))\n    (Dividee algT (Al"
 & "gInside))\n    (Divider dataFormBool ";

CONST E1_0 = 
   "\"Input for algorithm\")\n    (Dividee dataFormT (HBox Fill (Generic %d"
 & "ataForm) Fill))\n    (Divider eventDataBool \"Events\")\n    (Dividee e"
 & "ventDataT (Generic %eventDataForm))))\n)\n";

CONST E2 = 
   "P4\n45 20\n\000\000\000\000\000\000\000\000\000\000\000p\000\000\000\000"
 & "\000\340\000\000\001\300\000\200\000\000\017\200\014\220\000\0009\200\314"
 & "\360\000\000\343\014\314\020\000\007\207\014\314\020\000<\0068\314\360\001"
 & "\340\0164\315\360\017\000\014<\377\000x\000\0300\360\000\300\000\0301\300"
 & "\000\000\0008?\200\000\000\0000\370\000\000\000\000\177\200\000\000\000"
 & "\000\374\000\000\000\000\000\360\000\000\000\000\001\300\000\000\000\000"
 & "\000\000\000\000\000";

CONST E3 = 
   "(Scale\n  %scale\n  (HScale 1)\n  (VScale 1)\n  (Shape\n    (Width + in"
 & "f)\n    (Height + Inf)\n    (Macro Fixed BOA (child) `(Shape (Width + 0"
 & ") (Height + 0) ,child))\n    (Macro Left BOA (child) `(Fixed (HBox ,chi"
 & "ld Fill)))\n    (Macro LeftText BOA (child) `(Text LeftAlign ,child))\n"
 & "    (ZSplit\n      (HBox\n        (VBox\n          (Rim\n            (P"
 & "en 8)\n            (VBox\n              (HBox\n                (VBox\n "
 & "                 Fill\n                  (HBox\n                    (Me"
 & "nu\n                      (Shape (Width 50) (Height 30) (Pixmap \"zeusI"
 & "con.pbm\"))\n                      (Border\n                        (Sh"
 & "ape\n                          (Width 100)\n                          ("
 & "VBox\n                            (PopMButton\n                        "
 & "      (For AboutDialog)\n                              (LeftText \"Abou"
 & "t ...\"))\n                            (PopMButton\n                   "
 & "           (For ConfigDialog)\n                              (LeftText "
 & "\"Configure ...\"))\n                            (Bar 1)\n             "
 & "               (PopMButton\n                              (For Snapshot"
 & "Dialog)\n                              (LeftText \"Snapshot ...\"))\n  "
 & "                          (Filter\n                              (PopMB"
 & "utton\n                                %restoreBtn\n                   "
 & "             (For RestoreDialog)\n                                (Left"
 & "Text \"Restore ...\")))\n                            (Bar 1)\n         "
 & "                   (MButton %photoBtn (LeftText \"Photo\"))\n          "
 & "                  (MButton %clearAlbum (LeftText \"Clear Album\"))\n   "
 & "                         (Bar 1)\n                            (Filter\n"
 & "                              (MButton\n                               "
 & " %recordBtn\n                                (Text LeftAlign %recordBtn"
 & "Text \"Record ...\")))\n                            (Filter\n          "
 & "                    (MButton %grabData (LeftText \"Grab Data\")))\n    "
 & "                        (Filter\n                              (MButton"
 & " %futurePau";

CONST E3_0 = 
   "se (LeftText \"Future Pause\")))\n                            (Filter\n"
 & "                              (MButton\n                               "
 & " %playbackBtn\n                                (Text\n                 "
 & "                 LeftAlign\n                                  %playback"
 & "BtnText\n                                  \"Playback ...\")))\n       "
 & "                     (Bar 1)\n                            (MButton %del"
 & "Views (LeftText \"Delete All Views\"))\n                            (Ba"
 & "r 1)\n                            (MButton\n                           "
 & "   %quit\n                              (BgColor \"LightPink\")\n      "
 & "                        (LeftText \"Quit\"))))))\n                    ("
 & "Glue 12)\n                    (VBox\n                      (Menu\n     "
 & "                   (Shape (Width 50) (Height 30) \"Sessions\")\n       "
 & "                 (Border\n                          (VBox\n            "
 & "                (Boolean\n                              MenuStyle\n    "
 & "                          %inTrestle\n                              =FA"
 & "LSE\n                              (LeftText \"Install sessions in Tres"
 & "tle\"))\n                            (Bar 1)\n                         "
 & "   (Filter (VBox %sessionMenu)))))\n                      Fill))\n     "
 & "             (Glue 8)\n                  Fill\n                  (HBox\n"
 & "                    (Filter\n                      (Shape (Width 25) (B"
 & "order (TypeIn %restoreShortcut))))\n                    (Fixed (Text %s"
 & "essName \"Null\"))\n                    Fill))\n                (Glue 1"
 & "2)\n                (HBox\n                  (Fixed\n                  "
 & "  (VBox\n                      (VBox\n                        (Shape (H"
 & "eight + 0) (Text LeftAlign %status \"Idle\")))\n                      ("
 & "Shape (Height 6) Fill)\n                      (HBox\n                  "
 & "      (Filter\n                          (Shape\n                      "
 & "      (Width 50)\n                            (Button %goBtn (Text %goT"
 & "ext \"GO\"))))\n                        (Glue 12)\n                    "
 & "    (Filt";

CONST E3_1 = 
   "er\n                          (Shape (Width 50) (TrillButton %stepBtn \""
 & "STEP\")))\n                        (Glue 12)\n                        ("
 & "Filter (Shape (Width 50) (Button %abortBtn \"ABORT\")))\n              "
 & "          (Glue 0))\n                      (Glue 8)\n                  "
 & "    (HBox\n                        (Fixed (Text LeftAlign \"Animation t"
 & "ime (sec): \"))\n                        (Text %delayText \"1.0\")\n   "
 & "                     Fill)\n                      (Scroller %delay =550"
 & " (Min 0) (Max 1000)))))\n                Fill)\n              (Generic "
 & "%sessionFV)\n              (Glue 0)))))\n      (ZChild\n        %AboutD"
 & "ialog\n        (Border\n          (CloseButton\n            (Rim\n     "
 & "         (Pen 2)\n              (VBox\n                (Shape (Height 0"
 & ") (Text LeftAlign %VersionTxt \"Version\"))\n                (Text Left"
 & "Align \"Send comments to mhb@src.dec.com\")\n                (Glue 4)\n"
 & "                Ridge\n                (Glue 4)\n                (Pixma"
 & "p (Color \"DarkBlue\") \"digital.pbm\"))))))\n      (ZChassis\n        "
 & "%ConfigDialog\n        (Title \"Configuration\")\n        (Shape\n     "
 & "     (Width 310 + 0)\n          (Height + 0)\n          (Rim\n         "
 & "   (Pen 16)\n            (VBox\n              (HBox\n                (S"
 & "hape (Width + 0) \"Maximum speed up:\")\n                (Glue 8)\n    "
 & "            (Frame Lowered (TypeIn %maxSpeedFactor =\"10.0\"))\n       "
 & "         Fill)\n              (Glue 8)\n              (HBox\n          "
 & "      (Text LeftAlign \"Delays are as fractions of animation delay:\")\n"
 & "                Fill)\n              (Glue 8)\n              (HBox\n   "
 & "             (Shape (Width 140) \"    Minimum event delay: \")\n       "
 & "         (Shape (Width 30) (Text RightAlign %minDelayText \"0.10\"))\n "
 & "               (Border (Scroller %minDelayFrac =10 (Min 0) (Max 100))))"
 & "\n              (Glue 8)\n              (HBox\n                (Shape ("
 & "Width 140) \"    Code view event delay: \")\n                (Shape (Wi"
 & "dth 30) (Text RightAlign %codeDelayText \"0.40\"))\n                (Bo"
 & "rder (Scroller %codeDelay";

CONST E3_2 = 
   "Frac =40 (Min 0) (Max 100))))\n              (Glue 8)\n              (H"
 & "Box\n                (Shape (Width + 0) (Text LeftAlign \"Step detail:\""
 & "))\n                (Numeric %priority =1 (Min 0) (Max 9))\n           "
 & "     Fill)\n              (Glue 8)\n              (HBox\n              "
 & "  (Shape (Width + 0) \"Photo size (mm) Width:\")\n                (Glue"
 & " 8)\n                (Frame Lowered (TypeIn %photoWidth =\"30.0\"))\n  "
 & "              (Glue 8)\n                (Shape (Width + 0) \"Height:\")"
 & "\n                (Glue 8)\n                (Frame Lowered (TypeIn %pho"
 & "toHeight =\"30.0\"))\n                Fill)\n              (Glue 8)))))"
 & "\n      (ZChassis\n        %SnapshotDialog\n        (Title \"File in wh"
 & "ich to save snapshot?\")\n        (Rim\n          (Pen 8)\n          (V"
 & "Box\n            (Frame\n              Lowered\n              (Helper ("
 & "For snapshot) (BgColor \"VeryLightGrey\") %snapshotName))\n            "
 & "(Glue 8)\n            (Frame\n              Lowered\n              (Sha"
 & "pe\n                (Width 280 + Infinity)\n                (Height 100"
 & " + Infinity)\n                (FileBrowser (BgColor \"VeryLightGrey\") "
 & "%snapshot))))))\n      (ZChassis\n        %RestoreDialog\n        (Titl"
 & "e \"File from which to restore snapshot:\")\n        (Filter\n         "
 & " %restoreContents\n          (Rim\n            (Pen 8)\n            (VB"
 & "ox\n              (Frame\n                Lowered\n                (Hel"
 & "per (For restore) (BgColor \"VeryLightGrey\") %restoreName))\n         "
 & "     (Glue 8)\n              (Frame\n                Lowered\n         "
 & "       (Shape\n                  (Width 280 + Infinity)\n              "
 & "    (Height 100 + Infinity)\n                  (FileBrowser (BgColor \""
 & "VeryLightGrey\") %restore ReadOnly)))))))\n      (ZChassis\n        %Re"
 & "cordDialog\n        (Title \"File in which to save transcript?\")\n    "
 & "    (Rim\n          (Pen 8)\n          (VBox\n            (Frame\n     "
 & "         Lowered\n              (Helper (For record) (BgColor \"VeryLig"
 & "htGrey\") %recordName))\n            (Glue 8)\n            (Frame\n    "
 & "          Lowered\n          ";

CONST E3_3 = 
   "    (Shape\n                (Width 280 + Infinity)\n                (He"
 & "ight 100 + Infinity)\n                (FileBrowser (BgColor \"VeryLight"
 & "Grey\") %record))))))\n      (ZChassis\n        %PlaybackDialog\n      "
 & "  (Title \"Transcript file to play back?\")\n        (Rim\n          (P"
 & "en 8)\n          (VBox\n            (Frame\n              Lowered\n    "
 & "          (Helper (For playback) (BgColor \"VeryLightGrey\") %playbackN"
 & "ame))\n            (Glue 8)\n            (Frame\n              Lowered\n"
 & "              (Shape\n                (Width 280 + Infinity)\n         "
 & "       (Height 100 + Infinity)\n                (FileBrowser (BgColor \""
 & "VeryLightGrey\") %playback))))))\n      (ZChassis\n        (BgColor \"L"
 & "ightPink\")\n        (DarkShadow \"DarkPink\")\n        %ErrorDialog\n "
 & "       (Title \"Error\")\n        (Rim\n          (Pen 16)\n          ("
 & "VBox\n            (Shape\n              (Width 200 + Infinity)\n       "
 & "       (Height 100 + Infinity)\n              (Border (TextEdit %error "
 & "ReadOnly)))\n            (Glue 16)\n            (HBox\n              (S"
 & "hape (Width 90) (CloseButton %errClearAndShut \"Clear & Shut\"))\n     "
 & "         (Glue 30) Fill\n              (Shape (Width 50) (Button %errCl"
 & "ear \"Clear\"))\n              (Glue 30) Fill\n              (Shape (Wi"
 & "dth 50) (CloseButton \"Shut\")))))))))";


BEGIN
END ZeusBundle.
