(* Copyright (C) 1994, Digital Equipment Corporation *)
(* All rights reserved.                              *)
(* See the file COPYRIGHT for a full description.    *)

(* This interface exports the configuration information
   used by m3build and quake.  These constants were defined
   when Modula-3 was installed. *)

INTERFACE M3Config;

CONST  (* misc. configuration *)
  TARGET    = "LINUX";
  OS_TYPE   = "POSIX";
  WORD_SIZE = "32BITS";
  BUILD_DIR = "LINUX";
  PATH_SEP  = "/";
  M3        = "/usr/local/soft/modula3-3.4/lib/m3/LINUX/m3"; (* the compiler *)

CONST (* installation directories *)
  BIN_INSTALL   = "/usr/local/soft/modula3-3.4/bin";
  LIB_INSTALL   = "/usr/local/soft/modula3-3.4/lib/m3/LINUX";
  DOC_INSTALL   = "/usr/local/soft/modula3-3.4/lib/m3/doc";
  PKG_INSTALL   = "/usr/local/soft/modula3-3.4/lib/m3/pkg";
  MAN_INSTALL   = "/usr/local/soft/modula3-3.4/man";
  EMACS_INSTALL = "/usr/local/soft/modula3-3.4/lib/elisp";
  HTML_INSTALL  = "/usr/local/soft/modula3-3.4/lib/m3/www";

(* On some systems (e.g. AFS) you must install public files
   in a different place from where you use them.  The paths
   below specify where to find the installed files. *)

CONST
  BIN_USE   = "/usr/local/soft/modula3-3.4/bin";
  LIB_USE   = "/usr/local/soft/modula3-3.4/lib/m3/LINUX";
  DOC_USE   = "/usr/local/soft/modula3-3.4/lib/m3/doc";
  PKG_USE   = "/usr/local/soft/modula3-3.4/lib/m3/pkg";
  MAN_USE   = "/usr/local/soft/modula3-3.4/man";
  EMACS_USE = "/usr/local/soft/modula3-3.4/lib/elisp";
  HTML_USE  = "/usr/local/soft/modula3-3.4/lib/m3/www";

END M3Config.
