(* Copyright 1990 Digital Equipment Corporation. *)
(* Distributed only by permission. *)

(* Lectern: a user interface for viewing documents stored as images *)
(* VBT for viewing images *)

(* Last modified on Mon Apr  4 17:53:51 PDT 1994 by birrell   *)

INTERFACE ImageVBT;

IMPORT Images, PaintOp, Point, VBT;

TYPE T <: Public;

TYPE Public = VBT.Leaf OBJECT
    (* This VBT class will display an Images.T.  The client can move the
       image by calling "moveTo" or "moveToSector". *)
  METHODS
    init(pm: Images.T; bg: PaintOp.T): T;
      (* Initialize the VBT. "pm" is the desired image and "bg" is used for
         for filling parts of the VBT's domain not occupied by the image. *)
    put(pm: Images.T; bg: PaintOp.T);
      (* LL = VBT.mu *)
      (* Sets the image for future use, and marks the VBT for redisplay *)
    get(): Images.T;
      (* LL = VBT.mu *)
      (* Returns the image *)
    getDelta(): Point.T;
      (* LL = VBT.mu *)
      (* Returns the amount by which the center of the pixmap is offset from
         the center of the VBT. *)
    moveTo(delta: Point.T; pixelRate := 0.0);
      (* LL = VBT.mu *)
      (* Scrolls and repaints so that center of pixmap is offset from center of
         the VBT by delta.  Attempts to time the scrolling so that the image
         moves at an average rate of pixelRate seconds per pixel (e.g., if
         pixelRate is 0.01 and the overall distance to be moved is 100 pixels,
         the operation would ideally take 1 second to execute). *)
  END;

END ImageVBT.
