

; list -> '((row col) ... (row col))
;  stampa
;  *---------*
;  | Q . . . |
;  ecc  ..... 
;
;
(defun print-board(board &aux len counter tmplist)
 (setf len (lenght board))

; print head
 (setf counter 0)
 (print "*")
 (loop (if (= counter len) 
	      (return)
              (progn 
		(print "--") 
		(setf counter (add1 counter))
	      )
       )
 )
 (print "-*\n")

;print core
 (setf tmplist board)
 (loop
         (setf counter 0)
         (print "|")
         (loop (if (= counter len)
                 (return)
                 (progn
                         (print (if (= counter (car(cdr(car tmplist))))
                                      " Q"
                                      " ."
                                )
                         )
                         (setf counter (add1 counter))
                 )
               )
         )
         (print " |\n")
         (unless (setf tmplist (cdr tmplist)) (return) )
 )

; print tail
 (setf counter 0)
 (print "*")
 (loop (if (= counter len) 
		(return)
		(progn
                	(print "--") 
			(setf counter (add1 counter))
		)
       )
 )
 (print "-*\n")

; return OK
 'ok
)

(defun treath (i j a b)
        (or     (= i a)
                (= j b)
                (= (- i j) (- a b))
                (= (+ i j) (+ a b))
        )
)

(defun conflict (n m board)
  (cond ((endp board) nil)
        ((treath n
                 m
                 (first  (first board))
                 (second (first board))
         )
         t
        )
        (t (conflict n m (rest board)))
  )
)

(defun queen-aux (size &optional (board nil)(n 0)(m 0))
  (unless (= m size)
    (unless (conflict n m board)
      (if (= (add1 n) size)
        (progn (setf *soluzioni* (1+ *soluzioni*)) (print-board (reverse (cons (list n m) board))))
        (queen-aux size (cons (list n m) board)(add1 n) 0)
      )
    )
    (queen-aux size board n (add1 m))
  )
)

(defun second (list) (car(cdr list]

(setf *soluzioni* 0)
(defun queen(size)
  (setf *soluzioni* 0)
  (cond 
	((numberp size)
		(if (> size 0) 
			(queen-aux size) 
			(progn 
			  (print "La dimensione deve essere maggiore di 0\n")
			  nil
		        )
		)
	)
	(t (print "La dimensione deve essere un numero intero maggiore di 0\n")
		nil
	)
  )
  (print "\n Trovate "*soluzioni*" soluzioni\n")
  nil 
)
(print " \"Queen\" risolve il problema delle 8 regine che consiste \n")
(print " nel metterle su di una scacchiera in modo\n")
(print " che non si mangino tra di loro.\n");
(print " La funzione QUEEN risolve il problema in modo generale:\n")
(print " data la dimensione N vengono stampate tutte le scacchiere\n")
(print " con N regine disposte in modo neutrale tra di loro.\n")
(print " Se non esistono soluzioni QUEEN ritorna NIL senza stampare nulla.\n")
(print " USO: >(QUEEN numero-intero) dove numero-intero e' la dimensione\n")
(print " della scacchiera.\n")








