C---------------------------------------------------------
C    TOOLPACK/1    Release: 2.5
C---------------------------------------------------------
C *****************************
C *  Note:  The following macro definition should be set to the
C *         maximum number of symbols expected in any single
C *         program-unit.  On a virtual-memory system, it can
C *         be set to the maximum number of symbols possible,
C *         i.e.    "define(max_pu_syms,max_symbols)"
C *
C *         For non-virtual systems, this may take up too much space,
C *         so make it smaller, e.g.
C *                 "define(max_pu_syms,500)"
C *****************************
C * The following setting is in use at NAG Central Office:
        PROGRAM ISTVW
 
        COMMON/VSIO/IODSYM,IODLST
        INTEGER IODSYM,IODLST
 
        COMMON/VSSYMI/SYMIDX,NSYMS
        INTEGER SYMIDX(1000),NSYMS
 
        INTEGER HEADER(81),SYMPTH(81),LSTPTH(81),I,
     +          YY,MMM,DD,HH,MM,SS,MILLI
 
        INTEGER GETARG,OPEN,CREATE
        EXTERNAL GETARG,OPEN,CREATE,ZYINSY,ZINIT,ZQUIT,ZMESS,PUTLIN,
     +           PUTCH,ZTIME,ZTIMST,ZCHOUT
 
        CALL ZINIT
 
        IF (GETARG(1,SYMPTH,81).EQ.-100) CALL NAMES(1,SYMPTH)
        IF (GETARG(2,LSTPTH,81).EQ.-100) CALL NAMES(2,LSTPTH)
        IF (GETARG(3,HEADER,81).EQ.-100) CALL NAMES(3,HEADER)
 
        IODSYM=OPEN(SYMPTH,0)
        IF (IODSYM.EQ.-1) CALL ERROR('Can''t open symbol path')
        IODLST=CREATE(LSTPTH,1)
        IF (IODLST.EQ.-1) CALL ERROR('Can''t create list path')
 
        CALL ZYINSY(IODSYM)
 
        CALL PUTLIN(HEADER,IODLST)
        CALL ZCHOUT(': Simple Warnings Listing, ',IODLST)
        CALL ZTIME(YY,MMM,DD,HH,MM,SS,MILLI)
        CALL ZTIMST(YY,MMM,DD,HH,MM,SS,HEADER)
        CALL PUTLIN(HEADER,IODLST)
        CALL PUTCH(10,IODLST)
        I=1
 
 100    CALL ZYGSSI(SYMIDX,NSYMS,I)
        IF (NSYMS.EQ.0) THEN
            CALL PUTCH(10,1)
            CALL ZMESS('[ISTVW Normal Termination]',1)
            CALL ZQUIT(-2)
        END IF
        CALL GETDAT
        CALL SRTIDX
        CALL PRINTS
        I=I+1
        GO TO 100
 
        END
C ----------------------------------------------------------------------
C
C       N A M E S   -   Input names of files and so on
C
 
        SUBROUTINE NAMES(NUMBER,STRING)
        INTEGER NUMBER,STRING(81)
 
        INTEGER PROMPT(22,3),JUNK
 
        SAVE PROMPT
 
        INTEGER ZGTCMD
        EXTERNAL ZPRMPT,ZGTCMD
 
C "Input symbol table: "
C "Output listing file: "
C "Header text: "
 
        DATA (PROMPT(I,1),I=1,21)/73,110,112,117,116,32,115,
     +121,109,98,111,108,32,116,97,98,108,101,58,
     +32,129/,
     +       (PROMPT(I,2),I=1,22)/79,117,116,112,117,116,32,
     +108,105,115,116,105,110,103,32,102,105,108,101,
     +58,32,129/,
     +       (PROMPT(I,3),I=1,14)/72,101,97,100,101,114,32,
     +116,101,120,116,58,32,129/
 
        CALL ZPRMPT(PROMPT(1,NUMBER))
        JUNK=ZGTCMD(STRING,0)
 
        END
C ----------------------------------------------------------------------
C
C       G E T D A T   -   Get symbol data
C
 
      SUBROUTINE GETDAT
 
      COMMON/VSSYMI/SYMIDX,NSYMS
      INTEGER SYMIDX(1000),NSYMS
 
      COMMON/VSSYMD/SYMBOL
      INTEGER SYMBOL(8,1000)
 
      INTEGER I
 
      DO 100 I=1,NSYMS
        CALL ZYGTSY(SYMIDX(I),SYMBOL(1,I))
  100 CONTINUE
      END
C ----------------------------------------------------------------------
C
C       S R T I D X   -   Sort symbol index
C
C       Sort key: Symbol type (then) Current position
C                 (Current position is as sorted by name)
C
 
        SUBROUTINE SRTIDX
 
        COMMON/VSSYMI/SYMIDX,NSYMS
        INTEGER SYMIDX(1000),NSYMS
 
        COMMON/VSSYMD/SYMBOL
        INTEGER SYMBOL(8,1000)
 
        INTEGER I,J,K,TMP(8),T
 
C We will use a form of straight insertion
        DO 300 I=2,NSYMS
            J=I-1
C while J>1 and a(i).lt.a(j) do j=j-1
 100        IF (SYMBOL(1,I) .LT. SYMBOL(1,J)) THEN
                J=J-1
                IF (J.GE.1) GOTO 100
            END IF
            J=J+1
            DO 150 T=1,8
 150            TMP(T)=SYMBOL(T,I)
            DO 250 K=I,J+1,-1
                DO 200 T=1,8
 200                SYMBOL(T,K)=SYMBOL(T,K-1)
 250        CONTINUE
            DO 275 T=1,8
 275            SYMBOL(T,J)=TMP(T)
 300    CONTINUE
        END
C ----------------------------------------------------------------------
C
C       P R I N T S   -   Print Symbols
C
C (a) decl_externl: The name appears in an EXTERNAL statement.
C (b) decl_intrins: The name appears in an INTRINSIC statement.
C (c) formal_param:   The  name  is  a  formal  parameter  (dummy
C     argument) of the program unit.
C (d) explicit_typ: The name appears in a type statement,  or  if
C     it  is  a  function subprogram name, has the type specified
C     in the FUNCTION statement.
C (e) in_ASSIGN: The name appears in an ASSIGN statement.
C (f) assigned_to: The name appears on the left-hand side  of  an
C     assignment statement.
C (g) in_READ_list:  The name appears in the input-list of a READ
C     statement.
C (h) in_DATA_stmt: The name appears in a DATA statement.
C (i) stmt_fn_para:  The  name  is  a  formal  parameter   (dummy
C     argument) of a statement function.
C (j) in_EQUIV: The name appears in an EQUIVALENCE statement.
C (k) in_COMMON: The name appears in a COMMON statement.
C (l) used_as_arg:  The  name is used as the actual argument to a
C     called function or subroutine.
C (m) std_intrinsic: The name is that  of  a  standard  intrinsic
C     function.
C (n) fun_called: The name is called as a function.
C (o) in_expr: The name appears in an expression.
C (p) sub_called: The name is called as a subroutine.
C (q) doloop_index:  The name is used as the controlling variable
C     in a DO statement or implicit DO-loop.
C (r) use_bits: This macro is actually the inclusive  or  of  the
C     bits:  formal_param,  in_ASSIGN, assigned_to, in_READ_list,
C     in_DATA_stmt,    stmt_fn_para,    in_EQUIV,    used_as_arg,
C     fun_called, in_expr, sub_called and doloop_index.
C
        SUBROUTINE PRINTS
 
        COMMON/VSIO/IODSYM,IODLST
        INTEGER IODSYM,IODLST
 
        COMMON/VSSYMI/SYMIDX,NSYMS
        INTEGER SYMIDX(1000),NSYMS
 
        COMMON/VSSYMD/SYMBOL
        INTEGER SYMBOL(8,1000)
 
        LOGICAL IMPLI
        INTEGER I,COUNT,MASK,KEY(134),ZIAND
 
        EXTERNAL ZCHOUT,PUTCH,ZOBLNK,ZPTINT,ZIAND
 
        I=0
 100    I=I+1
        IF (SYMBOL(1,I).NE.4) GOTO 100
 
        CALL PUTCH(10,IODLST)
        CALL ZCHOUT('Program Unit: ',IODLST)
        CALL WRNAME(I)
 
        IMPLI = .TRUE.
        MASK  = 16 + 32 + 64 + 128 +
     +          65536 + 4 + 2048 + 1024 +
     +          512
 
        COUNT = 0
        DO 20 I = 1,NSYMS
          CALL ZYGTST(SYMBOL(2,I),KEY)
C
C  CHECK LABELS
C
          IF(SYMBOL(1,I) .EQ. 1) THEN
            IF(SYMBOL(5,I) + SYMBOL(6,I) +
     +         SYMBOL(7,I) .EQ. 0) THEN
              COUNT = COUNT + 1
              CALL ZCHOUT('  Unused Label: ', IODLST)
              CALL ZPTMES(KEY, IODLST)
            ENDIF
C
C  CHECK UNUSED SIMPLE VARIABLES
C
          ELSE IF(SYMBOL(1,I) .EQ. 3) THEN
              COUNT = COUNT + 1
              IF(ZIAND(SYMBOL(6,I), 4) .NE. 0) THEN
                CALL ZCHOUT('  Unused dummy argument: ', IODLST)
              ELSE
                CALL ZCHOUT('  Unused symbol: ', IODLST)
              ENDIF
              CALL ZPTMES(KEY, IODLST)
C
C  CHECK NAMES.....
C
          ELSE IF(SYMBOL(1,I) .EQ. 5) THEN
            IF (ZIAND(SYMBOL(6,I),8).EQ.0 .AND.
     +          IMPLI) THEN
                CALL ZCHOUT('  Implicitly typed variable: ', IODLST)
                COUNT = COUNT + 1
                CALL WRNAME(I)
            END IF
            IF((ZIAND(SYMBOL(6,I), 125936) .EQ. 0) .AND.
     +         (ZIAND(SYMBOL(6,I), 1024) .EQ. 0)) THEN
              COUNT = COUNT + 1
              IF(ZIAND(SYMBOL(6,I), 4) .NE. 0) THEN
                CALL ZCHOUT('  Unused dummy argument: ', IODLST)
              ELSE
                CALL ZCHOUT('  Unused variable: ', IODLST)
              ENDIF
              CALL ZPTMES(KEY, IODLST)
            ELSE IF (ZIAND(SYMBOL(6,I),MASK).EQ.0) THEN
              CALL ZCHOUT('  Variable n'//'ot explicitly set: ', IODLST)
              COUNT = COUNT + 1
              CALL ZPTMES(KEY, IODLST)
            ENDIF
C
C  CHECK STATEMENT FUNCTIONS
C
          ELSE IF(SYMBOL(1,I) .EQ. 8) THEN
            IF(ZIAND(SYMBOL(6,I), 125936) .EQ. 0) THEN
              COUNT = COUNT + 1
              CALL ZCHOUT('  Unused Statement Function: ', IODLST)
              CALL ZPTMES(KEY, IODLST)
            ELSE IF(ZIAND(SYMBOL(6,I), 8) .EQ. 0)THEN
              IF(IMPLI) THEN
                COUNT = COUNT + 1
                CALL ZCHOUT
     +              ('  Implicitly typed Statement Function: ', IODLST)
                CALL WRNAME(I)
              ENDIF
            ENDIF
C
C  CHECK PARAMETERS
C
          ELSE IF(SYMBOL(1,I) .EQ. 6) THEN
            IF(ZIAND(SYMBOL(6,I), 125936) .EQ. 0) THEN
              CALL ZCHOUT('  Unused Parameter: ', IODLST)
              COUNT = COUNT + 1
              CALL ZPTMES(KEY, IODLST)
            ELSE IF(ZIAND(SYMBOL(6,I), 8) .EQ. 0)THEN
              IF(IMPLI) THEN
                CALL ZCHOUT('  Implicitly typed Parameter: ', IODLST)
                COUNT = COUNT + 1
                CALL WRNAME(I)
              ENDIF
            ENDIF
C
C  CHECK EXTERNAL PROCEDURES
C
          ELSE IF(SYMBOL(1,I) .EQ. 7) THEN
            IF(ZIAND(SYMBOL(6,I), 125936) .EQ. 0) THEN
              CALL ZCHOUT('  Unused Procedure: ', IODLST)
              COUNT = COUNT + 1
              CALL ZPTMES(KEY, IODLST)
            ELSE
              IF(ZIAND(SYMBOL(6,I), 8) .EQ. 0)THEN
                IF(ZIAND(SYMBOL(6,I), 4096) .EQ. 0)THEN
                  IF(ZIAND(SYMBOL(6,I), 8192) .NE. 0)THEN
                    IF(IMPLI) THEN
                      CALL ZCHOUT
     +                     ('  Implicitly typed Procedure: ', IODLST)
                      COUNT = COUNT + 1
                      CALL WRNAME(I)
                    ENDIF
                  ENDIF
                ENDIF
              ELSE
                IF(ZIAND(SYMBOL(6,I), 4096) .NE. 0)THEN
                  CALL ZCHOUT('  Typed Standard Intrinsic: .', IODLST)
                  COUNT = COUNT + 1
                  CALL ZPTMES(KEY, IODLST)
                ENDIF
              ENDIF
              IF(ZIAND(SYMBOL(6,I), 4096) .NE. 0) THEN
                IF(ZIAND(SYMBOL(6,I), 2) .EQ. 0)THEN
                  CALL ZCHOUT
     +         ('  Intrinsic procedure n'//'ot in INTRINSIC: ', IODLST)
                  COUNT = COUNT + 1
                  CALL ZPTMES(KEY, IODLST)
                ENDIF
              ELSE IF(ZIAND(SYMBOL(6,I), 1).EQ.0)THEN
                CALL ZCHOUT
     +         ('  External procedure n'//'ot in EXTERNAL: ', IODLST)
                COUNT = COUNT + 1
                CALL ZPTMES(KEY, IODLST)
              ENDIF
            ENDIF
C
C  CHECK THE PROGRAM UNIT ITSELF.....
C
          ELSE IF(SYMBOL(1,I) .EQ. 4) THEN
            IF(SYMBOL(4,I) .GT. 0) THEN
              IF(ZIAND(SYMBOL(6,I), 125936) .EQ. 0) THEN
                CALL ZCHOUT('  Function value n'//'ot set: ', IODLST)
                COUNT = COUNT + 1
                CALL ZPTMES(KEY, IODLST)
              ENDIF
            ENDIF
          ENDIF
C
C  END OF CHECKS, NEXT SYMBOL!
C
   20   CONTINUE
        IF(COUNT .EQ. 0) CALL ZMESS('  No Warnings Detected..', IODLST)
 
        END
C ----------------------------------------------------------------------
C
C       W R N A M E   -   Write symbol name and data type if any
C
 
      SUBROUTINE WRNAME(N)
      INTEGER N
      INTEGER TEXT(134)
      LOGICAL TEST1, TEST2
      CHARACTER*17 TYPTXT(-3:15)
 
      COMMON/VSIO/IODSYM,IODLST
      INTEGER IODSYM,IODLST
 
      COMMON/VSSYMI/SYMIDX,NSYMS
      INTEGER SYMIDX(1000),NSYMS
 
      COMMON/VSSYMD/SYMBOL
      INTEGER SYMBOL(8,1000)
 
      SAVE
 
        DATA TYPTXT/
     +'Main Program.    ',
     +'Block-data.      ',
     +'Routine.         ',
     +'Unknown.         ',
     +'INTEGER.         ',
     +'REAL.            ',
     +'LOGICAL.         ',
     +'COMPLEX.         ',
     +'DOUBLE PRECISION.',
     +'CHARACTER.       ',
     +'DOUBLE COMPLEX.  ',
     +'Generic.         ',
     +'Hollerith.       ',
     +'Label.           ',
     +'Substring spec.  ',
     +'LOGICAL*1.       ',
     +'LOGICAL*2.       ',
     +'INTEGER*2.       ',
     +'REAL*16.         '/
 
      CALL ZYGTST(SYMBOL(2,N),TEXT)
      CALL PUTLIN(TEXT,IODLST)
      CALL ZLEGAL(TEXT, TEST1, TEST2)
 
      IF (SYMBOL(1,N).EQ.1) RETURN
      IF (SYMBOL(1,N).EQ.2) GO TO 10
 
      CALL ZCHOUT(' (',IODLST)
      CALL ZCHOUT(TYPTXT(SYMBOL(4,N)),IODLST)
      IF (SYMBOL(5,N).NE.0) THEN
          CALL PUTCH(42,IODLST)
          IF (SYMBOL(5,N).GT.0) THEN
              CALL ZPTINT(SYMBOL(5,N),1,IODLST)
          ELSE
              CALL ZCHOUT('(?)',IODLST)
          END IF
      END IF
      IF (SYMBOL(1,N).EQ.4 .AND.
     +      SYMBOL(4,N).GT.0) THEN
         CALL ZCHOUT(' FUNCTION)',IODLST)
      ELSE
         CALL ZCHOUT(')',IODLST)
      ENDIF
 
   10 CONTINUE
      IF(TEST1) THEN
        IF(TEST2) CALL PUTCH(10, IODLST)
        IF(.NOT.TEST2)CALL ZMESS(' - Name n'//'ot locally legal',IODLST)
      ELSE
        IF(.NOT.TEST2)CALL ZMESS(' - Name n'//'ot legal', IODLST)
        IF(TEST2)CALL ZMESS(' - Name non-standard',IODLST)
      ENDIF
 
      END
