C---------------------------------------------------------
C    TOOLPACK/1    Release: 3.1
C---------------------------------------------------------
C ----------------------------------------------------------------------
C
C       I S T U N   -   UN-include files
C
C       This program reads in a file produced by ISTIN and replaces the
C       included text from ISTIN with INCLUDE statements.
C
C       Programmed by: Malcolm Cohen, Numerical Algorithms Group,
C                      September 1986.
C
 
        PROGRAM ISTUN
 
        INTEGER IODIN,IODOUT,INPTH(81),OUTPTH(81),PROMPT(14,2)
 
        INTEGER GETARG,OPEN,CREATE,ZGTCMD
        EXTERNAL GETARG,OPEN,CREATE,ZGTCMD,ZINIT,ZQUIT,ERROR
 
C "Input file: "
C "Output file: "
 
        DATA (PROMPT(I,1),I=1,13)/73,110,112,117,116,32,102,
     +105,108,101,58,32,129/,
     +       (PROMPT(I,2),I=1,14)/79,117,116,112,117,116,32,
     +102,105,108,101,58,32,129/
 
        CALL ZINIT
 
        IF (GETARG(1,INPTH,81).EQ.-100) THEN
            CALL ZPRMPT(PROMPT(1,1))
            IF (ZGTCMD(INPTH,0).EQ.-1)
     +          CALL ERROR('Couldn''t get input filename')
        END IF
        IF (GETARG(2,OUTPTH,81).EQ.-100) THEN
            CALL ZPRMPT(PROMPT(1,2))
            IF (ZGTCMD(OUTPTH,0).EQ.-1)
     +          CALL ERROR('Couldn''t get output filename')
        END IF
 
        IODIN=OPEN(INPTH,0)
        IF (IODIN.EQ.-1) CALL ERROR('Can''t open input file')
        IODOUT=CREATE(OUTPTH,1)
        IF (IODOUT.EQ.-1) CALL ERROR('Can''t create output file')
 
        CALL PROCES(IODIN,IODOUT)
        CALL REMARK('[ISTUN Normal Termination]')
        CALL ZQUIT(-2)
 
        END
C ----------------------------------------------------------------------
C
C       P R O C E S   -   Process file
C
 
        SUBROUTINE PROCES(INFD,OUTFD)
        INTEGER INFD,OUTFD
 
        INTEGER BUFF(134),NEST,STATUS,PATTRN(21),REPLCE(11),
     +          NEWBUF(134),ENDFLG(11)
 
        INTEGER GETLIN,ZSETP,ZSETR,ZPREPL,EQUAL
        EXTERNAL GETLIN,PUTLIN,CLOSE,ZSETP,ZSETR,ZPREPL,EQUAL,ERROR
 
C PATTRN: "%&*&$in&$ begin <?+>"
C REPLCE: "include &1"
 
        DATA REPLCE/73,78,67,76,85,68,69,32,38,49,
     +129/,
     +       PATTRN/37,64,42,64,36,105,110,64,
     +36,32,98,101,103,105,110,32,60,63,43,
     +62,129/,
     +       ENDFLG/42,36,105,110,36,32,101,110,100,
     +10,129/
 
        NEST=0
        IF (ZSETP(PATTRN,.TRUE.).EQ.-1) CALL ERROR('ZSETP failed')
        IF (ZSETR(REPLCE).EQ.-1) CALL ERROR('ZSETR failed')
 
 100    STATUS=GETLIN(BUFF,INFD)
        IF (STATUS.EQ.-100) THEN
            CALL CLOSE(INFD)
            IF (NEST.NE.0) CALL ERROR('Incomplete input file')
            RETURN
        ELSE IF (STATUS.EQ.-1) THEN
            CALL ERROR('I/O ERROR READING FILE')
        ELSE IF (BUFF(1).EQ.42) THEN
            IF (ZPREPL(BUFF,NEWBUF,.FALSE.).NE.-1) THEN
                IF (NEST.EQ.0) CALL PUTLIN(NEWBUF,OUTFD)
                NEST=NEST+1
            ELSE IF (EQUAL(BUFF,ENDFLG).EQ.-2) THEN
                NEST=NEST-1
                IF (NEST.LT.0) CALL ERROR('TOO MANY END MARKERS')
            ELSE IF (NEST.EQ.0) THEN
                CALL PUTLIN(BUFF,OUTFD)
            END IF
        ELSE IF (NEST.EQ.0) THEN
            CALL PUTLIN(BUFF,OUTFD)
        END IF
        GOTO 100
 
        END
