C---------------------------------------------------------
C    TOOLPACK/1    Release: 1.1
C---------------------------------------------------------
C
C  ZRBINT - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  INITIALISE AN ARRAY AS A RING BUFFER FOR POSSIBLE USE AS
C  A STACK (LIFO) OR QUEUE (FIFO).
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' (THE SIZE OF THE ARRAY
C  OR SPECIFIED WIDTH IS WRONG) OR THE MAXIMUM ARRAY DEPTH. THERE IS
C  AN OVERHEAD OF 8 LOCATIONS RESERVED BY THE ROUTINES. NOT ALL THE
C  RESERVED LOCATIONS ARE USED AT PRESENT.
C
      INTEGER FUNCTION ZRBINT(ARRAY, SIZE, WIDTH)
 
      INTEGER SIZE, WIDTH
      INTEGER ARRAY(*)
 
      ZRBINT = -1
      IF(WIDTH .LE. 0)         RETURN
      IF(SIZE  .LT. WIDTH + 8) RETURN
 
C  IDENTIFY THE ARRAY AS A RING BUFFER
      ARRAY(1) = 114
C  THE SIZE OF THE ARRAY
      ARRAY(2) = SIZE
C  THE WIDTH OF EACH ELEMENT
      ARRAY(3) = WIDTH
C  THE MAXIMUM NUMBER OF ELEMENTS THAT CAN BE STORED IN THE BUFFER
      ARRAY(4) = (SIZE - 8) / WIDTH
C  THE NUMBER OF ELEMENTS CURRENTLY STORED IN THE BUFFER
      ARRAY(5) = 0
C  THE LAST  ELEMENT IN THE BUFFER
      ARRAY(6) = 0
C  THE FIRST ELEMENT IN THE BUFFER
      ARRAY(7) = 0
C  UNUSED
      ARRAY(8) = 0
 
      ZRBINT = ARRAY(4)
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZRBTYP - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  RETURN THE TYPE OF A RING BUFFER
C
      INTEGER FUNCTION ZRBTYP(ARRAY, WIDTH, DEPTH, FREE)
 
      INTEGER WIDTH, DEPTH, FREE
      INTEGER ARRAY(*)
 
      ZRBTYP = -1
      IF(ARRAY(1) .NE. 114) RETURN
 
C  THE WIDTH OF EACH ELEMENT
      WIDTH = ARRAY(3)
C  THE MAXIMUM NUMBER OF ELEMENTS THAT CAN BE STORED IN THE BUFFER
      DEPTH = ARRAY(4)
C  THE NUMBER OF ELEMENTS CURRENTLY STORED IN THE BUFFER
      FREE  = DEPTH - ARRAY(5)
 
      ZRBTYP = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZPUSH  - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  PUSH AN ELEMENT ON TO THE END OF A RING BUFFER
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR' OR 'NOERR'
C
      INTEGER FUNCTION ZPUSH(ELEM, ARRAY)
 
      INTEGER I, OFFSET
      INTEGER ELEM(*), ARRAY(*)
 
      ZPUSH = -1
      IF(ARRAY(1) .NE. 114)     RETURN
      ZPUSH = -100
      IF(ARRAY(5) .GE. ARRAY(4)) RETURN
 
C  THE NUMBER OF ELEMENTS CURRENTLY STORED IN THE BUFFER
      IF(ARRAY(5) .EQ. 0) THEN
        ARRAY(6) = 0
        ARRAY(7) = 1
      ENDIF
      ARRAY(5) = ARRAY(5) + 1
 
C  THE NEXT ELEMENT TO BE ADDED TO THE END
      ARRAY(6) = ARRAY(6) + 1
      IF(ARRAY(6) .GT. ARRAY(4)) ARRAY(6) = 1
      OFFSET = 8 + (ARRAY(3) * (ARRAY(6) - 1))
      DO 10 I = 1, ARRAY(3)
        ARRAY(OFFSET + I) = ELEM(I)
   10 CONTINUE
 
      ZPUSH = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZPOP   - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  POP AN ELEMENT FROM THE END OF A RING BUFFER USED AS A STACK
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR', 'NOERR' OR 'EOF'
C
      INTEGER FUNCTION ZPOP(ELEM, ARRAY)
 
      INTEGER I, OFFSET
      INTEGER ELEM(*), ARRAY(*)
 
      ZPOP = -1
      IF(ARRAY(1) .NE. 114) RETURN
      ZPOP = -100
      IF(ARRAY(5) .LE. 0)    RETURN
 
C  THE NUMBER OF ELEMENTS CURRENTLY STORED IN THE BUFFER
      ARRAY(5) = ARRAY(5) - 1
 
C  THE NEXT ELEMENT TO BE TAKEN FROM THE END
      OFFSET = 8 + (ARRAY(3) * (ARRAY(6) - 1))
      DO 10 I = 1, ARRAY(3)
        ELEM(I) = ARRAY(OFFSET + I)
   10 CONTINUE
      ARRAY(6) = ARRAY(6) - 1
      IF(ARRAY(6) .LE. 0) ARRAY(6) = ARRAY(4)
 
      ZPOP = -2
 
      RETURN
      END
C----------------------------------------------------------------------
C
C  ZRBGET  - 05 MAR 84
C           TIE LIBRARY
C           TABLES SUPPLEMENTARY LIBRARY
C
C  TAKE AN ELEMENT FROM THE END OF A RING BUFFER USED AS A QUEUE
C
C  THE VALUE OF THE FUNCTION IS EITHER 'ERR', 'NOERR' OR 'EOF'
C
      INTEGER FUNCTION ZRBGET(ELEM, ARRAY)
 
      INTEGER I, OFFSET
      INTEGER ELEM(*), ARRAY(*)
 
      ZRBGET = -1
      IF(ARRAY(1) .NE. 114) RETURN
      ZRBGET = -100
      IF(ARRAY(5) .LE. 0)    RETURN
 
C  THE NUMBER OF ELEMENTS CURRENTLY STORED IN THE BUFFER
      ARRAY(5) = ARRAY(5) - 1
 
C  THE NEXT ELEMENT TO BE TAKEN FROM THE END
      OFFSET = 8 + (ARRAY(3) * (ARRAY(7) - 1))
      DO 10 I = 1, ARRAY(3)
        ELEM(I) = ARRAY(OFFSET + I)
   10 CONTINUE
      ARRAY(7) = ARRAY(7) + 1
      IF(ARRAY(7) .GT. ARRAY(4)) ARRAY(7) = 1
 
      ZRBGET = -2
 
      RETURN
      END
