#! /bin/csh
#  vcon is a csh script to provide text level version control using ISTVC.
#
#
#  Invocation:
#
#  vcon <option> version_file source_file
#
#  where option is one of
#
#    -u: Update (create) version_file using source_file as the
#        next (first) version.  User is invited to make comments.
#
#    -n: Same as -u except that user is not invited to make comments.
#
#    -e: If version_file exists, edit the most recent version and
#        update using the edited file as the next version.  If
#        version_file does not exist, invoke the editor to create
#        Version 1.
#
#    -r: version_file is assumed to exist and is reinitialized
#        with the latest version as Version 1.
#
#    -v[n]: Output version n to standard output.  If n is missing,
#        output the latest version.
#
#    -tY/M/D/H/m/S: Output version current as of year Y, month M,
#        day D, hour H, minute m, second S.  Least significant
#        units are 0 if omitted.
#
#    -d[n]: Output differences between version n-1 and version n.
#        If n is missing, output all differences.
#
#    -c[n]: Output time created and comments appended when creating
#        version n.  If n is missing, output all comments.
#
#  Note: source_file is required only with options -u and -n.
#
#  Check command line validity.
if ( $#argv < 2 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"vcon <option> version_file source_file"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
where option is one of
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -u: Update (create) version_file using source_file as the"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      next (first) version.  User is invited to make comments."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -n: Same as -u except that user is not invited to make comments."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -e: If version_file exists, edit the most recent version and"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      update using the edited file as the next version.  If"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      version_file does not exist, invoke the editor to create"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      Version 1."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -r: version_file is assumed to exist and is reinitialized"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      with the latest version as Version 1."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -v[n]: Output version n to standard output.  If n is missing,"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      output the latest version."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -tY/M/D/H/m/S: Output version current as of year Y, month M,"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      day D, hour H, minute m, second S.  Least significant"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      units are 0 if omitted."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -d[n]: Output differences between version n-1 and version n."
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      If n is missing, output all differences."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"  -c[n]: Output time created and comments appended when creating"
TOOLPACKPATH/toolpack1.2/util/echoerr \
"      version n.  If n is missing, output all comments."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"Note: source_file is required only with options -u and -n."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  vcopt contains <option>.
set vcopt = $1
#  key contains u, n, e, r, v, t, d, or c depending on option.
set key = `TOOLPACKPATH/toolpack1.2/util/char2 $vcopt`
#  vcvers contains the name of the version file.
set vcvers = $2
#  srcdest contains the name of either the source or destination file.  The
#  name may be null if neither file is used for the requested option.
#  tmpsrc contains the name of a scratch file.
set srcdest = $3
set tmpsrc = src$$
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
echo > _.TOOLPACK/$tmpsrc
#  pfsflag will be reset to true when the source/destination file is
#  in the PFS or is standard output.
set pfsflag = false
if ( $key == "e" ) then
#  If $vcvers exists, invoke ISTVC with option v to produce latest version
#  as $tmpsrc .  Edit $tmpsrc to produce a source file for updating or
#  creating $vcvers .
   if ( -e $vcvers == 1 ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
-v \#$vcvers $tmpsrc
TOOLPACKPATH/toolpack1.2/exec/istvc.u
   endif
#  Edit $tmpsrc and make edited version a source file.
   onintr -
   vi _.TOOLPACK/$tmpsrc
   onintr
   set srcdest = $tmpsrc
#  The later updating process must be informed that the temporary file
#  is in the PFS.
   set pfsflag = true
#  Reset vcopt for updating.
   set vcopt = "-u"
else if ( $key == "r" ) then
#  Reinitialize $vcvers with the latest version as Version 1.
   if ( -e $vcvers == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Version file must exist.  To create a version file,
TOOLPACKPATH/toolpack1.2/util/echoerr \
use option "-e" or option "-u".
      exit
   endif
TOOLPACKPATH/toolpack1.2/util/mkipf \
-v \#$vcvers $tmpsrc
TOOLPACKPATH/toolpack1.2/exec/istvc.u
   /bin/rm $vcvers
   set srcdest = $tmpsrc
   set pfsflag = true
   set vcopt = "-u"
else if ( $key == "v" || $key == "t" ) then
#  Set destination file to standard output.
   set srcdest = \#1
   set pfsflag = true
endif
#  Create the interprocess file IST.CMD and append parameters for ISTVC.
if ( $pfsflag == true ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$vcopt \#$vcvers $srcdest
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$vcopt \#$vcvers \#$srcdest
endif
#
#  Invoke ISTVC.
#
TOOLPACKPATH/toolpack1.2/exec/istvc.u
#
#  Remove the scratch file unless the changes are too complicated to create
#  a new version.  In this case, ISTVC will terminate with a status of ERROR
#  in _.info .  If the attempt at a complicated update occurs using option e,
#  copy the edited source to a working directory file called _.SAVEDFILE .
#  If the attempt at a complicated update occurs using options u or n,
#  then the source file exists and it is only necessary to inform
#  the user of the action taken.
#
if ( `cat _.TOOLPACK/_.info` == -1 ) then
   if ( $key == "e" ) then
      cp _.TOOLPACK/$tmpsrc _.SAVEDFILE
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Edited source saved in "_.SAVEDFILE".'
   else if ( $key == "u" || $key == "n" ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$vcvers' not updated."
   endif
endif
#
/bin/rm -r _.TOOLPACK
#
