#! /bin/csh
#  ucs is a csh script to unroll, condense, and make eliminations and
#  substitutions in Fortran DO loops using ISTUD, ISTCD, and ISTSB.
#
#
#  Invocation:
#
#  ucs depth Polish_option_file Fortran_source_file
#
#  Check command line validity.
if ( $#argv < 3 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"ucs depth Polish_option_file Fortran_source_file"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"depth specifies the unrolling depth (see references in Users' Guide)."
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Polish_option_file is created by using script "polx".'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'"-" in place of Polish_option_file gives default formatting options.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Transformed code is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  "-" as Polish_option_file gives default options.
if ( $2 != -) then
#  Check that Polish_option_file exists.
   if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist."
      exit
   endif
endif
#  Check that Fortran_source_file exists.
if ( -e $3 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$3' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = lx.src$$
expand $3 > _.TOOLPACK/$src
#  Lexer token stream file name.
set tkn = _.lxtkn
#  Lexer comment file name.
set cmt = _.lxcmt
#  Create the interprocess file IST.CMD and append parameters for ISTLX.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src - $tkn $cmt
#
#  Invoke ISTLX.
#
TOOLPACKPATH/toolpack1.2/exec/istlx.u
#
#  If lexer errors are reported, advise user to obtain listing and exit.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Program has lexical scanning errors.  Invoke script "getlst"'
TOOLPACKPATH/toolpack1.2/util/echoerr \
to obtain a listing showing statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   /bin/rm -r _.TOOLPACK
   exit
endif
#  Output token stream file name.
set tknout = _.tknout
#  Output comment stream file name.
set cmtout = _.cmtout
#  Create the interprocess file IST.CMD and append parameters for ISTUD.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tknout $cmtout $1
#
#  Invoke ISTUD.
#
TOOLPACKPATH/toolpack1.2/exec/istud.u
#
#  Set up the output from ISTUD as input to ISTCD.
mv _.TOOLPACK/$tknout _.TOOLPACK/$tkn
mv _.TOOLPACK/$cmtout _.TOOLPACK/$cmt
#  Create the interprocess file IST.CMD and append parameters for ISTCD.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tknout $cmtout
#
#  Invoke ISTCD.
#
TOOLPACKPATH/toolpack1.2/exec/istcd.u
#
#  The variable 'condense' is initialized to 'no' and will be reset to
#  'yes' if ISTCD is repeated at least once, thereby indicating that
#  some condensation has occurred.
set condense = no
#  If the termination flag is TERMFLAG_0 (= -2000) or TERMFLAG_1 (= -2001)
#  repeat ISTCD, invoking ISTSB first if the flag is TERMFLAG_1.
while ( `cat _.TOOLPACK/_.info` == -2000 || `cat _.TOOLPACK/_.info` == -2001 )
   set condense = yes
   if ( `cat _.TOOLPACK/_.info` == -2001 ) then
#  Set up the output from ISTCD as input to ISTSB.
      mv _.TOOLPACK/$tknout _.TOOLPACK/$tkn
      mv _.TOOLPACK/$cmtout _.TOOLPACK/$cmt
#  Create the interprocess file IST.CMD and append parameters for ISTSB.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tknout $cmtout
#
#  Invoke ISTSB (ISTSB is re-entered internally if substitutions are made).
#
TOOLPACKPATH/toolpack1.2/exec/istsb.u
#
   endif
#  Set up the output from ISTCD or ISTSB as input to ISTCD.
   mv _.TOOLPACK/$tknout _.TOOLPACK/$tkn
   mv _.TOOLPACK/$cmtout _.TOOLPACK/$cmt
#  Create the interprocess file IST.CMD and append parameters for ISTCD.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tknout $cmtout
#
#  Invoke ISTCD.
#
TOOLPACKPATH/toolpack1.2/exec/istcd.u
end
#  Set up the output from ISTCD as input to ISTSB.
mv _.TOOLPACK/$tknout _.TOOLPACK/$tkn
mv _.TOOLPACK/$cmtout _.TOOLPACK/$cmt
#  Set up the interprocess file IST.CMD and append parameters for ISTSB.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt $tknout $cmtout
#
#  Invoke ISTSB (ISTSB is re-entered internally if substitutions are made).
#
TOOLPACKPATH/toolpack1.2/exec/istsb.u
#
#  If no condensation occurred, output the original source.
if ( $condense == no ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
No condensation occurred, original source is output.
   cat $3
else
#  Otherwise, Polish and output the transformed Fortran.
   if ( $2 == - ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tknout $cmtout \#1 -
   else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tknout $cmtout \#1 \#$2
   endif
#
#  Invoke ISTPL.
#
TOOLPACKPATH/toolpack1.2/exec/istpl.u
endif
#
#  Move temporary files (comment indices for generated label control)
#  to the PFS where they will be removed.
mv udcmitmp cdcmitmp _.TOOLPACK
/bin/rm -r _.TOOLPACK
#
