#! /bin/csh
#  statdoc is a csh script to generate documentation information based
#  on information in the symbol table of a Fortran program using ISTAL.
#    (via the combined tool fragment ISTLY = ISTLX/ISTYP and then ISTAL)
#
#
#  Invocation:
#
#  statdoc Fortran_source_file input_file output_file
#
#  Check command line validity.
if ( $#argv < 3 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
statdoc Fortran_source_file input_file output_file
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
input_file is a user-written template of a report that will be written
TOOLPACKPATH/toolpack1.2/util/echoerr \
as output_file.  input_file has the form of a document containing troff
TOOLPACKPATH/toolpack1.2/util/echoerr \
requests.  In the places in the document where information derived from
TOOLPACKPATH/toolpack1.2/util/echoerr \
the symbol table is to be inserted, the user writes a special request
TOOLPACKPATH/toolpack1.2/util/echoerr \
of the form '".al X"' where '"X"' indicates the information to be
TOOLPACKPATH/toolpack1.2/util/echoerr \
inserted.  Following are the acceptable values for X showing the
TOOLPACKPATH/toolpack1.2/util/echoerr \
nature of the information that will be inserted:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_CALL   A graph of the subroutine and function calls'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_X      A simple cross-reference summary of subroutine and function calls'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_F      A full cross-reference summary of subroutine and function calls'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_CO     A report of COMMON block usage'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_SY     A list of symbols and their attributes'
TOOLPACKPATH/toolpack1.2/util/echoerr \
'_W      Warning and error messages about anomolous constructions'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  Check that Fortran_source_file exists.
if ( -e $1 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$1' does not exist."
   exit
endif
#  Check that input_file exists.
if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = ly.src$$
expand $1 > _.TOOLPACK/$src
#  Comment file name.
set cmt = _.lycmt
#  Parse tree file name.
set tree = _.lytree
#  Symbol table file name.
#  Note: Symbol table file name must match that introduced by
#  macro expansion into copy of input_file.
set symb = _.ypsymb
#  Comment index file name.
set indx = _.lyindx
#  Create the interprocess file IST.CMD and append parameters for ISTLY.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src $cmt $tree $symb $indx
#
#  Invoke ISTLY.
#
TOOLPACKPATH/toolpack1.2/exec/istly.u
#  If tool terminated with errors, advise user to obtain listing.  Exit.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Errors detected.  Invoke script "getlst" to obtain a listing showing'
TOOLPACKPATH/toolpack1.2/util/echoerr \
statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   /bin/rm -r _.TOOLPACK
   exit
endif
#  Create the input file for ISTAL by prepending the macro definitions
#  and file loading commands to input_file, and then expanding the macros.
set repin = alin$$
set scratch = scrch$$
cat TOOLPACKPATH/toolpack1.2/util/Statdoc.Head $2 > _.TOOLPACK/$scratch
m4 _.TOOLPACK/$scratch > _.TOOLPACK/$repin
#  Create the interprocess file IST.CMD and append parameters for ISTAL.
TOOLPACKPATH/toolpack1.2/util/mkipf \
$repin \#$3
#
#  Invoke ISTAL.
#
TOOLPACKPATH/toolpack1.2/exec/istal.u
#
/bin/rm -r _.TOOLPACK
#
