#! /bin/csh
#  dapt is a csh script to convert a REAL (DOUBLE PRECISION) version of
#  a Fortran program to DOUBLE PRECISION (REAL) using ISTPT.
#  The declarative part of the converted program is then rebuilt using ISTDS.
#    (via the combined tool fragments ISTQT = ISTLX/ISTYP/ISTPT
#                                 and ISTDT = ISTYP/ISTDS/ISTPL)
#
#
#  Invocation:
#
#  dapt <s or d> decs_option_file Polish_option_file Fortran_source_file
#
#  If the first argument is "s" ("d") then the Fortran in Fortran_source_file
#  will be transformed to a REAL (DOUBLE PRECISION) version.
#
#  decs_option_file is the name of a file containing template options, one per
#  line.  If decs_option_file is "-" then default decs options will be used.
#
#  Polish_option_file is the name of a file containing Polish options used in
#  reconstructing the transformed Fortran.  If Polish_option_file is "-"
#  then default Polish options will be used.
#
#  Check command line validity.
if ( $#argv < 4 || ( $1 != "s" && $1 != "d" ) ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
Invocation:
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
"dapt <s or d> decs_option_file Polish_option_file Fortran_source_file"
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
The first argument is s or d indicating that the transformed
TOOLPACKPATH/toolpack1.2/util/echoerr \
program is to be single or double precision, respectively.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
For information about decs_option_file, see Users\' Guide.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Polish_option_file is created by using script "polx".'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Note: "-" in place of either or both option files gives default options.'
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
Transformed code is sent to standard output and may be redirected to a file.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   exit
endif
#  "-" as decs_option_file gives default options.
if ( $2 != - ) then
#  Check that decs_option_file exists.
   if ( -e $2 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$2' does not exist. '-' as the second argument gives default decs options."
      exit
   endif
endif
#  "-" as Polish_option_file gives default options.
if ( $3 != - ) then
#  Check that Polish_option_file exists.
   if ( -e $3 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$3' does not exist. '-' as the third argument gives default Polish options."
      exit
   endif
endif
#  Check that Fortran_source_file exists.
if ( -e $4 == 0 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr \
"'$4' does not exist."
   exit
endif
#
#  Create PFS.  If PFS already exists, exit with an advisory message.
#
if ( -e _.TOOLPACK == 0 ) then
   mkdir _.TOOLPACK
else
TOOLPACKPATH/toolpack1.2/util/echoerr \
Toolpack-created directory '"_.TOOLPACK"' exists. \
Remove with script '"discard"'.
   exit
endif
#  Make a tab-free copy of the Fortran source and use it as source.
set src = qt.src$$
expand $4 > _.TOOLPACK/$src
#  Output token stream file name.
set tkn = _.qttkn
#  Output comment file name.
set cmt = _.qtcmt
#  Create the inter-process file IST.CMD and append parameters for ISTQT.
if ( $1 == "s" ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src $tkn $cmt 'single'
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$src $tkn $cmt 'double'
endif
#
#  Invoke ISTQT.
#
TOOLPACKPATH/toolpack1.2/exec/istqt.u
#
#  If tool terminated with errors, advise user to obtain listing.  Exit.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Errors detected.  Invoke script "getlst" to obtain a listing showing'
TOOLPACKPATH/toolpack1.2/util/echoerr \
statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
   /bin/rm -r _.TOOLPACK
   exit
endif
#  Create the inter-process file IST.CMD and append parameters for ISTDT.
if ( $2 == - ) then
   set decsoptfile = 'mode=rebuild_declaratives'
else
   set decsoptfile = `cat $2`
endif
if ( $3 == - ) then
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt \#1 "$decsoptfile" -
else
TOOLPACKPATH/toolpack1.2/util/mkipf \
$tkn $cmt \#1 "$decsoptfile" \#$3
endif
#
#  Invoke ISTDT.
#
TOOLPACKPATH/toolpack1.2/exec/istdt.u
#
#  If tool terminated with errors, advise user to obtain listing.
if ( `cat _.TOOLPACK/_.info` == -1 ) then
TOOLPACKPATH/toolpack1.2/util/echoerr ""
TOOLPACKPATH/toolpack1.2/util/echoerr \
'Errors detected.  Invoke script "getlst" to obtain a listing showing'
TOOLPACKPATH/toolpack1.2/util/echoerr \
statement and token numbers.
TOOLPACKPATH/toolpack1.2/util/echoerr ""
endif
#
/bin/rm -r _.TOOLPACK
#
