/*-------------------------------*/
/*   TOOLPACK/1   Release: 1.1   */
/*-------------------------------*/
 
#include <ctype.h>
#include "define.h"
 
#include <sys/types.h>
#include <sys/time.h>
#ifdef sgi
#include <time.h>
#endif
 
 
#include <sys/stat.h>
 
#include <sys/dir.h>
 
#include "globals1.h"
#include "globals2.h"
#include "globals.h"
 
 
 
getarg_(n, buffer, maxsiz)
int *n, *buffer, *maxsiz;
{
 
	/* Read inter process argument n into buffer (truncating to
	   maxsiz-1 characters if necessary) and terminate it with
	   an EOS marker. Return the length of the string in length
	   or EOF if the argument n does not exist.
 
	   Maximum length of arguments = MAXLINE
 
	   n = -2  return the name of the local directory (global -
		   lcldir) as set by ZLOCAL in the previous tool.
 
	   n = -1  return the name of the root directory (global -
		   root) as set by ZSETDV in the previous tool.
 
	   n =  0  return the name of the next tool to be scheduled
		   as set by ZTOOL or ZSETOL by the previous tool.
 
	   n =  1, MAXPRAM   return the nth argument
 
	   All strings are truncated, if necessary, to MAXSIZ-1
	   characters */
 
	   int i;
	   char *p;
 
	  *buffer = EOS;
 
	   if (*n < -2 || *n > MAXPRAM) return(EOF);
 
	   if ( (p = inparam[ (*n) + 2] ) == NULLST) return(EOF);
 
	   i = 1;
	   while ( *p != EOSCH && i++ < *maxsiz) zcctoi_(p++, buffer++);
	   *buffer = EOS;
	   return (i-1);
 
}
zgtarg_(n, buffer, maxsiz)
int *n, *buffer, *maxsiz;
{
 
	/* Read inter process argument n into buffer (truncating to
	   maxsiz-1 characters if necessary) and terminate it with
	   an EOS marker. Return the length of the string in length
	   or EOF if the argument n does not exist.
 
	   Maximum length of arguments = MAXLINE
 
	   n = -2  return the name of the local directory (global -
		   lcldir) as set by ZLOCAL .
 
	   n = -1  return the name of the root directory (global -
		   root) as set by ZSETDV .
 
	   n =  0  return the name of the next tool to be scheduled
		   as set by ZTOOL or ZSETOL by the previous tool.
 
	   n =  1, MAXPRAM   return the nth argument
 
	   All strings are truncated, if necessary, to MAXSIZ-1
	   characters */
 
	   int i;
	   char *p;
 
	   *buffer = EOS;
 
	   if (*n < -2 || *n > MAXPRAM) return(EOF);
 
	   if (*n <= 0)
		p = outparm[ (*n) + 2];
	   else
	        p = inparam[ (*n) + 2];
 
	   if (p == NULLST) return(EOF);
 
 
	   i = 1;
	   while ( *p != EOSCH && i++ < *maxsiz) zcctoi_(p++, buffer++);
	   *buffer = EOS;
	   return (i-1);
 
}
 
 
zinit_()
{
 
	/* tie startup routine */
 
	char charnm1[MAXPATH], *malloc();
	int istname[MAXPATH], mode = READ, one = 1, istval[MAXNAME];
	int fd, i, len, sign, *ptr, pmode = WRITE;
	struct filinfo finf;
 
	/* set up other device files */
	files[STDIN].access = files[STDIN].caccess = READ;
	files[STDIN].chrleft = 0;
	files[STDIN].bufp = files[STDIN].buffer;
	files[STDOUT].access = files[STDOUT].caccess =  WRITE;
	files[STDOUT].chrleft = 0;
	files[STDOUT].bufp = files[STDOUT].buffer;
	files[STDERR].access = files[STDERR].caccess =  WRITE;
	files[STDERR].chrleft = 0;
	files[STDERR].bufp = files[STDERR].buffer;
 
	/* set global dirp to NULLST to prevent closing non-open
	   directory in first call to zlocal */
	dirp = (DIR*) NULLST;
 
	/* mark all other files as NOTOPEN */
	for (i=FIRSTFD; i <= MAXFILE; files[i++].access = NOTOPEN);
 
	/* set all inparam (inter process comms info from last call)
	 and outparam (inter process comms info from  this call)
	 to NULLST - by default there is no argument */
 
	/* C arrays start from 0 not -2 */
	for (i=0; i <= MAXPRAM+2; inparam[i] = outparm[i] = NULLST) i++;
 
	/* open the inter process communication file
	   Translate the name to IST characters - groan ! */
	chist_(IPCFILE, ipcfile, strlen(IPCFILE));
	mode = READ;
 
	if (( fd = open_(ipcfile, &mode)) == -1) {
		/* open fails - file non-existant or wrong permission */
		ipcexst = NO;
		statswd = OK;
		inparam[0] = malloc(strlen(LOCALDIR)+1);
		strcpy(inparam[0],LOCALDIR);
		inparam[1] = malloc(strlen(ROOTDIR)+1);
		strcpy(inparam[1],ROOTDIR);
		inparam[2] = malloc(strlen(CENAME)+1);
		strcpy(inparam[2],CENAME);
	}
	else { /* read the inter process information */
 
		/* get status and turn it into an integer */
		/* when shell scripts used as user interface, */
		/* value of ipcexst changed to NO ...wrc */
#ifdef SHELL_SCRIPTS
		ipcexst = NO;
#else
		ipcexst = YES;
#endif
		zgtcmd_(istname, &fd);
		sign = getwrd_(istname, &one, istval);
		ptr = istval;
		sign = 1;
		if (*ptr == MINUS) {
			sign = -1;
			ptr++;
		}
		one = 1;
		statswd = sign*ctoi_(ptr, &one);
 
		/* next get local directory, root directory, next tool
		   and the old arguments */
		for (i=0; i <= MAXPRAM+2; i++) {
			len = zgtcmd_(istname, &fd);
			/* copy into malloced space */
			if (len != 0 ) {
				inparam[i] = malloc(len+1);
				istchr_(istname, inparam[i]);
			}
		}
		/* close the inter process communication file and return fd */
		close(fd);
	}
 
	/* copy into global names, check files, directories etc */
	/* first translate characters to IST */
	chist_(inparam[1], istname, strlen(inparam[1]));
	zsetdv_(istname);
 
	/* now set up spooler file */
	/*first make sure we get fd = 3 for the spooler file
	  which is why we need to do this before the call to zlocal
	  because zlocal grabs an fd to open the directory for zrddir */
	chist_(SPFLNAME, istname, strlen(SPFLNAME));
	fd = create_(istname, &pmode);
	/* moan if not the channel we expected or defines screwed */
	if (fd != STDLST) remark_(" fd != STDLST on opening spooler file",37L);
	if (FIRSTFD <= DEVFD) remark_(" FIRSTFD <= DEVFD in defines ",29L);
 
	chist_(inparam[0], istname, strlen(inparam[0]));
	zlocal_(istname);
	ztool_();
 
	/* set global opnrec0 to 0 to prevent user access to
	record zero of direct access files */
	opnrec0 = 0;
	files[STDLST].access = files[STDLST].caccess =  WRITE;
	files[STDLST].chrleft = 0;
	files[STDLST].bufp = files[STDLST].buffer;
 
}
 
zsetdv_(name)
int *name;
{
 
	/* change the current vfs root system to name. Also set the
	   appropriate inter-process parameter to name (global root).
	   This routine would normally be used only by the command
	   interpreter. If name is the null string the default system
	   is selected */
	
	char charnm1[MAXPATH];
 
	istchr_(name, charnm1);
 
	if (strlen(charnm1) == 0) strcpy(root, ROOTDIR);
 
	else {
		if (isadir(charnm1) == NO) return(ERR);
		strcpy(root, charnm1);
	}
 
	return(NOERR);
}
 
zstats_(status)
int *status;
{
 
	/* Recover the value of the inter-process status word */
	
	/* set to 'kill' by the IST command interpreter prior
	   to tool invocation and is only reset during a ZQUIT
	   or ZEXIT operation */
 
	*status = statswd;
 
		return(statswd);
 
}
 
zptarg_(n, buffer)
int *n, *buffer;
{
 
	/* Set the inter process argument n to the contents of buffer.
	This allows a tool to pass arguments back to its operating
	environment. This routine is also used by the command interprter
	to pass information to the tool being scheduled. buffer may
	contain at most MAXLINE charcaters */
 
	char *p, *malloc(), charnm1[MAXPATH];
	int len;
 
	if (*n >= 1 && *n <= MAXPRAM) {
		len = length_(buffer) + 1;
		istchr_(buffer, charnm1);
		p = malloc(len);
		strcpy(p, charnm1);
		outparm[ (*n)+2] = p;
	}
 
	return;
 
}
 
zsetol_(name)
int *name;
{
 
	/* Set the name of the next tool to be invoked. Not normally called
	   by a tool as the normal return is to the IST command interpreter
	   which is the default condition set up by zinit */
 
	char charnm1[MAXBUFF];
 
	istchr_(name, charnm1);
 
	strcpy(nxttool, charnm1);
 
	return;
 
}
 
ztool_()
{
 
	/* Copy the tool name from the inter-process communication file
	   to the nxttool parameter. This routine is used by the high level
	   command interpreter when processes are spawned */
 
	strcpy(nxttool, inparam[2]);
 
	return;
 
}
 
 
zexit_(status)
int *status;
{
 
	/* termination (permanent or temporary) of a  command interpreter
	   or command executor. Either a further tool is to be executed
	   or shutdown is required. In both cases all open files need to
	   be closed, device buffers flushed and the spool file sent for
	   printing and removed. If a further tool is to be run an inter
	   process communication file is also written */
 
	int fderr = STDERR;
	char temp[MAXPATH];
 
	/* see if we are in shutdown mode */
	/*if (*status != OK || nxttool == "KILL" || nxttool == "kill" ||*/
        if (nxttool == "KILL" || nxttool == "kill" ||
	    strlen(nxttool) == 0 || strlen(nxttool) > MAXPATH ) {
		 /*remark_("[TIE: Terminated].", &fderr, 18L);*/
		 remark_("[TIE: Terminated].", 18L);
		 /* remove the inter process communication file */
		 remove_(ipcfile);
 
		 /* clean up and exit */
		 xexit();
		 exit(0);
	}
 
	else {
		/* output ipc file, tidy up and execute next tool */
		writipc(status);
		xexit();
		execl(strcat(strcpy(temp,TOOLPRX),nxttool), nxttool, (char*) 0);
		remark_("EXECL FAILS attempting to run.", 30L);
		zmess_(nxttool, &fderr, strlen(nxttool));
		exit(1);
	}
 
}
 
zquit_(status)
int *status;
{
 
	/* termination routine for either a command interpreter scheduled
	   tool (ipcexst == YES) or standalone tool (ipcexst == NO) */
 
	char temp[MAXPATH];
	int fderr = STDERR, i, width = 4;
 
	if (ipcexst == YES) {
		/* command interpreter scheduled tool */
		writipc(status);
		xexit();
 
		/* schedule the command interpreter */
		execl(strcat(strcpy(temp,TOOLPRX), CENAME), CENAME, (char*) 0);
		remark_("EXECL FAILS attempting to schedule command interpreter"
		       , 54L);
		exit(1);
	}
 
	else {
		/* stand alone mode - output next tool and parameters */
#ifdef SHELL_SCRIPTS
		/* remove inter-process file  */
		remove_(ipcfile);
		/* write the termination status to an information file */
		outinfo(status);
#endif
		if (*status != OK) outcmps(status);
		xexit();
		if (strlen(nxttool)!=0 && strcmp(nxttool,CENAME)!=0) {
 
			for (i=1; i<=MAXPRAM; i++){
				if (outparm[i] != NULLST) {
					zchout_("Parameter .", &fderr, 11L);
					zptint_(&i, &width, &fderr);
					zchout_(" = ", &fderr, 3L);
					zmess_(outparm[i], &fderr, strlen(outparm[i]));
				}
			}
		}
		exit(0);
	}
}
