/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.13 of 17-July-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * term-dj.c ---	Terminal driver for DOS and OS/2 with DJGPP,
 *			there is almost nothing to do.
 *
 * Adapted from term-emx.c by Antonio Costa (acc@asterix.inescn.pt)
 * Works in 25 and 50 lines text modes (at least).
 *
 * (duz 24Feb94)
 * (acc 27Jul94)
 */

#include "forth.h"
#include "term.h"

#include <pc.h>
#include <ctype.h>

Byte *
rawkey_string [NO_OF_KEYS] =	/* what function keys send */
{
  "\377;", "\377<", "\377=", "\377>", "\377?",
  "\377@", "\377A", "\377B", "\377C", "\377D",
  "\377K", "\377M", "\377H", "\377P",
  "\377G", "\377O", "\377Q", "\377I",
  NULL,	   "\377S", NULL,    "\377R",
  NULL,    NULL,    NULL,    NULL,    /*"\r"*/
};

int tty_interrupt_key (char ch)		{ return 0; }
void interactive_terminal (void)	{}
void system_terminal (void)		{}
void query_winsize (void)		{}

int
prepare_terminal (void)
{
  setbuf (stdout, NULL);
  cols = ScreenCols ();
  rows = ScreenRows ();
  return 1;
}

int
keypressed (void)
{
  return kbhit ();
}

#undef getkey

static int nextkey = 0;

int newgetkey (void)
{
  int key;

  if (nextkey)
    {
      key = nextkey;
      nextkey = 0;
      return key;
    }
  key = getkey ();
  if (key > 255)
    {
      nextkey = key & 255;
      return 255;
    }
  return key;
}

#define BLINK        0x0080
#define INTENSITY    0x0008
#define BW_NORMAL    0x0007
#define BW_UNDERLINE 0x0004
static int attribs = BW_NORMAL;

#if 1
void
c_putc (char c)
{
  int row, col;

  if (attribs == BW_NORMAL || iscntrl(c))
    {
      putchar (c);
      return;
    }
  ScreenGetCursor (&row, &col);
  ScreenPutChar (c, attribs, col, row);
  ScreenSetCursor (row, col + 1);
}
void
c_puts (const char *s)
{ 
  int i;

  if (attribs == BW_NORMAL)
    {
      fputs (s, stdout);
      return;
    }
  for (i = 0; s[i]; i++)
    c_putc(s[i]);
}
#else
void c_putc (char c)		{ putchar (c); }
void c_puts (const char *s)	{ fputs (s, stdout); }
#endif

void c_gotoxy (int x, int y)	{ ScreenSetCursor (y, x); }
void c_wherexy (int *x, int *y)	{ ScreenGetCursor (y, x); }

static void
addxy (int x, int y)
{
  int col, row;

  ScreenGetCursor (&row, &col);
  ScreenSetCursor (row + y, col + x);
}

void c_goleft (void)		{ addxy (-1,  0); }
void c_goright (void)		{ addxy ( 1,  0); }
void c_goup (void)		{ addxy ( 0, -1); }
void c_godown (void)		{ addxy ( 0,  1); }

void c_clrscr (void)		{ ScreenClear (); ScreenSetCursor (0, 0); }
void c_home (void)		{ ScreenSetCursor (0, 0); }
void c_clreol (void)
{
  int i, col;

  ScreenGetCursor (&i, &col);
  for (i = col; i < cols; i++)
    putchar (' ');
}

void
c_clrdown (void)
{
  int i, row, col;

  ScreenGetCursor (&row, &col);
  clreol ();
  for (i = row + 1; i < rows; i++)
    {
      gotoxy (0, i);
      clreol ();
    }
  gotoxy (col, row);
}

void c_bell (void)		{ putchar ('\a'); }

void c_standout_on (void)	{ attribs |= INTENSITY; }
void c_standout_off (void)	{ attribs &= ~INTENSITY; }
void c_bright (void)		{ standout_on (); }
void c_reverse (void)		{ attribs = ((attribs & 0x0007) << 4) |
					    (attribs & 0x0088); }
void c_blinking (void)		{ attribs |= BLINK; }
void c_normal (void)		{ attribs = BW_NORMAL; }
void c_underline_on (void)	{ attribs = (attribs&0x00F8) | BW_UNDERLINE; }
void c_underline_off (void)	{ attribs = BW_NORMAL; }
